/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.dao.impl;

import cn.jsprun.dao.WordsDao;
import cn.jsprun.domain.Words;
import cn.jsprun.utils.HibernateUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordsDaoImple
implements WordsDao {
    @Override
    public Map getAllWords(int currentpage) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = null;
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Words as w");
            session.flush();
            int totalsize = query.list().size();
            int pagesize = 30;
            int totalpage = 1;
            int startid = 0;
            if (totalsize > pagesize) {
                totalpage = totalsize % pagesize == 0 ? (int)((double)totalsize / (double)pagesize) : (int)(1.0 + (double)totalsize / (double)pagesize);
            }
            if (currentpage > 1) {
                if (currentpage > totalpage) {
                    currentpage = totalpage;
                }
            } else {
                currentpage = 1;
            }
            startid = (currentpage - 1) * pagesize;
            query.setFetchSize(pagesize);
            query.setFirstResult(startid);
            query.setMaxResults(pagesize);
            list = query.list();
            map.put("showlist", list);
            map.put("currentpage", currentpage);
            map.put("totalpage", totalpage);
            map.put("totalsize", totalsize);
            session.flush();
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
            }
            tr = null;
            he.printStackTrace();
        }
        if (tr != null) {
            tr.commit();
        }
        return map;
    }

    @Override
    public Integer delteCollection(String[] ids) {
        int count = -1;
        StringBuffer deleteString = new StringBuffer("delete from Words as w");
        if (ids != null && ids.length > 0) {
            deleteString.append(" where w.id in (");
            int i = 0;
            while (i < ids.length) {
                if (ids[i] != null) {
                    deleteString.append(ids[i]);
                    deleteString.append(",");
                }
                ++i;
            }
            String querystr = deleteString.substring(0, deleteString.length() - 1);
            querystr = String.valueOf(querystr) + ")";
            Transaction tr = null;
            try {
                Session session = HibernateUtil.getSessionFactory().getCurrentSession();
                tr = session.beginTransaction();
                Query query = session.createQuery(querystr);
                count = query.executeUpdate();
                session.flush();
            }
            catch (HibernateException he) {
                if (tr != null) {
                    tr.rollback();
                }
                tr = null;
                he.printStackTrace();
            }
            if (tr != null) {
                tr.commit();
            }
        } else {
            return count;
        }
        return count;
    }

    @Override
    public boolean save(Words words) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.save((Object)words);
            tr.commit();
            return true;
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
            }
            tr = null;
            he.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean findByFindPorperty(Words words) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Words as w where w.find like :find");
            query.setString("find", words.getFind());
            List list = query.list();
            tr.commit();
            if (list.size() > 0) {
                return true;
            }
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
                tr = null;
            }
            he.printStackTrace();
        }
        return false;
    }

    @Override
    public Integer updateWords(Words words) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("update Words as w set w.replacement=:replacement where w.find like :find");
            query.setString("replacement", words.getReplacement());
            query.setString("find", words.getFind());
            query.executeUpdate();
            tr.commit();
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
                tr = null;
            }
            he.printStackTrace();
        }
        return 1;
    }

    @Override
    public Integer updateWordsList(List<Words> wordsList, List<Words> updateReplaceList) {
        int updateNumber = 0;
        if (wordsList == null || wordsList.size() <= 0) {
            return updateNumber;
        }
        Transaction tr = null;
        try {
            Query query;
            Words words;
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            int i = 0;
            while (i < wordsList.size()) {
                words = wordsList.get(i);
                if (words != null && words.getFind() != null) {
                    query = session.createQuery("update Words as w set w.find = :find  where w.id=:id");
                    query.setString("find", words.getFind());
                    query.setShort("id", words.getId().shortValue());
                    updateNumber += query.executeUpdate();
                }
                ++i;
            }
            i = 0;
            while (i < updateReplaceList.size()) {
                words = updateReplaceList.get(i);
                query = session.createQuery("update Words as w set w.replacement=:replacement where w.id=:id");
                query.setString("replacement", words.getReplacement());
                query.setShort("id", words.getId().shortValue());
                updateNumber += query.executeUpdate();
                ++i;
            }
            tr.commit();
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
            }
            tr = null;
            he.printStackTrace();
        }
        return null;
    }

    @Override
    public String downWordsAll() {
        StringBuffer sb = new StringBuffer();
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Words");
            List list = query.list();
            if (list != null) {
                int i = 0;
                while (i < list.size()) {
                    Words w = (Words)list.get(i);
                    sb.append(w.getFind());
                    if (!w.getReplacement().equals("**")) {
                        sb.append("=");
                        sb.append(w.getReplacement());
                    }
                    sb.append("\n");
                    ++i;
                }
            }
            tr.commit();
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
                tr = null;
            }
            he.printStackTrace();
        }
        return sb.toString();
    }

    @Override
    public Integer deleteAll() throws Exception {
        int num = 0;
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("delete from Words as w");
            num = query.executeUpdate();
            tr.commit();
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
                tr = null;
            }
            he.printStackTrace();
            throw he;
        }
        return num;
    }
}

