/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.dao.impl;

import cn.jsprun.dao.UserGroupDao;
import cn.jsprun.domain.Admingroups;
import cn.jsprun.domain.Projects;
import cn.jsprun.domain.Ranks;
import cn.jsprun.domain.Usergroups;
import cn.jsprun.utils.HibernateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGroupDaoImpl
implements UserGroupDao {
    @Override
    public boolean deleteRanks(Ranks rank) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.delete((Object)rank);
            tr.commit();
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean deleteUserGroup(Short groupId) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("delete from Usergroups where groupid = ?");
            query.setShort(0, groupId.shortValue());
            query.executeUpdate();
            tr.commit();
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public List<Ranks> findAllRanks() {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Ranks");
            List rankList = query.list();
            tr.commit();
            return rankList;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Usergroups> findAdminGroups() {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Usergroups as ugp where ugp.radminid != 0 and ugp.groupid!=1");
            List adminGroups = query.list();
            tr.commit();
            return adminGroups;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Usergroups> findUserGroupsByType(String type) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            String sql = "from Usergroups as ugp where ugp.type=? order by ugp.creditslower";
            if ("system".equals(type)) {
                sql = "from Usergroups as ugp where ugp.type=? order by ugp.groupid";
            }
            Query query = session.createQuery(sql);
            query.setString(0, type);
            if (!"member".equals(type)) {
                query.setMaxResults(5);
            }
            List userGroups = query.list();
            tr.commit();
            return userGroups;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Usergroups findUserGroupById(Short userGroupId) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Usergroups userGroup = (Usergroups)session.get(Usergroups.class, (Serializable)userGroupId);
            tr.commit();
            return userGroup;
        }
        catch (Exception e) {
            if (tr != null && tr.isActive()) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean insertRanks(Ranks rank) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.save((Object)rank);
            tr.commit();
            return true;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean insertUserGroup(Usergroups userGroup) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.save((Object)userGroup);
            tr.commit();
            return true;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean modifyRanks(Ranks rank) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.update((Object)rank);
            tr.commit();
            return true;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean modifyUserGroup(Usergroups userGroup) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.update((Object)userGroup);
            tr.commit();
            return true;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Usergroups> findAllGroups() {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Usergroups order by radminid desc,groupid desc");
            List allGroups = query.list();
            tr.commit();
            return allGroups;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Usergroups findUserGroupByCredits(int credits) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Usergroups u where u.creditshigher > ? and u.creditslower < ?");
            query.setInteger(0, credits);
            query.setInteger(1, credits);
            List groupList = query.list();
            tr.commit();
            if (groupList != null && groupList.size() == 1) {
                return (Usergroups)groupList.get(0);
            }
            return null;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Admingroups findAdminGroupById(Short adminGid) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Admingroups adminGroup = (Admingroups)session.get(Admingroups.class, (Serializable)adminGid);
            tr.commit();
            return adminGroup;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean modifyAdminGroup(Admingroups adminGroup) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.update((Object)adminGroup);
            tr.commit();
            return true;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean deleteProjects(Projects projects) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.delete((Object)projects);
            tr.commit();
            return true;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Projects> findAllProjects() {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Projects");
            List list = query.list();
            tr.commit();
            return list;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Projects findProjectsById(Short projectsId) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Projects project = (Projects)session.get(Projects.class, (Serializable)projectsId);
            tr.commit();
            return project;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean insertProjects(Projects projects) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.save((Object)projects);
            tr.commit();
            return true;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean modifyProjects(Projects projects) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.update((Object)projects);
            tr.commit();
            return true;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Usergroups> findUserGroupByAddMember() {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("FROM Usergroups as u WHERE u.type='member' AND u.creditshigher='0' OR (u.groupid NOT IN ('5', '6', '7') AND u.radminid<>'1' AND u.type<>'member') ORDER BY u.type DESC");
            List grouplist = query.list();
            tr.commit();
            return grouplist;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Usergroups> findUsergroupInCredits(int Credits, short groupid) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Usergroups as u where u.type='member' and ((" + Credits + " >= u.creditshigher and u.creditslower > " + Credits + ") or (u.groupid = " + groupid + "))");
            List list = query.list();
            tr.commit();
            return list;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean deleteUsergroups(Usergroups usergroup) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.delete((Object)usergroup);
            tr.commit();
            return true;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void updateUsergroups(List<Usergroups> updateUsergroupList) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            int i = 0;
            while (i < updateUsergroupList.size()) {
                Usergroups userGroup = updateUsergroupList.get(i);
                session.update((Object)userGroup);
                ++i;
            }
            tr.commit();
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
        }
    }

    @Override
    public List<Usergroups> findUsergropsByHql(String hql) {
        Session session = null;
        session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tr = null;
        try {
            tr = session.beginTransaction();
            Query query = session.createQuery(hql);
            List grouplist = query.list();
            tr.commit();
            return grouplist;
        }
        catch (HibernateException e) {
            tr.rollback();
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Usergroups> getUsergroupsList(List<Short> usergroupIdList) {
        Session session = null;
        Transaction tr = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            ArrayList<Usergroups> list = new ArrayList<Usergroups>();
            int i = 0;
            while (i < usergroupIdList.size()) {
                Usergroups userGroup = (Usergroups)session.get(Usergroups.class, (Serializable)usergroupIdList.get(i));
                if (userGroup != null) {
                    list.add(userGroup);
                } else {
                    System.out.println("can not find Usergroup with usergroupId");
                }
                ++i;
            }
            tr.commit();
            return list;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }
}

