/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.dao.impl;

import cn.jsprun.dao.TagsDao;
import cn.jsprun.domain.Tags;
import cn.jsprun.utils.HibernateUtil;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsDaoImple
implements TagsDao {
    @Override
    public Integer deleteArray(List<String> deleteList) {
        Integer num = -1;
        StringBuffer querySQL = new StringBuffer("delete from Tags as t ");
        try {
            if (deleteList.size() > 0) {
                num = this.tagsTemplate(querySQL, deleteList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return num;
    }

    @Override
    public Integer updateToClosedTags(List<String> closedList) {
        Integer num = -1;
        StringBuffer querySQL = new StringBuffer("update Tags as t set t.closed = 1");
        try {
            if (closedList.size() > 0) {
                num = this.tagsTemplate(querySQL, closedList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return num;
    }

    @Override
    public Integer updateToOpenTags(List<String> openList) {
        Integer num = -1;
        StringBuffer querySQL = new StringBuffer("update Tags as t set t.closed = 0");
        try {
            if (openList.size() > 0) {
                num = this.tagsTemplate(querySQL, openList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return num;
    }

    private int tagsTemplate(StringBuffer querySQL, List<String> tagsName) throws Exception {
        int num = -1;
        querySQL.append(" where t.tagname in (:tagnames)");
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery(querySQL.toString());
            query.setParameterList("tagnames", tagsName, (Type)new StringType());
            num += query.executeUpdate();
            tr.commit();
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
                tr = null;
            }
            he.printStackTrace();
        }
        return num;
    }

    @Override
    public List<Tags> findTagsByHql(String hql, int maxrow) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery(hql);
            query.setMaxResults(maxrow);
            List list = query.list();
            tr.commit();
            return list;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean updateTags(Tags tags) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.update((Object)tags);
            tr.commit();
            return true;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Tags findTagsByName(String name) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Tags as t where t.tagname=?");
            query.setParameter(0, (Object)name);
            List list = query.list();
            tr.commit();
            if (list != null && list.size() > 0) {
                return (Tags)list.get(0);
            }
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean deleteTags(Tags tags) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.delete((Object)tags);
            tr.commit();
            return true;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }
}

