/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.dao.impl;

import cn.jsprun.dao.ProjectsDao;
import cn.jsprun.domain.Projects;
import cn.jsprun.utils.HibernateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectsDaoImpl
implements ProjectsDao {
    private static final String PROJECTS_TYPE = "type";

    @Override
    public List<Projects> findAll() {
        Session session = null;
        Transaction tran = null;
        Query query = null;
        List<Projects> projects = null;
        try {
            projects = new ArrayList<Projects>();
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tran = session.beginTransaction();
            query = session.createQuery("from Projects");
            projects = query.list();
            tran.commit();
        }
        catch (HibernateException e) {
            if (tran != null) {
                tran.rollback();
            }
            e.printStackTrace();
        }
        return projects;
    }

    @Override
    public boolean addProject(Projects project) {
        boolean flag = false;
        if (project != null) {
            Session session = null;
            Transaction tran = null;
            try {
                session = HibernateUtil.getSessionFactory().getCurrentSession();
                tran = session.beginTransaction();
                session.save((Object)project);
                flag = true;
                tran.commit();
            }
            catch (HibernateException e) {
                flag = false;
                if (tran != null) {
                    tran.rollback();
                }
                e.printStackTrace();
            }
        }
        return flag;
    }

    @Override
    public boolean removeProject(Projects project) {
        boolean flag = false;
        if (project != null) {
            Session session = null;
            Transaction tran = null;
            try {
                session = HibernateUtil.getSessionFactory().getCurrentSession();
                tran = session.beginTransaction();
                session.delete((Object)project);
                flag = true;
                tran.commit();
            }
            catch (HibernateException e) {
                flag = false;
                if (tran != null) {
                    tran.rollback();
                }
                e.printStackTrace();
            }
        }
        return flag;
    }

    @Override
    public boolean updateProject(Projects project) {
        boolean flag = false;
        if (project != null) {
            Session session = null;
            Transaction tran = null;
            try {
                session = HibernateUtil.getSessionFactory().getCurrentSession();
                tran = session.beginTransaction();
                session.saveOrUpdate((Object)project);
                flag = true;
                tran.commit();
            }
            catch (HibernateException e) {
                flag = false;
                if (tran != null) {
                    tran.rollback();
                }
                e.printStackTrace();
            }
        }
        return flag;
    }

    @Override
    public List<Projects> findByProperty(String propertyName, Object value) {
        Session session = null;
        Transaction tran = null;
        Query query = null;
        List<Projects> projects = null;
        try {
            projects = new ArrayList<Projects>();
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tran = session.beginTransaction();
            query = session.createQuery("from Projects as p where p." + propertyName + "=?");
            query.setString(0, value.toString());
            projects = query.list();
            tran.commit();
        }
        catch (HibernateException e) {
            if (tran != null) {
                tran.rollback();
            }
            e.printStackTrace();
        }
        return projects;
    }

    @Override
    public List<Projects> findByType(String type) {
        return this.findByProperty(PROJECTS_TYPE, type);
    }

    @Override
    public Projects findById(Short id) {
        Session session = null;
        Transaction tran = null;
        Projects project = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tran = session.beginTransaction();
            project = (Projects)session.get(Projects.class, (Serializable)id);
            tran.commit();
        }
        catch (HibernateException e) {
            if (tran != null) {
                tran.rollback();
            }
            e.printStackTrace();
        }
        return project;
    }

    @Override
    public void saveProject(Projects project) {
        Session session = null;
        Transaction tran = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tran = session.beginTransaction();
            session.save((Object)project);
            tran.commit();
        }
        catch (HibernateException e) {
            if (tran != null) {
                tran.rollback();
            }
            e.printStackTrace();
        }
    }
}

