/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.dao.impl;

import cn.jsprun.dao.PostsDao;
import cn.jsprun.domain.Members;
import cn.jsprun.domain.Posts;
import cn.jsprun.struts.form.ModrepliesPageForm;
import cn.jsprun.struts.form.PostsPageForm;
import cn.jsprun.utils.HibernateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostsDaoImpl
implements PostsDao {
    @Override
    public Posts getPostsById(Integer pid) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Posts posts = (Posts)session.get(Posts.class, (Serializable)pid);
            tr.commit();
            return posts;
        }
        catch (Exception exception) {
            if (tr != null) {
                tr.rollback();
            }
            return null;
        }
    }

    @Override
    public boolean deletePostsByUserUid(Integer uid) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("delete from Posts p where p.authorid = ?");
            query.setInteger(0, uid.intValue());
            query.executeUpdate();
            query = session.createQuery("delete from Threads t where t.authorid = ?");
            query.setInteger(0, uid.intValue());
            query.executeUpdate();
            query = session.createQuery("delete from Attachments a where a.uid = ?");
            query.setInteger(0, uid.intValue());
            query.executeUpdate();
            tr.commit();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (tr != null) {
                tr.rollback();
            }
            return false;
        }
    }

    @Override
    public boolean modifyPosts(Posts posts) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.update((Object)posts);
            tr.commit();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (tr != null) {
                tr.rollback();
            }
            return false;
        }
    }

    @Override
    public List<Posts> findByUserName(String userName) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Posts p where p.author = ?");
            query.setString(0, userName);
            List postList = query.list();
            tr.commit();
            return postList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (tr != null) {
                tr.rollback();
            }
            return null;
        }
    }

    @Override
    public List<Posts> findByPosts(Posts posts) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Posts p");
            List postList = query.list();
            tr.commit();
            return postList;
        }
        catch (Exception exception) {
            if (tr != null) {
                tr.rollback();
            }
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public PostsPageForm fidnByForums(short fid, String displayorder) {
        StringBuffer queryStr = new StringBuffer("select t.tid, t.fid, t.author, t.authorid, t.subject, t.dateline,p.pid, p.message, p.useip, p.attachment from jrun_threads t LEFT JOIN jrun_posts p ON p.tid=t.tid WHERE t.displayorder=" + displayorder + " GROUP BY t.tid ");
        StringBuffer countStr = new StringBuffer("select count(*) count from jrun_threads as t where t.displayorder=" + displayorder);
        if (fid > 0) {
            queryStr.append(" and t.fid=" + fid);
            countStr.append(" and t.fid=" + fid);
        }
        queryStr.append(" ORDER BY t.dateline DESC ");
        PostsPageForm ppf = new PostsPageForm(countStr.toString(), queryStr.toString());
        return ppf;
    }

    private void updateSQL(String str) throws Exception {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery(str);
            query.executeUpdate();
            session.flush();
            tr.commit();
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            tr = null;
            e.printStackTrace();
        }
    }

    public List selectSQL(String str) {
        List postsList = new ArrayList();
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery(str);
            postsList = query.list();
            session.flush();
            tr.commit();
        }
        catch (Exception e) {
            postsList.clear();
            if (tr != null) {
                tr.rollback();
            }
            tr = null;
            e.printStackTrace();
        }
        return postsList;
    }

    @Override
    public ModrepliesPageForm fidnByModreplies(short fid, String invisible) {
        StringBuffer queryStr = new StringBuffer("select p.*,t.subject as threadsubject from jrun_posts as p left join jrun_threads as t on t.tid=p.tid where p.first=0 and p.invisible=" + invisible);
        StringBuffer countStr = new StringBuffer("select count(*) count from jrun_posts as p where p.first=0 and p.invisible=" + invisible);
        if (fid > 0) {
            queryStr.append(" and p.fid=" + fid);
            countStr.append(" and p.fid=" + fid);
        }
        ModrepliesPageForm mpf = new ModrepliesPageForm(countStr.toString(), queryStr.toString());
        return mpf;
    }

    @Override
    public Map batchPrune(String sb, boolean b) {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            if (b) {
                StringBuffer showPosts = new StringBuffer("from Posts as p where p.pid in (");
                String[] tids = sb.split(",");
                int i = 0;
                while (i < tids.length) {
                    showPosts.append(tids[i].toString());
                    showPosts.append(",");
                    ++i;
                }
                String str = showPosts.substring(0, showPosts.length() - 1);
                str = String.valueOf(str) + ")";
                Query query = session.createQuery(str);
                List postsList = query.list();
                session.flush();
                int i2 = 0;
                while (i2 < postsList.size()) {
                    Integer num = ((Posts)postsList.get(i2)).getAuthorid();
                    Members member = (Members)session.get(Members.class, (Serializable)num);
                    member.setPosts(member.getPosts() - 1);
                    member.setCredits(member.getCredits() - 1);
                    String d = member.getBday();
                    if (d == null) {
                        member.setBday("0000-00-00");
                    }
                    session.update((Object)member);
                    ++i2;
                }
                session.flush();
            }
            String[] pids = sb.split(",");
            int threads = 0;
            int posts = 0;
            int i = 0;
            while (i < pids.length) {
                Posts p;
                if (pids[i] != null && !pids[i].equals("") && (p = (Posts)session.get(Posts.class, (Serializable)Integer.valueOf(pids[i]))) != null) {
                    if (p.getFirst() == 1) {
                        posts += this.deleteThreads(p.getTid()).intValue();
                        ++threads;
                    }
                    if (p.getFirst() == 0) {
                        Query myquery = session.createQuery("delete from Posts as p where p.pid = :pid");
                        myquery.setInteger("pid", p.getPid().intValue());
                        posts = myquery.executeUpdate();
                        session.flush();
                    }
                }
                ++i;
            }
            m.put("threads", threads);
            m.put("posts", posts);
            tr.commit();
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
            }
            he.printStackTrace();
        }
        return m;
    }

    private Integer deleteThreads(Integer tid) {
        int ps;
        block2: {
            ps = 0;
            Transaction tr = null;
            try {
                Session session = HibernateUtil.getSessionFactory().getCurrentSession();
                tr = session.beginTransaction();
                Query myquery = session.createQuery("delete from Posts as p where p.tid = :tid");
                myquery.setInteger("tid", tid.intValue());
                ps = myquery.executeUpdate();
                session.flush();
                myquery = session.createQuery("delete from Threads as t where t.tid = :tid");
                myquery.setInteger("tid", tid.intValue());
                myquery.executeUpdate();
                session.flush();
                tr.commit();
            }
            catch (Exception e) {
                if (tr == null) break block2;
                tr.rollback();
            }
        }
        return ps;
    }

    public int tableTemplate(StringBuffer querystr, String sbtid) throws Exception {
        int num = -1;
        if (sbtid == null || sbtid.equals("")) {
            return num;
        }
        querystr.append(" where t.tid in (");
        String[] tids = sbtid.split(",");
        if (tids.length == 1 && (tids[0].trim() == null || tids[0].trim().equals(""))) {
            return num;
        }
        int i = 0;
        while (i < tids.length) {
            querystr.append(tids[i]);
            querystr.append(",");
            ++i;
        }
        String str = querystr.substring(0, querystr.length() - 1);
        str = String.valueOf(str) + ")";
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query myquery = session.createQuery(str);
            num = myquery.executeUpdate();
            tr.commit();
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
            }
            he.printStackTrace();
        }
        return num;
    }

    @Override
    public void deleteForumrecommend(StringBuffer deleteSB) {
        StringBuffer deleteString = new StringBuffer("delete from Forumrecommend as t");
        try {
            this.tableTemplate(deleteString, deleteSB.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Integer updateForumrecommendList(List list) {
        int updateNumber = -1;
        String updateStr = null;
        if (list == null || list.size() <= 0) {
            return 0;
        }
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            int i = 0;
            while (i < list.size()) {
                Map m = (Map)list.get(i);
                if (m != null) {
                    updateStr = "update Forumrecommend as f set f.displayorder =:displayorder where f.tid = :tid";
                    Query query = session.createQuery(updateStr);
                    String displayorder = m.get("displayorder").toString();
                    try {
                        int dis = Integer.valueOf(displayorder);
                        if (dis > 127) {
                            displayorder = "127";
                        }
                    }
                    catch (NumberFormatException nfe) {
                        displayorder = "127";
                    }
                    query.setString("displayorder", displayorder);
                    query.setInteger("tid", Integer.valueOf(m.get("tid").toString()).intValue());
                    query.executeUpdate();
                }
                ++i;
            }
            tr.commit();
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
            }
            he.printStackTrace();
        }
        return updateNumber;
    }

    @Override
    public boolean deleteModrepliesIDArray(List<String> modrepliesList) {
        StringBuffer sb = new StringBuffer("delete from Posts as p where p.pid in (");
        StringBuffer sba = new StringBuffer("delete from Attachments as p where p.pid in (");
        int i = 0;
        while (i < modrepliesList.size()) {
            sb.append(String.valueOf(modrepliesList.get(i)) + ",");
            sba.append(String.valueOf(modrepliesList.get(i)) + ",");
            ++i;
        }
        String strsql = sb.substring(0, sb.length() - 1);
        String strsqla = sba.substring(0, sba.length() - 1);
        strsql = String.valueOf(strsql) + ")";
        strsqla = String.valueOf(strsqla) + ")";
        try {
            this.updateSQL(strsql);
            this.updateSQL(strsqla);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean ignoreModrepliesIDArray(List<String> modrepliesList) {
        StringBuffer sb = new StringBuffer("update Posts as p set p.invisible=-3 where p.pid in (");
        int i = 0;
        while (i < modrepliesList.size()) {
            sb.append(String.valueOf(modrepliesList.get(i)) + ",");
            ++i;
        }
        String strsql = sb.substring(0, sb.length() - 1);
        strsql = String.valueOf(strsql) + ")";
        try {
            this.updateSQL(strsql);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean validateModrepliesIDArray(List<Posts> modrepliesList) {
        StringBuffer sb = new StringBuffer("update Posts as p set p.invisible=0 where p.pid in (");
        int i = 0;
        while (i < modrepliesList.size()) {
            Posts p = modrepliesList.get(i);
            sb.append(p.getPid() + ",");
            ++i;
        }
        String strsql = sb.substring(0, sb.length() - 1);
        strsql = String.valueOf(strsql) + ")";
        try {
            this.updateSQL(strsql);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public List validatePostsIDArray(List validateList) {
        StringBuffer updateThreadsSQL = new StringBuffer("update Threads as t set t.displayorder=0,t.moderated=1 where t.tid in (");
        StringBuffer updatePostsSQL = new StringBuffer("update Posts as p set p.invisible=0 where p.tid in (");
        StringBuffer showSb = new StringBuffer("from Posts as p where p.tid in (");
        int i = 0;
        while (i < validateList.size()) {
            updateThreadsSQL.append(validateList.get(i) + ",");
            updatePostsSQL.append(validateList.get(i) + ",");
            showSb.append(validateList.get(i) + ",");
            ++i;
        }
        String updateThreadssql = updateThreadsSQL.substring(0, updateThreadsSQL.length() - 1);
        updateThreadssql = String.valueOf(updateThreadssql) + "))";
        String strsql = updatePostsSQL.substring(0, updatePostsSQL.length() - 1);
        strsql = String.valueOf(strsql) + ")";
        String showSQL = showSb.substring(0, showSb.length() - 1);
        showSQL = String.valueOf(showSQL) + ") AND p.first=1";
        try {
            this.updateSQL(updateThreadssql);
            this.updateSQL(strsql);
            List postsList = this.selectSQL(showSQL);
            if (postsList != null && postsList.size() > 0) {
                return postsList;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean deletePostsIDArray(List deleteList) {
        StringBuffer updateThreadsSQL = new StringBuffer("update Threads as t set t.displayorder=-1,t.moderated=1 where t.tid in (select p.tid from Posts as p where p.pid in (");
        StringBuffer updatePostsSQL = new StringBuffer("update Posts as p set p.invisible=-1 where p.pid in (");
        int i = 0;
        while (i < deleteList.size()) {
            updateThreadsSQL.append(deleteList.get(i) + ",");
            updatePostsSQL.append(deleteList.get(i) + ",");
            ++i;
        }
        String updateThreadssql = updateThreadsSQL.substring(0, updateThreadsSQL.length() - 1);
        updateThreadssql = String.valueOf(updateThreadssql) + "))";
        String strsql = updatePostsSQL.substring(0, updatePostsSQL.length() - 1);
        strsql = String.valueOf(strsql) + ")";
        try {
            this.updateSQL(updateThreadssql);
            this.updateSQL(strsql);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean ignorePostsIDArray(List ignoreList) {
        StringBuffer updateThreadsSQL = new StringBuffer("update Threads as t set t.displayorder=-3,t.moderated=0 where t.tid in (");
        StringBuffer updatePostsSQL = new StringBuffer("update Posts as p set p.invisible=-2 where p.tid in (");
        int i = 0;
        while (i < ignoreList.size()) {
            updateThreadsSQL.append(ignoreList.get(i) + ",");
            updatePostsSQL.append(ignoreList.get(i) + ",");
            ++i;
        }
        String updateThreadssql = updateThreadsSQL.substring(0, updateThreadsSQL.length() - 1);
        updateThreadssql = String.valueOf(updateThreadssql) + "))";
        String strsql = updatePostsSQL.substring(0, updatePostsSQL.length() - 1);
        strsql = String.valueOf(strsql) + ")";
        try {
            this.updateSQL(updateThreadssql);
            this.updateSQL(strsql);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Posts findByTid(Integer tid) {
        Posts p = null;
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Posts as p where p.tid = " + tid + " and p.first =1 ");
            List postsList = query.list();
            tr.commit();
            if (postsList.size() > 0) {
                p = (Posts)postsList.get(0);
            }
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
            }
            he.printStackTrace();
        }
        return p;
    }

    @Override
    public Posts findPostByThreadId(int tid) {
        block3: {
            Transaction tr = null;
            try {
                Session session = HibernateUtil.getSessionFactory().getCurrentSession();
                tr = session.beginTransaction();
                Query query = session.createQuery("from Posts as p where p.tid=? and first = 1");
                query.setParameter(0, (Object)tid);
                List list = query.list();
                tr.commit();
                if (list != null && list.size() > 0) {
                    return (Posts)list.get(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (tr == null) break block3;
                tr.rollback();
            }
        }
        return null;
    }

    @Override
    public int findPostCount() {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("select count(*) from Posts");
            List list = query.list();
            tr.commit();
            if (list != null && list.size() > 0) {
                return Integer.valueOf("" + list.get(0));
            }
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public int findPostCountByHql(String hql) {
        Session session = null;
        Transaction tran = null;
        Query query = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            tran = session.beginTransaction();
            query = session.createQuery(hql);
            List list = query.list();
            tran.commit();
            if (list != null && list.size() > 0) {
                return (Integer)list.get(0);
            }
        }
        catch (HibernateException e) {
            if (tran != null) {
                tran.rollback();
            }
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public List<Posts> getPostsListByPidList(List<Integer> pidList) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            ArrayList<Posts> list = new ArrayList<Posts>();
            int i = 0;
            while (i < pidList.size()) {
                list.add((Posts)session.get(Posts.class, (Serializable)pidList.get(i)));
                ++i;
            }
            tr.commit();
            return list;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, String> getBestmemAndBestmemposts(Integer nowTime) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            String hql = "SELECT author,COUNT(*) FROM Posts WHERE dateline>=? AND invisible=0 AND authorid>0 GROUP BY author";
            Query query = session.createQuery(hql);
            query.setInteger(0, nowTime.intValue());
            List list = query.list();
            tr.commit();
            Iterator iterator = list.iterator();
            Integer count = 0;
            String author = null;
            while (iterator.hasNext()) {
                Object[] objects = (Object[])iterator.next();
                String authorTemp = objects[0].toString();
                Integer countTemp = (Integer)objects[1];
                if (countTemp <= count) continue;
                count = countTemp;
                author = authorTemp;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            if (count != 0) {
                map.put("bestmem", author);
            } else {
                map.put("bestmem", "None");
            }
            map.put("bestmemposts", count.toString());
            return map;
        }
        catch (Exception exception) {
            if (tr != null) {
                tr.rollback();
            }
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, String> getPostsAndRuntime() {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            String hql = "SELECT COUNT(*), (MAX(dateline)-MIN(dateline))/86400 FROM Posts";
            Query query = session.createQuery(hql);
            List list = query.list();
            tr.commit();
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                Object[] objects = (Object[])iterator.next();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("posts", objects[0].toString());
                map.put("runtime", objects[1] == null || (Integer)objects[1] < 1 ? "1" : objects[1].toString());
                return map;
            }
        }
        catch (Exception exception) {
            if (tr != null) {
                tr.rollback();
            }
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public Integer getPostsaddtoday() {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            String hql = "SELECT COUNT(*) FROM Posts WHERE dateline>=? AND invisible=?";
            Query query = session.createQuery(hql);
            int nowTime = (int)(System.currentTimeMillis() / 1000L);
            query.setInteger(0, nowTime - 86400);
            query.setByte(1, (byte)0);
            List list = query.list();
            tr.commit();
            return (Integer)list.get(0);
        }
        catch (Exception exception) {
            if (tr != null) {
                tr.rollback();
            }
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Posts> findPostByhql(String hql, int start, int max) {
        Session session = null;
        Transaction trs = null;
        try {
            session = HibernateUtil.getSessionFactory().getCurrentSession();
            trs = session.beginTransaction();
            Query query = session.createQuery(hql);
            query.setFirstResult(start);
            query.setMaxResults(max);
            List postlist = query.list();
            trs.commit();
            return postlist;
        }
        catch (HibernateException e) {
            if (trs != null) {
                trs.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean updatePosts(Posts post) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.update((Object)post);
            tr.commit();
            return true;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int saveOrupdatePosts(Posts post) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.saveOrUpdate((Object)post);
            tr.commit();
            return post.getPid();
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Posts> getPostsListByTid(Integer tid) {
        Transaction transaction = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            transaction = session.beginTransaction();
            String hql = "FROM Posts as p WHERE p.tid=?";
            Query query = session.createQuery(hql);
            query.setInteger(0, tid.intValue());
            List postsList = query.list();
            transaction.commit();
            return postsList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (transaction != null) {
                transaction.rollback();
            }
            return null;
        }
    }

    @Override
    public void deletePosts(List<Integer> pidList) {
        block3: {
            Transaction transaction = null;
            try {
                Session session = HibernateUtil.getSessionFactory().getCurrentSession();
                transaction = session.beginTransaction();
                int i = 0;
                while (i < pidList.size()) {
                    session.delete(session.get(Posts.class, (Serializable)pidList.get(i)));
                    ++i;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (transaction == null) break block3;
                transaction.rollback();
            }
        }
    }

    @Override
    public Posts getLastPosts(Integer tid) {
        Transaction transaction = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            transaction = session.beginTransaction();
            String hql = "FROM Posts as p WHERE p.tid=? AND p.invisible=0 ORDER BY p.dateline DESC";
            Query query = session.createQuery(hql);
            query.setInteger(0, tid.intValue());
            query.setMaxResults(1);
            List postsList = query.list();
            transaction.commit();
            if (postsList.size() > 0) {
                return (Posts)postsList.get(0);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (transaction != null) {
                transaction.rollback();
            }
            return null;
        }
    }

    @Override
    public Posts getFirstPosts(Integer tid) {
        Transaction transaction = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            transaction = session.beginTransaction();
            String hql = "FROM Posts as p WHERE p.tid=? AND p.invisible=0 ORDER BY p.dateline ASC LIMIT 1";
            Query query = session.createQuery(hql);
            query.setInteger(0, tid.intValue());
            List postsList = query.list();
            transaction.commit();
            if (postsList.size() > 0) {
                return (Posts)postsList.get(0);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (transaction != null) {
                transaction.rollback();
            }
            return null;
        }
    }

    @Override
    public void updatePosts(List<Posts> postsList) {
        block3: {
            Transaction transaction = null;
            try {
                Session session = HibernateUtil.getSessionFactory().getCurrentSession();
                transaction = session.beginTransaction();
                int i = 0;
                while (i < postsList.size()) {
                    session.update((Object)postsList.get(i));
                    ++i;
                }
                transaction.commit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (transaction == null) break block3;
                transaction.rollback();
            }
        }
    }

    @Override
    public Integer getCountOfReplyForTopic(Integer topicId) {
        Transaction transaction = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            transaction = session.beginTransaction();
            String hql = "SELECT COUNT(*) FROM Posts AS p WHERE p.tid=? AND invisible=0";
            Query query = session.createQuery(hql);
            query.setInteger(0, topicId.intValue());
            List list = query.list();
            transaction.commit();
            if (list != null) {
                return (Integer)list.get(0) - 1;
            }
            throw new Exception("Result IS NULL");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (transaction != null) {
                transaction.rollback();
            }
            return null;
        }
    }

    @Override
    public void updatePostsByHQL(String hql) {
        block2: {
            Transaction transaction = null;
            try {
                Session session = HibernateUtil.getSessionFactory().getCurrentSession();
                transaction = session.beginTransaction();
                Query query = session.createQuery(hql);
                query.executeUpdate();
                transaction.commit();
            }
            catch (Exception exception) {
                if (transaction == null) break block2;
                transaction.rollback();
            }
        }
    }
}

