/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.dao.impl;

import cn.jsprun.dao.PmsDao;
import cn.jsprun.domain.Pms;
import cn.jsprun.utils.FormDataCheck;
import cn.jsprun.utils.HibernateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.SimpleExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmsDaoImpl
implements PmsDao {
    @Override
    public void insertPmsList(List<Pms> pmsList) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            tr = session.beginTransaction();
            int i = 0;
            while (i < pmsList.size()) {
                Pms pms = pmsList.get(i);
                session.save((Object)pms);
                ++i;
            }
            session.flush();
            tr.commit();
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            tr = null;
            e.printStackTrace();
        }
    }

    @Override
    public List<Pms> findPmsByMsgtoid(int touid) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Pms as p where p.msgtoid = ? or p.msgfromid = ?");
            query.setParameter(0, (Object)touid);
            query.setParameter(1, (Object)touid);
            List list = query.list();
            tr.commit();
            return list;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void updatePms(Pms pms) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.update((Object)pms);
            tr.commit();
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
        }
    }

    private Criterion findbyOR(String type, String str, org.hibernate.Session session) {
        Criterion criterion = null;
        StringBuffer sbSQL = new StringBuffer("select p.pmid from Pms as p where");
        ArrayList<String> srch = new ArrayList<String>();
        str = str.replace("|", ",");
        String[] srchAND = str.split(" and ");
        int i = 0;
        while (i < srchAND.length) {
            String[] srch_ = srchAND[i].split(" ");
            int j = 0;
            while (j < srch_.length) {
                if (FormDataCheck.isValueString(srch_[j])) {
                    srch.add(srch_[j]);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < srch.size()) {
            sbSQL.append(" p." + type + " like '%" + (String)srch.get(i) + "%' or");
            ++i;
        }
        String sql = sbSQL.substring(0, sbSQL.length() - 2);
        try {
            Query query = session.createQuery(sql);
            List list = query.list();
            criterion = Expression.in((String)"pmid", (Collection)list);
            session.flush();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            criterion = null;
        }
        return criterion;
    }

    private Criterion findbyAnd(String type, String str) {
        LogicalExpression criterion = null;
        ArrayList<String> srch = new ArrayList<String>();
        String[] srchAND = str.split(" and ");
        int i = 0;
        while (i < srchAND.length) {
            String[] srch_ = srchAND[i].split(" ");
            int j = 0;
            while (j < srch_.length) {
                if (FormDataCheck.isValueString(srch_[j])) {
                    srch.add(srch_[j]);
                }
                ++j;
            }
            ++i;
        }
        try {
            Criterion[] criterionArray = new Criterion[srch.size()];
            int i2 = 0;
            while (i2 < srch.size()) {
                SimpleExpression criterionCount = Expression.like((String)type, (String)((String)srch.get(i2)), (MatchMode)MatchMode.ANYWHERE);
                criterionArray[i2] = criterionCount;
                ++i2;
            }
            i2 = 0;
            while (i2 < criterionArray.length) {
                criterion = i2 == 0 ? Expression.and((Criterion)criterionArray[i2], (Criterion)criterionArray[i2++]) : Expression.and(criterion, (Criterion)criterionArray[i2]);
                ++i2;
            }
        }
        catch (HibernateException e) {
            e.printStackTrace();
            criterion = null;
        }
        return criterion;
    }

    @Override
    public List<Pms> findPmsByHql(String hql, int begin, int maxlength) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery(hql);
            query.setFirstResult(begin);
            query.setMaxResults(maxlength);
            List pmslist = query.list();
            tr.commit();
            return pmslist;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int findPmsCountByHql(String hql) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery(hql);
            List list = query.list();
            tr.commit();
            if (list != null && list.size() > 0) {
                return (Integer)list.get(0);
            }
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public Pms findPmsBypmid(int pmid) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Pms pms = (Pms)session.get(Pms.class, (Serializable)Integer.valueOf(pmid));
            tr.commit();
            return pms;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean deletePms(Pms pms) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.delete((Object)pms);
            tr.commit();
            return true;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }
}

