/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.dao.impl;

import cn.jsprun.dao.FavoritesDao;
import cn.jsprun.domain.Favorites;
import cn.jsprun.utils.HibernateUtil;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoritesDaoImpl
implements FavoritesDao {
    @Override
    public boolean deleteFavoritesByUid(int uid) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tr = null;
        try {
            tr = session.beginTransaction();
            Query query = session.createQuery("delete from Favorites as f where f.id.uid=?");
            query.setParameter(0, (Object)uid);
            query.executeUpdate();
            tr.commit();
            return true;
        }
        catch (HibernateException er) {
            if (tr != null) {
                tr.rollback();
            }
            er.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Favorites> findFavoritesByUid(int uid) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tr = null;
        try {
            tr = session.beginTransaction();
            Query query = session.createQuery("from Favorites as f where f.id.uid=?");
            query.setParameter(0, (Object)uid);
            List list = query.list();
            tr.commit();
            return list;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean insertFavorites(Favorites favorite) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tr = null;
        try {
            tr = session.beginTransaction();
            session.save((Object)favorite);
            tr.commit();
            return true;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Favorites> findFavoritesByHql(String hql, int startrow, int maxlength) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tr = null;
        try {
            tr = session.beginTransaction();
            Query query = session.createQuery(hql);
            query.setFirstResult(startrow);
            query.setMaxResults(maxlength);
            List list = query.list();
            tr.commit();
            return list;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean deleteFavoritesByTid(int tid) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tr = null;
        try {
            tr = session.beginTransaction();
            Query query = session.createQuery("delete from Favorites as f where f.id.tid=?");
            query.setParameter(0, (Object)tid);
            query.executeUpdate();
            tr.commit();
            return true;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean delteFavoritesByFid(short fid) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tr = null;
        try {
            tr = session.beginTransaction();
            Query query = session.createQuery("delete from Favorites as f where f.id.fid=?");
            query.setParameter(0, (Object)fid);
            query.executeUpdate();
            tr.commit();
            return true;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int findFavoritesCountByHql(String hql) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tr = null;
        try {
            tr = session.beginTransaction();
            Query query = session.createQuery(hql);
            List list = query.list();
            tr.commit();
            if (list != null && list.size() > 0) {
                return Integer.valueOf(list.get(0).toString());
            }
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
        }
        return 0;
    }
}

