/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.dao.impl;

import cn.jsprun.dao.CronsDao;
import cn.jsprun.domain.Crons;
import cn.jsprun.utils.HibernateUtil;
import cn.jsprun.utils.JspRunConfig;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronsDaoImpl
implements CronsDao {
    private static final String tablepre = "jrun_";

    @Override
    public boolean addCrons(Crons crons) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction ts = null;
        try {
            ts = session.beginTransaction();
            session.save((Object)crons);
            ts.commit();
            return true;
        }
        catch (HibernateException e) {
            if (ts != null) {
                ts.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean delAnyCrons(List<Crons> cronsListDelete) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction ts = null;
        try {
            ts = session.beginTransaction();
            int len = cronsListDelete.size();
            int i = 0;
            while (i < len) {
                session.delete((Object)cronsListDelete.get(i));
                ++i;
            }
            ts.commit();
            return true;
        }
        catch (HibernateException e) {
            if (ts != null) {
                ts.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Crons queryCronsById(Short id) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction ts = null;
        try {
            ts = session.beginTransaction();
            Crons crons = (Crons)session.get(Crons.class, (Serializable)id);
            ts.commit();
            return crons;
        }
        catch (HibernateException e) {
            if (ts != null) {
                ts.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Crons> queryAllCrons() {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction ts = null;
        List cronsList = null;
        try {
            ts = session.beginTransaction();
            cronsList = session.createQuery("from Crons").list();
            ts.commit();
        }
        catch (HibernateException e) {
            if (ts != null) {
                ts.rollback();
            }
            e.printStackTrace();
        }
        return cronsList;
    }

    @Override
    public List<Crons> queryCronsByCondition(String sqlStatement) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction ts = null;
        try {
            ts = session.beginTransaction();
            List cronsList = session.createSQLQuery(sqlStatement).addEntity(Crons.class).list();
            ts.commit();
            return cronsList;
        }
        catch (HibernateException e) {
            if (ts != null) {
                ts.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean updateCrons(Crons crons) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction ts = null;
        try {
            ts = session.beginTransaction();
            session.update((Object)crons);
            ts.commit();
            return true;
        }
        catch (HibernateException e) {
            if (ts != null) {
                ts.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean updateCrons(List<Crons> cronsList) {
        Session session = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction ts = null;
        try {
            ts = session.beginTransaction();
            Iterator<Crons> cronsIt = cronsList.iterator();
            Crons crons = null;
            while (cronsIt.hasNext()) {
                crons = cronsIt.next();
                session.update((Object)crons);
            }
            ts.commit();
            return true;
        }
        catch (HibernateException e) {
            if (ts != null) {
                ts.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Connection getConnection() throws Exception {
        Properties properties = new Properties();
        FileInputStream fis = new FileInputStream(String.valueOf(JspRunConfig.realPath) + "config.properties");
        properties.load(fis);
        ((InputStream)fis).close();
        String dbhost = properties.getProperty("dbhost");
        String dbport = properties.getProperty("dbport");
        String dbname = properties.getProperty("dbname");
        String dbuser = properties.getProperty("dbuser");
        String dbpw = properties.getProperty("dbpw");
        Class.forName("com.mysql.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:mysql://" + dbhost + ":" + dbport + "/" + dbname, dbuser, dbpw);
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public void begingTransaction(Connection connection, int level) throws SQLException {
        try {
            connection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Map<String, String>> getRunningCronsInfo(Connection connection, int timestamp) throws SQLException {
        ArrayList<Map<String, String>> tempML = new ArrayList<Map<String, String>>();
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = connection.prepareStatement("SELECT cronid,name,filename,weekday,day,hour,minute FROM jrun_crons WHERE available=1 AND nextrun<=" + timestamp);
            rs = pstmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] columns = new String[columnCount];
            int i = 1;
            while (i <= columnCount) {
                columns[i - 1] = rsmd.getColumnLabel(i);
                ++i;
            }
            rsmd = null;
            HashMap<String, String> row = null;
            while (rs.next()) {
                row = new HashMap<String, String>(columnCount);
                int i2 = 1;
                while (i2 <= columnCount) {
                    row.put(columns[i2 - 1], rs.getString(i2));
                    ++i2;
                }
                tempML.add(row);
            }
            row = null;
            columns = null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return tempML;
    }

    @Override
    public Map<String, String> getRunningCronInfo(Connection connection, Object cronsid) throws SQLException {
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap<String, String> row = null;
        try {
            pstmt = connection.prepareStatement("SELECT cronid,name,filename,weekday,day,hour,minute FROM jrun_crons WHERE available=1 AND cronid='" + cronsid + "'");
            rs = pstmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] columns = new String[columnCount];
            int i = 1;
            while (i <= columnCount) {
                columns[i - 1] = rsmd.getColumnLabel(i);
                ++i;
            }
            rsmd = null;
            while (rs.next()) {
                row = new HashMap<String, String>(columnCount);
                i = 1;
                while (i <= columnCount) {
                    row.put(columns[i - 1], rs.getString(i));
                    ++i;
                }
            }
            columns = null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return row;
    }

    @Override
    public void commitTransaction(Connection connection) {
        try {
            connection.commit();
        }
        catch (SQLException e) {
            this.rollbackTransaction(connection);
        }
    }

    @Override
    public void rollbackTransaction(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void execute(Connection connection, String sql) throws SQLException {
        Statement pstmt = null;
        try {
            pstmt = connection.createStatement();
            pstmt.execute(sql);
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
        }
    }

    @Override
    public List<Map<String, String>> executeQuery(Connection connection, String sql) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Map<String, String>> rows = null;
        try {
            pstmt = connection.prepareStatement(sql);
            rs = pstmt.executeQuery();
            rows = new ArrayList<Map<String, String>>();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] columns = new String[columnCount];
            int i = 1;
            while (i <= columnCount) {
                columns[i - 1] = rsmd.getColumnLabel(i);
                ++i;
            }
            rsmd = null;
            HashMap<String, String> row = null;
            while (rs.next()) {
                row = new HashMap<String, String>(columnCount);
                int i2 = 1;
                while (i2 <= columnCount) {
                    row.put(columns[i2 - 1], rs.getString(i2));
                    ++i2;
                }
                rows.add(row);
            }
            row = null;
            columns = null;
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
        }
        return rows;
    }
}

