/*
 * Decompiled with CFR 0.152.
 */
package cn.jsprun.dao.impl;

import cn.jsprun.dao.AttachmentsDao;
import cn.jsprun.domain.Attachments;
import cn.jsprun.domain.Threads;
import cn.jsprun.struts.form.AttachmentsForm;
import cn.jsprun.utils.Common;
import cn.jsprun.utils.HibernateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.type.IntegerType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentsDaoImple
implements AttachmentsDao {
    @Override
    public Integer deleteArray(String[] aids) {
        Integer deleteNumber = -1;
        Transaction tr = null;
        try {
            Object[] ids = new Integer[aids.length];
            int i = 0;
            while (i < aids.length) {
                ids[i] = Integer.valueOf(aids[i]);
                ++i;
            }
            String queryStr = "delete from Attachments as a where a.aid in (:ids)";
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery(queryStr);
            query.setParameterList("ids", ids, (Type)new IntegerType());
            deleteNumber = query.executeUpdate();
            session.flush();
            tr.commit();
        }
        catch (HibernateException he) {
            he.printStackTrace();
            if (tr != null) {
                tr.rollback();
            }
            tr = null;
        }
        return deleteNumber;
    }

    @Override
    public String findByAttachmentsForm(AttachmentsForm attachmentsForm) {
        String[] keys;
        StringBuffer querStr = new StringBuffer("from jrun_attachments a , jrun_posts p, jrun_threads t,jrun_forums f WHERE t.tid=a.tid AND f.fid=p.fid AND t.displayorder>='0' AND p.invisible='0' AND a.pid=p.pid ");
        String and = " AND ";
        if (attachmentsForm.getInforum() > 0) {
            querStr.append(and);
            querStr.append(" p.fid = " + attachmentsForm.getInforum());
        }
        if (attachmentsForm.getSizeless() > 0) {
            querStr.append(and);
            querStr.append(" a.filesize < " + attachmentsForm.getSizeless());
        }
        if (attachmentsForm.getSizemore() > 0) {
            querStr.append(and);
            querStr.append(" a.filesize > " + attachmentsForm.getSizemore());
        }
        if (attachmentsForm.getDlcountless() > 0) {
            querStr.append(and);
            querStr.append(" a.downloads < " + attachmentsForm.getDlcountless());
        }
        if (attachmentsForm.getDlcountmore() > 0) {
            querStr.append(and);
            querStr.append(" a.downloads > " + attachmentsForm.getDlcountmore());
        }
        if (attachmentsForm.getDaysold() > 0) {
            int time = Common.time();
            querStr.append(and);
            querStr.append(" p.dateline <= " + (time - attachmentsForm.getDaysold() * 86400));
        }
        if (attachmentsForm.getFilename() != null && !attachmentsForm.getFilename().equals("")) {
            querStr.append(and);
            querStr.append(" a.filename like '%" + Common.addslashes(attachmentsForm.getFilename()) + "%'");
        }
        if (attachmentsForm.getAuthor() != null && !attachmentsForm.getAuthor().equals("")) {
            querStr.append(and);
            querStr.append(" p.author ='" + Common.addslashes(attachmentsForm.getAuthor()) + "'");
        }
        if (attachmentsForm.getKeywords() != null && !attachmentsForm.getKeywords().equals("") && (keys = attachmentsForm.getKeywords().split(",")) != null && keys.length > 0) {
            String or = "";
            StringBuffer sqlkeywords = new StringBuffer();
            int i = 0;
            while (i < keys.length) {
                sqlkeywords.append(String.valueOf(or) + " a.description like '%" + Common.addslashes(keys[i]) + "%'");
                or = " OR ";
                ++i;
            }
            querStr.append(and);
            querStr.append(" (" + sqlkeywords + ") ");
        }
        return querStr.toString();
    }

    @Override
    public List<Attachments> findByPostsID(Integer pid) {
        List list = null;
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().openSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Attachments as a where a.pid = :id");
            query.setInteger("id", pid.intValue());
            list = query.list();
            session.flush();
            tr.commit();
        }
        catch (HibernateException he) {
            if (tr != null) {
                tr.rollback();
                tr = null;
            }
            he.printStackTrace();
        }
        return list;
    }

    @Override
    public List<Attachments> findAttchmentsByJs(String hql, int startrow, int maxrow) {
        ArrayList<Attachments> attlist = new ArrayList<Attachments>();
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery(hql);
            query.setFirstResult(startrow);
            query.setMaxResults(maxrow);
            List list = query.list();
            tr.commit();
            for (Object[] os : list) {
                Attachments a = (Attachments)os[0];
                Threads t = (Threads)os[1];
                attlist.add(a);
            }
            return attlist;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Attachments findAttachmentsById(int aid) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Attachments attc = (Attachments)session.get(Attachments.class, (Serializable)Integer.valueOf(aid));
            tr.commit();
            return attc;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int insertAttachments(Attachments attachments) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.save((Object)attachments);
            tr.commit();
            return attachments.getAid();
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean deleteAttachments(Attachments attachments) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.delete((Object)attachments);
            tr.commit();
            return true;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean updateAttachments(Attachments attachments) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            session.update((Object)attachments);
            tr.commit();
            return true;
        }
        catch (HibernateException e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<Attachments> findByattaByTid(Integer tid) {
        Transaction tr = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            tr = session.beginTransaction();
            Query query = session.createQuery("from Attachments as a where a.tid=?");
            query.setParameter(0, (Object)tid);
            List list = query.list();
            tr.commit();
            return list;
        }
        catch (Exception e) {
            if (tr != null) {
                tr.rollback();
            }
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Attachments> getAttachmentListByTid(Integer tid) {
        Transaction transaction = null;
        try {
            Session session = HibernateUtil.getSessionFactory().getCurrentSession();
            transaction = session.beginTransaction();
            String hql = "FROM Attachments AS a WHERE a.tid=?";
            Query query = session.createQuery(hql);
            query.setInteger(0, tid.intValue());
            List list = query.list();
            transaction.commit();
            return list;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (transaction != null) {
                transaction.rollback();
            }
            return null;
        }
    }

    @Override
    public void updateAttachment(List<Attachments> attachmentsList) {
        block3: {
            Transaction transaction = null;
            try {
                Session session = HibernateUtil.getSessionFactory().getCurrentSession();
                transaction = session.beginTransaction();
                int i = 0;
                while (i < attachmentsList.size()) {
                    session.update((Object)attachmentsList.get(i));
                    ++i;
                }
                transaction.commit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (transaction == null) break block3;
                transaction.rollback();
            }
        }
    }
}

