/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class IncrementGenerator
implements IdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog((Class)IncrementGenerator.class);
    private long next;
    private String sql;
    private Class returnClass;

    public synchronized Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        if (this.sql != null) {
            this.getNext(session);
        }
        return IdentifierGeneratorFactory.createNumber(this.next++, this.returnClass);
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        String tableList = params.getProperty("tables");
        if (tableList == null) {
            tableList = params.getProperty("identity_tables");
        }
        String[] tables = StringHelper.split(", ", tableList);
        String column = params.getProperty("column");
        if (column == null) {
            column = params.getProperty("target_column");
        }
        String schema = params.getProperty("schema");
        String catalog = params.getProperty("catalog");
        this.returnClass = type.getReturnedClass();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < tables.length; ++i) {
            if (tables.length > 1) {
                buf.append("select ").append(column).append(" from ");
            }
            buf.append(Table.qualify(catalog, schema, tables[i]));
            if (i >= tables.length - 1) continue;
            buf.append(" union ");
        }
        if (tables.length > 1) {
            buf.insert(0, "( ").append(" ) ids_");
            column = "ids_." + column;
        }
        this.sql = "select max(" + column + ") from " + buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNext(SessionImplementor session) {
        log.debug((Object)("fetching initial value: " + this.sql));
        try {
            PreparedStatement st = session.getBatcher().prepareSelectStatement(this.sql);
            try {
                ResultSet rs = st.executeQuery();
                try {
                    if (rs.next()) {
                        this.next = rs.getLong(1) + 1L;
                        if (rs.wasNull()) {
                            this.next = 1L;
                        }
                    } else {
                        this.next = 1L;
                    }
                    this.sql = null;
                    log.debug((Object)("first free id: " + this.next));
                }
                finally {
                    rs.close();
                }
            }
            finally {
                session.getBatcher().closeStatement(st);
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not fetch initial value for increment generator", this.sql);
        }
    }
}

