/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite.annotation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.tuckey.web.filters.urlrewrite.annotation.HttpExceptionHandler;
import org.tuckey.web.filters.urlrewrite.annotation.HttpJson;
import org.tuckey.web.filters.urlrewrite.annotation.HttpParam;
import org.tuckey.web.filters.urlrewrite.annotation.HttpUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"org.tuckey.web.filters.urlrewrite.*"})
public class UrlRewriteAnnotationProcessor
extends AbstractProcessor {
    private List<ProcessedHttpUrlAnnotation> processedAnnotations = new ArrayList<ProcessedHttpUrlAnnotation>();
    private List<ProcessedHttpJsonAnnotation> processedJsonAnnotations = new ArrayList<ProcessedHttpJsonAnnotation>();
    private List<ProcessedHttpExceptionAnnotation> httpExceptionHandlers = new ArrayList<ProcessedHttpExceptionAnnotation>();
    private Messager messager;
    private Elements elementUtils;
    private boolean showPositions = false;
    private boolean debug = false;
    private boolean errorDuringProcessing = false;
    private String dest = null;
    private String rpcBase = "/rpc/";

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> options = new HashSet<String>();
        options.add("urlrewriteDest");
        options.add("urlrewriteShowPositions");
        options.add("urlrewriteDebug");
        options.add("urlrewriteRpcBase");
        return options;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        Map<String, String> options = processingEnv.getOptions();
        Set<String> keys = options.keySet();
        for (String key : keys) {
            if (key.equalsIgnoreCase("urlrewriteDest")) {
                this.dest = options.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("urlrewriteShowPositions")) {
                this.showPositions = "true".equalsIgnoreCase(options.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("urlrewriteDebug")) {
                this.debug = "true".equalsIgnoreCase(options.get(key));
                continue;
            }
            if (!key.equalsIgnoreCase("urlrewriteRpcBase")) continue;
            this.rpcBase = options.get(key);
        }
        this.debugMsg("init");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (UrlRewriteAnnotationProcessor.isBlank(this.dest)) {
            if (roundEnv.processingOver()) {
                this.infoMsg(this.getClass().getSimpleName() + ": -AurlrewriteDest not specified, annotations ignored");
            }
            return true;
        }
        this.debugMsg("process");
        Set<? extends Element> urlDeclarations = roundEnv.getElementsAnnotatedWith(HttpUrl.class);
        for (Element element : urlDeclarations) {
            this.processedAnnotations.add(new ProcessedHttpUrlAnnotation(element));
        }
        Set<? extends Element> jsonDeclarations = roundEnv.getElementsAnnotatedWith(HttpJson.class);
        for (Element element : jsonDeclarations) {
            this.processedJsonAnnotations.add(new ProcessedHttpJsonAnnotation(element));
        }
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(HttpExceptionHandler.class);
        for (Element element : set) {
            this.httpExceptionHandlers.add(new ProcessedHttpExceptionAnnotation(element));
        }
        if (roundEnv.processingOver()) {
            if (this.processedAnnotations.size() > 0) {
                this.infoMsg("Got " + this.processedAnnotations.size() + " @HttpUrl annotations");
            }
            if (this.processedJsonAnnotations.size() > 0) {
                this.infoMsg("Got " + this.processedJsonAnnotations.size() + " @HttpJson annotations");
                this.processedAnnotations.addAll(this.processedJsonAnnotations);
            }
            Collections.sort(this.processedAnnotations);
            if (this.httpExceptionHandlers.size() > 0) {
                this.infoMsg("Got " + this.httpExceptionHandlers.size() + " @HttpExceptionHandler annotations");
                Collections.sort(this.httpExceptionHandlers);
            }
            try {
                File file = new File(this.dest);
                if (!file.exists()) {
                    UrlRewriteAnnotationProcessor.checkDirsExistMkdir(file.getParentFile());
                    file.createNewFile();
                }
                if (!file.canWrite()) {
                    throw new IOException("cannot write to " + file.getName());
                }
                if (this.errorDuringProcessing) {
                    this.errorMsg("Error occured during processing deleting generated file.");
                    file.delete();
                } else {
                    PrintWriter printWriter = new PrintWriter(file);
                    this.infoMsg("Writing to " + file);
                    this.outputRules(printWriter);
                    this.outputExceptionHandlers(printWriter);
                    printWriter.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.errorMsg(fileNotFoundException);
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                this.errorMsg(iOException);
                iOException.printStackTrace();
            }
        }
        return true;
    }

    private void outputRules(PrintWriter pw) {
        for (ProcessedHttpUrlAnnotation pa : this.processedAnnotations) {
            boolean jsonHandler = pa instanceof ProcessedHttpJsonAnnotation;
            pw.println("<rule>");
            pw.println("    <name>" + pa.className + "." + pa.methodName + "</name>");
            if (!UrlRewriteAnnotationProcessor.isBlank(pa.docComment)) {
                pw.println("    <note>");
                pw.println(UrlRewriteAnnotationProcessor.padEachLine("        ", UrlRewriteAnnotationProcessor.escapeXML(pa.docComment)));
                pw.println("    </note>");
            }
            pw.println("    <from>" + pa.value + "</from>");
            pw.println("    <run class=\"" + pa.className + "\" method=\"" + pa.methodName + pa.paramsFormatted + "\"" + (jsonHandler ? " handler=\"json\"" : "") + " />");
            if (!pa.chainUsed) {
                pw.println("    <to>null</to>");
            }
            pw.println("</rule>");
            pw.flush();
        }
    }

    private void outputExceptionHandlers(PrintWriter pw) {
        for (ProcessedHttpExceptionAnnotation pa : this.httpExceptionHandlers) {
            pw.println("<catch class=\"" + pa.exceptionName + "\">");
            if (!UrlRewriteAnnotationProcessor.isBlank(pa.docComment)) {
                pw.println("    <note>");
                pw.println(UrlRewriteAnnotationProcessor.padEachLine("        ", UrlRewriteAnnotationProcessor.escapeXML(pa.docComment)));
                pw.println("    </note>");
            }
            pw.println("    <run class=\"" + pa.className + "\" method=\"" + pa.methodName + pa.paramsFormatted + "\"/>");
            pw.println("</catch>");
            pw.flush();
        }
    }

    private static String escapeXML(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        StringBuffer b = new StringBuffer();
        block5: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    b.append("&amp;");
                    continue block5;
                }
                case '<': {
                    b.append("&lt;");
                    continue block5;
                }
                case '>': {
                    b.append("&gt;");
                    continue block5;
                }
                default: {
                    b.append(c);
                }
            }
        }
        return b.toString();
    }

    private static String padEachLine(String padWith, String str) {
        StringBuffer out = new StringBuffer();
        String[] lines = str.split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            out.append(padWith);
            out.append(line);
            if (++i >= lines.length) continue;
            out.append('\n');
        }
        return out.toString();
    }

    private static boolean isBlank(String str) {
        return str == null || "".equals(str) || "".equals(str.trim());
    }

    private static void checkDirsExistMkdir(File dir) {
        if (!dir.getParentFile().exists()) {
            UrlRewriteAnnotationProcessor.checkDirsExistMkdir(dir.getParentFile());
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    private void debugMsg(String msg) {
        if (!this.debug) {
            return;
        }
        this.messager.printMessage(Diagnostic.Kind.OTHER, this.getClass().getSimpleName() + " " + msg);
    }

    private void infoMsg(String msg) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, msg);
    }

    private void errorMsg(String msg) {
        this.errorDuringProcessing = true;
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg);
    }

    private void errorMsg(Exception e) {
        this.errorDuringProcessing = true;
        this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
    }

    private void errorMsg(String msg, Element element) {
        this.errorDuringProcessing = true;
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, element);
    }

    class ProcessedHttpExceptionAnnotation
    extends ProcessedUrlRewriteFilterAnnotation {
        public String exceptionName;

        public ProcessedHttpExceptionAnnotation(Element declaration) {
            ExecutableElement methodDeclaration = this.init(declaration);
            if (methodDeclaration == null) {
                return;
            }
            HttpExceptionHandler httpExceptionHandler = declaration.getAnnotation(HttpExceptionHandler.class);
            this.exceptionName = httpExceptionHandler.value();
            if ("[ unassigned ]".equals(this.exceptionName)) {
                this.exceptionName = ((Object)methodDeclaration.getParameters().get(0).asType()).toString();
            }
            this.setParams(methodDeclaration.getParameters());
            if (UrlRewriteAnnotationProcessor.this.showPositions) {
                UrlRewriteAnnotationProcessor.this.messager.printMessage(Diagnostic.Kind.NOTE, "@HttpExceptionHandlerUrl exceptionName " + this.exceptionName, methodDeclaration);
            }
        }

        public int compareTo(ProcessedHttpExceptionAnnotation other) {
            int comp = super.compareTo(other);
            if (comp == 0) {
                comp = this.exceptionName.compareTo(other.exceptionName);
            }
            return comp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProcessedHttpUrlAnnotation
    extends ProcessedUrlRewriteFilterAnnotation {
        public int weight;
        public String value;
        public boolean chainUsed;
        public String sourceRef;
        private static final String FILTER_CHAIN_CLASS_NAME = "javax.servlet.FilterChain";

        public ProcessedHttpUrlAnnotation() {
            this.weight = 0;
        }

        public ProcessedHttpUrlAnnotation(Element declaration) {
            this.weight = 0;
            ExecutableElement methodDeclaration = this.init(declaration);
            if (methodDeclaration == null) {
                return;
            }
            HttpUrl httpUrl = declaration.getAnnotation(HttpUrl.class);
            this.value = httpUrl.value();
            this.weight = httpUrl.weight();
            this.setParams(methodDeclaration.getParameters());
            if (UrlRewriteAnnotationProcessor.this.showPositions) {
                UrlRewriteAnnotationProcessor.this.messager.printMessage(Diagnostic.Kind.NOTE, "@HttpUrl value " + this.value + " weight " + this.weight, methodDeclaration);
            }
        }

        @Override
        public int compareTo(ProcessedHttpUrlAnnotation other) {
            if (this.weight < other.weight) {
                return 1;
            }
            if (this.weight > other.weight) {
                return -1;
            }
            return super.compareTo(other);
        }

        @Override
        protected void setParams(Collection<? extends VariableElement> params) {
            this.chainUsed = false;
            if (params.size() > 0) {
                for (VariableElement variableElement : params) {
                    String paramType = ((Object)variableElement.asType()).toString();
                    if (!FILTER_CHAIN_CLASS_NAME.equals(paramType)) continue;
                    this.chainUsed = true;
                }
            }
            super.setParams(params);
        }
    }

    class ProcessedHttpJsonAnnotation
    extends ProcessedHttpUrlAnnotation {
        public ProcessedHttpJsonAnnotation(Element declaration) {
            ExecutableElement methodDeclaration = this.init(declaration);
            if (methodDeclaration == null) {
                return;
            }
            HttpJson httpJson = declaration.getAnnotation(HttpJson.class);
            this.value = "[ unassigned ]".equals(httpJson.value()) ? UrlRewriteAnnotationProcessor.this.rpcBase + this.className + "/" + this.methodName : httpJson.value();
            this.weight = httpJson.weight();
            this.setParams(methodDeclaration.getParameters());
            if (UrlRewriteAnnotationProcessor.this.showPositions) {
                UrlRewriteAnnotationProcessor.this.messager.printMessage(Diagnostic.Kind.NOTE, "@HttpJson value " + this.value + " weight " + this.weight, methodDeclaration);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProcessedUrlRewriteFilterAnnotation
    implements Comparable<ProcessedUrlRewriteFilterAnnotation> {
        public String methodName;
        public String className;
        public String docComment;
        public String paramsFormatted;

        ProcessedUrlRewriteFilterAnnotation() {
        }

        public ExecutableElement init(Element declaration) {
            if (!ElementKind.METHOD.equals((Object)declaration.getKind())) {
                UrlRewriteAnnotationProcessor.this.errorMsg("declared on a non-method (type is " + (Object)((Object)declaration.getKind()) + ")", declaration);
                return null;
            }
            ExecutableElement methodDeclaration = (ExecutableElement)declaration;
            this.className = methodDeclaration.getEnclosingElement().getSimpleName().toString();
            this.methodName = declaration.getSimpleName().toString();
            this.docComment = UrlRewriteAnnotationProcessor.this.elementUtils.getDocComment(declaration);
            return methodDeclaration;
        }

        @Override
        public int compareTo(ProcessedUrlRewriteFilterAnnotation other) {
            int comp;
            if (this.className != null && other.className != null && (comp = this.className.compareTo(other.className)) != 0) {
                return comp;
            }
            if (this.methodName != null && other.methodName != null) {
                return this.methodName.compareTo(other.methodName);
            }
            return 0;
        }

        void setParams(Collection<? extends VariableElement> params) {
            this.paramsFormatted = "(";
            if (params.size() > 0) {
                int i = 1;
                for (VariableElement variableElement : params) {
                    String paramType = ((Object)variableElement.asType()).toString();
                    this.paramsFormatted = this.paramsFormatted + (i == 1 ? "" : ", ") + paramType;
                    HttpParam httpParam = variableElement.getAnnotation(HttpParam.class);
                    if (httpParam != null) {
                        this.paramsFormatted = this.paramsFormatted + " ";
                        this.paramsFormatted = !"[ unassigned ]".equals(httpParam.value()) ? this.paramsFormatted + httpParam.value() : this.paramsFormatted + variableElement.getSimpleName();
                    }
                    ++i;
                }
            }
            this.paramsFormatted = this.paramsFormatted + ")";
        }
    }
}

