-- ===============================================================================
--
-- Part of the InfoGlue Content Management Platform (www.infoglue.org)
--
-- ===============================================================================
--
--  Copyright (C)
--
-- This program is free software; you can redistribute it and/or modify it under
-- the terms of the GNU General Public License version 2, as published by the
-- Free Software Foundation. See the file LICENSE.html for more information.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
-- Place, Suite 330 / Boston, MA 02111-1307 / USA.
--
-- ===============================================================================
--
-- $Id: sqlserver-update-db-2.6-to-2.7.sql,v 1.1 2006/10/24 15:35:20 mattias Exp $
--
-- This script contains the database updates required to go from 2.6 to 2.7.

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].cmFormEntry') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmFormEntry; 

CREATE TABLE  cmFormEntry (
  id [int] IDENTITY (1, 1) NOT NULL,
  originAddress varchar(1024) NOT NULL,
  formName varchar(255) NOT NULL,
  formContentId int NOT NULL,
  userIP varchar(20) NOT NULL,
  userAgent varchar(255) NOT NULL,
  PRIMARY KEY  (id)
)
 
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].cmFormEntryValue') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmFormEntryValue;
 
CREATE TABLE  cmFormEntryValue (
  id [int] IDENTITY (1, 1) NOT NULL,
  name varchar(128) NOT NULL,
  value varchar(4096) NOT NULL,
  formEntryId int NOT NULL,
  PRIMARY KEY  (id)
)
 
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].cmSubscription') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmSubscription;
 
CREATE TABLE cmSubscription (
  id [int] IDENTITY (1, 1) NOT NULL,
  interceptionPointId int NOT NULL,
  name varchar(100) NOT NULL,
  isGlobal tinyint NOT NULL default '0',
  entityName varchar(100),
  entityId varchar(200),
  userName varchar(150) NOT NULL,
  userEmail varchar(150),
  lastNotifiedDateTime datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY(id)
)
 
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].cmSubscriptionFilter') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmSubscriptionFilter;
 
CREATE TABLE cmSubscriptionFilter (
  id [int] IDENTITY (1, 1) NOT NULL,
  subscriptionId int NOT NULL,
  filterType varchar(50) NOT NULL,
  filterCondition varchar(255) NOT NULL,
  isAndCondition tinyint NOT NULL default '1',
  PRIMARY KEY(id)
)