package org.infoglue.cmsinstaller;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TomcatInstallationCommander extends InstallationCommander 
{
	public TomcatInstallationCommander(String appServer, String targetFolder, String appNameSuffix, String tomcatFolder, String createCMS, String createDeliverWorking, String createDeliverPreview, String createDeliverLive, String tomcatContextFolder)
	{
		super(appServer, targetFolder, appNameSuffix, tomcatFolder, createCMS, createDeliverWorking, createDeliverPreview, createDeliverLive, tomcatContextFolder);
	}
	
	public void installFiles(String databaseTypeName) throws Exception
	{		
		if(this.createCMS.equalsIgnoreCase("yes"))
		{
			File cmsTargetFolderFile = new File(cmsTargetFolder);
			if(cmsTargetFolderFile.exists())
				deleteRecursive(cmsTargetFolderFile);
			cmsTargetFolderFile.mkdir();
		}
		
		if(this.createDeliverWorking.equalsIgnoreCase("yes"))
		{
			File deliverWorkingTargetFolderFile = new File(deliverWorkingTargetFolder);
			if(deliverWorkingTargetFolderFile.exists())
				deleteRecursive(deliverWorkingTargetFolderFile);
			deliverWorkingTargetFolderFile.mkdir();
		}
		
		if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		{
			File deliverPreviewTargetFolderFile = new File(deliverPreviewTargetFolder);
			if(deliverPreviewTargetFolderFile.exists())
				deleteRecursive(deliverPreviewTargetFolderFile);
			deliverPreviewTargetFolderFile.mkdir();
		}
		
		if(this.createDeliverLive.equalsIgnoreCase("yes"))
		{
			File deliverLiveTargetFolderFile = new File(deliverLiveTargetFolder);
			if(deliverLiveTargetFolderFile.exists())
				deleteRecursive(deliverLiveTargetFolderFile);
			deliverLiveTargetFolderFile.mkdir();
		}

		if(this.createCMS.equalsIgnoreCase("yes"))
		{
			Logger.logInfo("About to install cms package to " + this.cmsTargetFolder);
			unzipCMSWarFile(this.cmsTargetFolder);
		}
		
		if(this.createDeliverWorking.equalsIgnoreCase("yes"))
		{
		    Logger.logInfo("About to install deliver package to " + this.deliverWorkingTargetFolder);
		    unzipDeliverWarFile(this.deliverWorkingTargetFolder);
		}
		
		if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		{
			Logger.logInfo("About to install deliver package to " + this.deliverPreviewTargetFolder);
			unzipDeliverWarFile(this.deliverPreviewTargetFolder);
		}
		
		if(this.createDeliverLive.equalsIgnoreCase("yes"))
		{
			Logger.logInfo("About to install deliver package to " + this.deliverLiveTargetFolder);
			unzipDeliverWarFile(this.deliverLiveTargetFolder);
		}

		moveLocalConfigurationFiles(databaseTypeName);			

		/*
    	try 
    	{ 
    	    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(".\\curDir.zip")); 
    	    zipDir(".\\inFolder", zos); 
    	    zos.close(); 
    	} 
    	catch(Exception e) 
    	{ 
    	    //handle exception 
    	} 
    	*/
	}

	protected void moveLocalConfigurationFiles(String databaseTypeName) throws Exception
	{
	    System.err.println("Modifying OSCache-settings in all apps...");
	    modifyAllOSCachePropertyFiles();
	    
		if(this.createCMS.equalsIgnoreCase("yes"))
		{
	    	System.err.println("Copying file: " + "localConfigs/cms-web.xml");
		    copyInputStream(new FileInputStream("localConfigs/cms-web.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/web.xml")));
	
		    System.err.println("Copying file: " + "localConfigs/cms.properties");
		    copyInputStream(new FileInputStream("localConfigs/cms.properties"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/classes/cms.properties")));
	    	System.err.println("Copying file: " + "localConfigs/database.xml");
		    copyInputStream(new FileInputStream("localConfigs/database.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/classes/database.xml")));
	
		    System.err.println("Copying file: " + "localConfigs/hibernate.cfg.xml");
		    copyInputStream(new FileInputStream("localConfigs/hibernate.cfg.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/classes/hibernate.cfg.xml")));
	    	//System.err.println("Copying file: " + "localConfigs/osworkflow.xml");
		    //copyInputStream(new FileInputStream("localConfigs/osworkflow.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/classes/osworkflow.xml")));
	    	System.err.println("Copying file: " + "localConfigs/propertyset.xml");
		    copyInputStream(new FileInputStream("localConfigs/propertyset.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/classes/propertyset.xml")));
		}
		
		if(this.createDeliverWorking.equalsIgnoreCase("yes"))
		{
	    	System.err.println("Copying file: " + "localConfigs/deliverWorking.properties");
		    copyInputStream(new FileInputStream("localConfigs/deliverWorking.properties"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/classes/deliver.properties")));
	    	System.err.println("Copying file: " + "localConfigs/database.xml");
		    copyInputStream(new FileInputStream("localConfigs/database.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/classes/database.xml")));
	
	    	System.err.println("Copying file: " + "localConfigs/deliver-web.xml");
		    copyInputStream(new FileInputStream("localConfigs/deliver-web.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/web.xml")));
	
		    System.err.println("Copying file: " + "localConfigs/hibernate.cfg.xml");
		    copyInputStream(new FileInputStream("localConfigs/hibernate.cfg.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/classes/hibernate.cfg.xml")));
	    	//System.err.println("Copying file: " + "localConfigs/osworkflow.xml");
		    //copyInputStream(new FileInputStream("localConfigs/osworkflow.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/classes/osworkflow.xml")));
	    	System.err.println("Copying file: " + "localConfigs/propertyset.xml");
		    copyInputStream(new FileInputStream("localConfigs/propertyset.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/classes/propertyset.xml")));
		}
		
		if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		{
	    	System.err.println("Copying file: " + "localConfigs/deliver-web.xml");
		    copyInputStream(new FileInputStream("localConfigs/deliver-web.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/web.xml")));

		    System.err.println("Copying file: " + "localConfigs/deliverPreview.properties");
		    copyInputStream(new FileInputStream("localConfigs/deliverPreview.properties"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/classes/deliver.properties")));
	    	System.err.println("Copying file: " + "localConfigs/database.xml");
		    copyInputStream(new FileInputStream("localConfigs/database.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/classes/database.xml")));

		    System.err.println("Copying file: " + "localConfigs/hibernate.cfg.xml");
		    copyInputStream(new FileInputStream("localConfigs/hibernate.cfg.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/classes/hibernate.cfg.xml")));
		    //System.err.println("Copying file: " + "localConfigs/osworkflow.xml");
		    //copyInputStream(new FileInputStream("localConfigs/osworkflow.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/classes/osworkflow.xml")));
	    	System.err.println("Copying file: " + "localConfigs/propertyset.xml");
		    copyInputStream(new FileInputStream("localConfigs/propertyset.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/classes/propertyset.xml")));
		}
		
		if(this.createDeliverLive.equalsIgnoreCase("yes"))
		{
	    	System.err.println("Copying file: " + "localConfigs/deliver-web.xml");
		    copyInputStream(new FileInputStream("localConfigs/deliver-web.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/web.xml")));

	    	System.err.println("Copying file: " + "localConfigs/deliverLive.properties");
		    copyInputStream(new FileInputStream("localConfigs/deliverLive.properties"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/classes/deliver.properties")));
	    	System.err.println("Copying file: " + "localConfigs/database.xml");
		    copyInputStream(new FileInputStream("localConfigs/database.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/classes/database.xml")));

		    System.err.println("Copying file: " + "localConfigs/hibernate.cfg.xml");
		    copyInputStream(new FileInputStream("localConfigs/hibernate.cfg.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/classes/hibernate.cfg.xml")));
	    	//System.err.println("Copying file: " + "localConfigs/osworkflow.xml");
		    //copyInputStream(new FileInputStream("localConfigs/osworkflow.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/classes/osworkflow.xml")));
	    	System.err.println("Copying file: " + "localConfigs/propertyset.xml");
		    copyInputStream(new FileInputStream("localConfigs/propertyset.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/classes/propertyset.xml")));
		}
		
		File contextFileDir = new File(this.applicationServerHomePath + File.separator + this.tomcatContextFolder);
		contextFileDir.mkdirs();
		
		if(this.createCMS.equalsIgnoreCase("yes"))
		{
	        System.err.println("Moving cms context file: " + this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueCMS" + appNameSuffix + ".xml");
	        copyInputStream(new FileInputStream("localConfigs/infoglueCMS.xml"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueCMS" + appNameSuffix + ".xml")));
		}

		if(this.createDeliverWorking.equalsIgnoreCase("yes"))
		{
			System.err.println("Moving deliver working context file: " + this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverWorking" + appNameSuffix + ".xml");
			copyInputStream(new FileInputStream("localConfigs/infoglueDeliverWorking" + appNameSuffix + ".xml"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverWorking" + appNameSuffix + ".xml")));
		}
		
        if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		{
			System.err.println("Moving deliver preview context file: " + this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverPreview" + appNameSuffix + ".xml");
        	copyInputStream(new FileInputStream("localConfigs/infoglueDeliverPreview" + appNameSuffix + ".xml"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverPreview" + appNameSuffix + ".xml")));
		}
		
        if(this.createDeliverLive.equalsIgnoreCase("yes"))
		{
			System.err.println("Moving deliver live context file: " + this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverLive" + appNameSuffix + ".xml");
        	copyInputStream(new FileInputStream("localConfigs/infoglueDeliverLive" + appNameSuffix + ".xml"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverLive" + appNameSuffix + ".xml")));
		}

        String libName = "shared" + File.separator + "lib" + File.separator;
        if(this.appServer.equalsIgnoreCase("Tomcat 6.x"))
        	libName = "lib" + File.separator;
        
        System.err.println("Moving shared lib files: " + this.applicationServerHomePath + File.separator + libName);
        
        File oldPlutoRC2File = new File(this.applicationServerHomePath + File.separator + libName + "pluto-1.0.1-rc2.jar");
        if(oldPlutoRC2File.exists())
        	oldPlutoRC2File.delete();
        File oldPlutoRC4File = new File(this.applicationServerHomePath + File.separator + libName + "pluto-1.0.1-rc4.jar");
        if(oldPlutoRC4File.exists())
        	oldPlutoRC4File.delete();
        
        List<String> sharedLibs = getSharedLibs();
        Iterator<String> sharedLibsIterator = sharedLibs.iterator();
        while(sharedLibsIterator.hasNext())
        {
        	String sharedLib = sharedLibsIterator.next();
            copyInputStream(new FileInputStream("lib" + File.separator + sharedLib), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + libName + sharedLib)));
        }
                
		Logger.logInfo("databaseTypeName:" + databaseTypeName);
		if(databaseTypeName.equalsIgnoreCase("MySQL"))
		{
        	//copyInputStream(new FileInputStream("lib/mysql-connector-java-3.0.6-stable-bin.jar"), new BufferedOutputStream(new FileOutputStream(this.tomcatFolder + File.separator + "server" + File.separator + "lib" + File.separator + "mysql-connector-java-3.0.6-stable-bin.jar")));
		}
		else if(databaseTypeName.equalsIgnoreCase("SQL Server"))
		{
			//copyInputStream(new FileInputStream("lib/jtds-0.7.jar"), new BufferedOutputStream(new FileOutputStream(this.tomcatFolder + File.separator + "server" + File.separator + "lib" + File.separator + "jtds-0.7.jar")));
	        
	        /*
	        copyInputStream(new FileInputStream("lib/msutil.jar"), new BufferedOutputStream(new FileOutputStream(this.tomcatFolder + File.separator + "server" + File.separator + "lib" + File.separator + "msutil.jar")));
	        copyInputStream(new FileInputStream("lib/mssqlserver.jar"), new BufferedOutputStream(new FileOutputStream(this.tomcatFolder + File.separator + "server" + File.separator + "lib" + File.separator + "mssqlserver.jar")));
	        copyInputStream(new FileInputStream("lib/msbase.jar"), new BufferedOutputStream(new FileOutputStream(this.tomcatFolder + File.separator + "server" + File.separator + "lib" + File.separator + "msbase.jar")));
			*/
		}
		else if(databaseTypeName.equalsIgnoreCase("Oracle"))
		{
			//copyInputStream(new FileInputStream("lib/ojdbc14.jar"), new BufferedOutputStream(new FileOutputStream(this.tomcatFolder + File.separator + "server" + File.separator + "lib" + File.separator + "ojdbc14.jar")));
			
			//System.err.println("Copying file: " + "configTemplates/oracle_mapping.xml");
			//copyInputStream(new FileInputStream("configTemplates/oracle_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/classes/mapping.xml")));
			
			//System.err.println("Copying file: " + "configTemplates/oracle_mapping.xml");
			//copyInputStream(new FileInputStream("configTemplates/oracle_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/classes/oracle_mapping.xml")));
			
			//if(this.createDeliverPreview.equalsIgnoreCase("yes"))
			//	copyInputStream(new FileInputStream("configTemplates/oracle_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/classes/oracle_mapping.xml")));

			//if(this.createDeliverLive.equalsIgnoreCase("yes"))
			//	copyInputStream(new FileInputStream("configTemplates/oracle_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/classes/oracle_mapping.xml")));
		}
		else if(databaseTypeName.equalsIgnoreCase("DB2"))
		{
			//copyInputStream(new FileInputStream("lib/db2jcc.jar"), new BufferedOutputStream(new FileOutputStream(this.tomcatFolder + File.separator + "server" + File.separator + "lib" + File.separator + "db2jcc.jar")));
			
			//System.err.println("Copying file: " + "configTemplates/db2_mapping.xml");
			//copyInputStream(new FileInputStream("configTemplates/db2_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/classes/db2_mapping.xml")));
			
			//System.err.println("Copying file: " + "configTemplates/db2_mapping.xml");
			//copyInputStream(new FileInputStream("configTemplates/db2_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/classes/db2_mapping.xml")));
			
			//if(this.createDeliverPreview.equalsIgnoreCase("yes"))
			//	copyInputStream(new FileInputStream("configTemplates/db2_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/classes/db2_mapping.xml")));

			//if(this.createDeliverLive.equalsIgnoreCase("yes"))
			//	copyInputStream(new FileInputStream("configTemplates/db2_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/classes/db2_mapping.xml")));
		}
		
		if(checkIfXMLLibsIsNeeded())
		{
		    if(this.createCMS.equalsIgnoreCase("yes"))
			{
				copyInputStream(new FileInputStream("lib/xercesImpl.jar"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "xercesImpl.jar")));
				copyInputStream(new FileInputStream("lib/xml-apis.jar"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "xml-apis.jar")));
			}
		    
		    if(this.createDeliverWorking.equalsIgnoreCase("yes"))
			{
				copyInputStream(new FileInputStream("lib/xercesImpl.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "xercesImpl.jar")));
				copyInputStream(new FileInputStream("lib/xml-apis.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "xml-apis.jar")));
			}
		    
			if(this.createDeliverPreview.equalsIgnoreCase("yes"))
			{
				copyInputStream(new FileInputStream("lib/xercesImpl.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "xercesImpl.jar")));
				copyInputStream(new FileInputStream("lib/xml-apis.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "xml-apis.jar")));
			}
			
			if(this.createDeliverLive.equalsIgnoreCase("yes"))
			{
				copyInputStream(new FileInputStream("lib/xercesImpl.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "xercesImpl.jar")));
				copyInputStream(new FileInputStream("lib/xml-apis.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "xml-apis.jar")));
			}
		}
		
		//Replace jstl and standard if tomcat 4.
		if(appServer.startsWith("Tomcat 4"))
		{
		    if(this.createCMS.equalsIgnoreCase("yes"))
			{
			    File existingStandardJar = new File(this.cmsTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "standard.jar");
			    if(existingStandardJar.exists())
				    existingStandardJar.delete();
				File existingJSTLJar = new File(this.cmsTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "jstl.jar");
				if(existingJSTLJar.exists())
				    existingJSTLJar.delete();
				
				copyInputStream(new FileInputStream("lib/standard-1.0.4.jar"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "standard-1.0.4.jar")));
				copyInputStream(new FileInputStream("lib/jstl-1.0.2.jar"), new BufferedOutputStream(new FileOutputStream(this.cmsTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "jstl-1.0.2.jar")));		    
			}
		    
		    if(this.createDeliverWorking.equalsIgnoreCase("yes"))
			{
			    File existingStandardJar = new File(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "standard.jar");
			    if(existingStandardJar.exists())
				    existingStandardJar.delete();
				File existingJSTLJar = new File(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "jstl.jar");
				if(existingJSTLJar.exists())
				    existingJSTLJar.delete();
				
				copyInputStream(new FileInputStream("lib/standard-1.0.4.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "standard-1.0.4.jar")));
				copyInputStream(new FileInputStream("lib/jstl-1.0.2.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "jstl-1.0.2.jar")));		    
			}
		    
			if(this.createDeliverPreview.equalsIgnoreCase("yes"))
			{
			    File existingStandardJar = new File(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "standard.jar");
			    if(existingStandardJar.exists())
				    existingStandardJar.delete();
				File existingJSTLJar = new File(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "jstl.jar");
				if(existingJSTLJar.exists())
				    existingJSTLJar.delete();
				
				copyInputStream(new FileInputStream("lib/standard-1.0.4.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "standard-1.0.4.jar")));
				copyInputStream(new FileInputStream("lib/jstl-1.0.2.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "jstl-1.0.2.jar")));		    
			}
			
			if(this.createDeliverLive.equalsIgnoreCase("yes"))
			{
			    File existingStandardJar = new File(this.deliverLiveTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "standard.jar");
			    if(existingStandardJar.exists())
				    existingStandardJar.delete();
				File existingJSTLJar = new File(this.deliverLiveTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "jstl.jar");
				if(existingJSTLJar.exists())
				    existingJSTLJar.delete();
				
			    copyInputStream(new FileInputStream("lib/standard-1.0.4.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "standard-1.0.4.jar")));
				copyInputStream(new FileInputStream("lib/jstl-1.0.2.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTargetFolder + File.separator + "WEB-INF/lib" + File.separator + "jstl-1.0.2.jar")));		    
			}
		}
	
	}

	public void modifyAllOSCachePropertyFiles() throws Exception
	{
	    if(this.createCMS.equalsIgnoreCase("yes"))
	        modifyOSCachePropertyFile(this.cmsTargetFolder);
	    
	    if(this.createDeliverWorking.equalsIgnoreCase("yes"))
	        modifyOSCachePropertyFile(this.deliverWorkingTargetFolder);
	    
	    if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		    modifyOSCachePropertyFile(this.deliverPreviewTargetFolder);
		
	    if(this.createDeliverLive.equalsIgnoreCase("yes"))
		    modifyOSCachePropertyFile(this.deliverLiveTargetFolder);
	}

	public String getPortletBase() 
	{
	    return this.applicationServerHomePath + File.separator + "webapps";
	}

}
