/* ===============================================================================
 *
 * Part of the InfoGlue Content Management Platform (www.infoglue.org)
 *
 * ===============================================================================
 *
 *  Copyright (C)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2, as published by the
 * Free Software Foundation. See the file LICENSE.html for more information.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
 * Place, Suite 330 / Boston, MA 02111-1307 / USA.
 *
 * ===============================================================================
 */

package org.infoglue.cmsinstaller;

import java.io.*;
import java.util.regex.Pattern;
  
public class TomcatConfigFilesUpdater 
{
	private String path    = null;
	private String appName = null;
	private String appDir  = null;
	private String logDir  = null;
	private String connUrl = null;
	private String usrName = null;
	private String usrPass = null; 
	private String driverName = null;

	public void setPath(String path)
	{
		this.path = path;
	}

	public void setAppName(String appName)
	{
		this.appName = appName;
	}

	public void setAppDir(String appDir)
	{
		this.appDir = appDir;
	}
	
	public void setLogDir(String logDir)
	{
		this.logDir = logDir;
	}

	public void setDriverName(String driverName)
	{
		this.driverName = driverName;
	}

	public void setConnUrl(String connUrl)
	{
		this.connUrl = connUrl;
	}

	public void setUsrName(String usrName)
	{
		this.usrName = usrName;
	}

	public void setUsrPass(String usrPass)
	{
		this.usrPass = usrPass;
	}

	
	/**
	 * This method updates the config-files needed to deploy a new application with a context.
	 */
	public void updateConfiguration() throws Exception
	{
	    createInfoGlueCMSContextFile(appName, appDir, logDir, driverName, connUrl, usrName, usrPass);
	}
	
	/**
	 * This method updates the config-files needed to deploy a new application with a context.
	 */
	public void updateConfiguration(String appName, String appDir, String logDir) throws Exception
	{
	    createInfoGlueDeliverContextFile(appName, appDir, logDir);
	}

	/**
	 * This method creates a new context-node.
	 */
	 
	private void createInfoGlueCMSContextFile(String appName, String appDir, String logDir, String driverName, String connectionURL, String userName, String password) throws Exception
	{
		FileInputStream fis = new FileInputStream("configTemplates/infoglueCMS.xml");
		String result = "";
		StringBuffer sb = new StringBuffer();
		
		int c;
		while((c = fis.read()) != -1)
		{
			sb.append((char)c);
		}
		result = sb.toString();
		//Logger.logInfo("result" + result);
		
		appDir = appDir.replace('\\', '/');
		logDir = logDir.replace('\\', '/');
		
		Pattern escaper = Pattern.compile("([^a-zA-z0-9])");
		String newPassword = escaper.matcher(password).replaceAll("\\\\$1");
		//System.out.println("password:" + password);
		//System.out.println("newPassword:" + newPassword);
		
		result = result.replaceAll("\\{appName\\}", appName);
		result = result.replaceAll("\\{applicationPath\\}", appDir);
		result = result.replaceAll("\\{driverName\\}", driverName);
		result = result.replaceAll("\\{connectionURL\\}", connectionURL);
		result = result.replaceAll("\\{userName\\}", userName);
		result = result.replaceAll("\\{password\\}", newPassword);
		result = result.replaceAll("\\{logDir\\}", logDir);
		
		PrintWriter pw = new PrintWriter(new FileOutputStream("localConfigs/infoglueCMS.xml"));
		pw.println(result);
		pw.close();
	}

	/**
	 * This method creates a new context-node for the deliver engine.
	 */
	 
	private void createInfoGlueDeliverContextFile(String appName, String appDir, String logDir) throws Exception
	{
		FileInputStream fis = new FileInputStream("configTemplates/infoglueDeliver.xml");
		String result = "";
		StringBuffer sb = new StringBuffer();
		
		int c;
		while((c = fis.read()) != -1)
		{
			sb.append((char)c);
		}
		result = sb.toString();
		//Logger.logInfo("result" + result);
		
		appDir = appDir.replace('\\', '/');
		logDir = logDir.replace('\\', '/');
		
		result = result.replaceAll("\\{appName\\}", appName);
		result = result.replaceAll("\\{applicationPath\\}", appDir);
		result = result.replaceAll("\\{logDir\\}", logDir);
		
		PrintWriter pw = new PrintWriter(new FileOutputStream("localConfigs/" + appName + ".xml"));
		pw.println(result);
		pw.close();
	}

}