/* ===============================================================================
 *
 * Part of the InfoGlue Content Management Platform (www.infoglue.org)
 *
 * ===============================================================================
 *
 *  Copyright (C)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2, as published by the
 * Free Software Foundation. See the file LICENSE.html for more information.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
 * Place, Suite 330 / Boston, MA 02111-1307 / USA.
 *
 * ===============================================================================
 */

package org.infoglue.cmsinstaller;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.File;

/**
 * This is the main class for the installer.
 */

public class PortletCheckboxListener implements MouseListener
{
	private JCheckBox checkBox = null;
	private JTextField applicationPath = null;
	private JTextField tomcatPath = null;
	private JButton browseButton2 = null;
	
	public PortletCheckboxListener(JCheckBox checkBox, JTextField applicationPath, JTextField tomcatPath, JButton browseButton2)
	{	
		super();
		this.checkBox = checkBox;
		this.applicationPath = applicationPath;
		this.tomcatPath = tomcatPath;
		this.browseButton2 = browseButton2;
		
		checkBox.addMouseListener(this);
	}
	
	
	public void mouseClicked(MouseEvent e)
	{
	    if(this.checkBox.isSelected() == true)
	    {
	        this.applicationPath.setText(this.tomcatPath.getText() + File.separator + "webapps");
	        this.applicationPath.setEditable(false);
	        this.browseButton2.setEnabled(false);
	        this.browseButton2.setVisible(false);
	    }
	    else
	    {
	        this.applicationPath.setEditable(true);
	        this.browseButton2.setEnabled(true);
	        this.browseButton2.setVisible(true);
	    }
	} 

	public void mouseEntered(MouseEvent e){}; 
	public void mouseExited(MouseEvent e){}; 
	public void mousePressed(MouseEvent e){}; 
	public void mouseReleased(MouseEvent e){}; 

}