package org.infoglue.cmsinstaller;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipOutputStream;

public class JBossInstallationCommander extends InstallationCommander 
{
	private File cmsTempFolderFile 				= null;
	private File deliverWorkingTempFolderFile 	= null;
	private File deliverPreviewTempFolderFile 	= null;
	private File deliverLiveTempFolderFile 		= null;
	
	public JBossInstallationCommander(String appServer, String targetFolder, String appNameSuffix, String applicationServerHomePath, String createCMS, String createDeliverWorking, String createDeliverPreview, String createDeliverLive, String tomcatContextFolder)
	{
		super(appServer, targetFolder, appNameSuffix, applicationServerHomePath, createCMS, createDeliverWorking, createDeliverPreview, createDeliverLive, tomcatContextFolder);
	}
	
	public void installFiles(String databaseTypeName) throws Exception
	{		
		if(this.createCMS.equalsIgnoreCase("yes"))
		{
			this.cmsTempFolderFile = new File("localConfigs/infoglueCMS" + appNameSuffix);
			if(this.cmsTempFolderFile.exists())
				deleteRecursive(this.cmsTempFolderFile);
			this.cmsTempFolderFile.mkdir();
/*
			File cmsTargetFolderFile = new File(cmsTargetFolder);
			if(cmsTargetFolderFile.exists())
				deleteRecursive(cmsTargetFolderFile);
			cmsTargetFolderFile.mkdir();
*/
		}
		
		if(this.createDeliverWorking.equalsIgnoreCase("yes"))
		{
			this.deliverWorkingTempFolderFile = new File("localConfigs/infoglueDeliverWorking" + appNameSuffix);
			if(this.deliverWorkingTempFolderFile.exists())
				deleteRecursive(this.deliverWorkingTempFolderFile);
			this.deliverWorkingTempFolderFile.mkdir();
/*
			File deliverWorkingTargetFolderFile = new File(deliverWorkingTargetFolder);
			if(deliverWorkingTargetFolderFile.exists())
				deleteRecursive(deliverWorkingTargetFolderFile);
			deliverWorkingTargetFolderFile.mkdir();
*/
		}
		
		if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		{
			this.deliverPreviewTempFolderFile = new File("localConfigs/infoglueDeliverPreview" + appNameSuffix);
			if(this.deliverPreviewTempFolderFile.exists())
				deleteRecursive(this.deliverPreviewTempFolderFile);
			this.deliverPreviewTempFolderFile.mkdir();
/*
			File deliverPreviewTargetFolderFile = new File(deliverPreviewTargetFolder);
			if(deliverPreviewTargetFolderFile.exists())
				deleteRecursive(deliverPreviewTargetFolderFile);
			deliverPreviewTargetFolderFile.mkdir();
*/
		}
		
		if(this.createDeliverLive.equalsIgnoreCase("yes"))
		{
			this.deliverLiveTempFolderFile = new File("localConfigs/infoglueDeliverLive" + appNameSuffix);
			if(this.deliverLiveTempFolderFile.exists())
				deleteRecursive(this.deliverLiveTempFolderFile);
			this.deliverLiveTempFolderFile.mkdir();

/*
			File deliverLiveTargetFolderFile = new File(deliverLiveTargetFolder);
			if(deliverLiveTargetFolderFile.exists())
				deleteRecursive(deliverLiveTargetFolderFile);
			deliverLiveTargetFolderFile.mkdir();
*/
		}

		if(this.createCMS.equalsIgnoreCase("yes"))
		{
			Logger.logInfo("About to install cms package to " + this.cmsTempFolderFile);
			unzipCMSWarFile(this.cmsTempFolderFile.getPath());
		}
		
		if(this.createDeliverWorking.equalsIgnoreCase("yes"))
		{
		    Logger.logInfo("About to install deliver package to " + this.deliverWorkingTempFolderFile);
		    unzipDeliverWarFile(this.deliverWorkingTempFolderFile.getPath());
		}
		
		if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		{
			Logger.logInfo("About to install deliver package to " + this.deliverPreviewTempFolderFile.getPath());
			unzipDeliverWarFile(this.deliverPreviewTempFolderFile.getPath());
		}
		
		if(this.createDeliverLive.equalsIgnoreCase("yes"))
		{
			Logger.logInfo("About to install deliver package to " + this.deliverLiveTempFolderFile.getPath());
			unzipDeliverWarFile(this.deliverLiveTempFolderFile.getPath());
		}

		moveLocalConfigurationFiles(databaseTypeName);			

		if(this.createCMS.equalsIgnoreCase("yes"))
		{
		    System.out.println("Zipping " + cmsTempFolderFile.getPath());
			ZipOutputStream zos = new ZipOutputStream(new FileOutputStream("localConfigs/infoglueCMS" + this.appNameSuffix + ".war")); 
		    zipDir(cmsTempFolderFile.getPath(), ("localConfigs/infoglueCMS" + this.appNameSuffix + "/").length(), zos); 
		    zos.close(); 
		}

		if(this.createDeliverWorking.equalsIgnoreCase("yes"))
		{
			ZipOutputStream zos2 = new ZipOutputStream(new FileOutputStream("localConfigs/infoglueDeliverWorking" + this.appNameSuffix + ".war")); 
		    zipDir(deliverWorkingTempFolderFile.getPath(), ("localConfigs/infoglueDeliverWorking" + this.appNameSuffix + "/").length(), zos2); 
		    zos2.close(); 
		}
		
		if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		{
			ZipOutputStream zos3 = new ZipOutputStream(new FileOutputStream("localConfigs/infoglueDeliverPreview" + this.appNameSuffix + ".war")); 
		    zipDir(deliverPreviewTempFolderFile.getPath(), ("localConfigs/infoglueDeliverPreview" + this.appNameSuffix + "/").length(), zos3); 
		    zos3.close(); 
		}
		
		if(this.createDeliverLive.equalsIgnoreCase("yes"))
		{
			ZipOutputStream zos4 = new ZipOutputStream(new FileOutputStream("localConfigs/infoglueDeliverLive" + this.appNameSuffix + ".war")); 
		    zipDir(deliverLiveTempFolderFile.getPath(), ("localConfigs/infoglueDeliverLive" + this.appNameSuffix + "/").length(), zos4); 
		    zos4.close(); 
		}
		
	    String applicationServerDeploymentDirectory = this.applicationServerHomePath + File.separator + "server" + File.separator + "default" + File.separator + "deploy";
		if(this.createCMS.equalsIgnoreCase("yes"))
		{
			System.err.println("Deploying cms war file to JBoss at ");
		    copyInputStream(new FileInputStream("localConfigs/infoglueCMS" + this.appNameSuffix + ".war"), new BufferedOutputStream(new FileOutputStream(applicationServerDeploymentDirectory + File.separator + "infoglueCMS" + this.appNameSuffix + ".war")));
		}
		
		if(this.createDeliverWorking.equalsIgnoreCase("yes"))
		{
			System.err.println("Deploying deliver working war file to JBoss at ");
		    copyInputStream(new FileInputStream("localConfigs/infoglueDeliverWorking" + this.appNameSuffix + ".war"), new BufferedOutputStream(new FileOutputStream(applicationServerDeploymentDirectory + File.separator + "infoglueDeliverWorking" + this.appNameSuffix + ".war")));
		}
		
		if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		{
			System.err.println("Deploying deliver preview war file to JBoss at ");
		    copyInputStream(new FileInputStream("localConfigs/infoglueDeliverPreview" + this.appNameSuffix + ".war"), new BufferedOutputStream(new FileOutputStream(applicationServerDeploymentDirectory + File.separator + "infoglueDeliverPreview" + this.appNameSuffix + ".war")));
		}
		
		if(this.createDeliverLive.equalsIgnoreCase("yes"))
		{
			System.err.println("Deploying deliver live war file to JBoss at ");
		    copyInputStream(new FileInputStream("localConfigs/infoglueDeliverLive" + this.appNameSuffix + ".war"), new BufferedOutputStream(new FileOutputStream(applicationServerDeploymentDirectory + File.separator + "infoglueDeliverLive" + this.appNameSuffix + ".war")));
		}
	}

	protected void moveLocalConfigurationFiles(String databaseTypeName) throws Exception
	{
	    System.err.println("Modifying OSCache-settings in all apps...");
	    modifyAllOSCachePropertyFiles();
	    
		if(this.createCMS.equalsIgnoreCase("yes"))
		{
	    	System.err.println("Copying file: " + "localConfigs/cms-web.xml");
		    copyInputStream(new FileInputStream("localConfigs/cms-web.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/web.xml")));
	
		    System.err.println("Copying file: " + "localConfigs/cms.properties");
		    copyInputStream(new FileInputStream("localConfigs/cms.properties"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/classes/cms.properties")));
	    	System.err.println("Copying file: " + "localConfigs/database.xml");
		    copyInputStream(new FileInputStream("localConfigs/database.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/classes/database.xml")));
	
		    System.err.println("Copying file: " + "localConfigs/hibernate.cfg.xml");
		    copyInputStream(new FileInputStream("localConfigs/hibernate.cfg.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/classes/hibernate.cfg.xml")));
	    	//System.err.println("Copying file: " + "localConfigs/osworkflow.xml");
		    //copyInputStream(new FileInputStream("localConfigs/osworkflow.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/classes/osworkflow.xml")));
	    	System.err.println("Copying file: " + "localConfigs/propertyset.xml");
		    copyInputStream(new FileInputStream("localConfigs/propertyset.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/classes/propertyset.xml")));
		}
		
		if(this.createDeliverWorking.equalsIgnoreCase("yes"))
		{
	    	System.err.println("Copying file: " + "localConfigs/deliverWorking.properties");
		    copyInputStream(new FileInputStream("localConfigs/deliverWorking.properties"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/classes/deliver.properties")));
	    	System.err.println("Copying file: " + "localConfigs/database.xml");
		    copyInputStream(new FileInputStream("localConfigs/database.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/classes/database.xml")));
	
	    	System.err.println("Copying file: " + "localConfigs/deliver-web.xml");
		    copyInputStream(new FileInputStream("localConfigs/deliver-web.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/web.xml")));
	
		    System.err.println("Copying file: " + "localConfigs/hibernate.cfg.xml");
		    copyInputStream(new FileInputStream("localConfigs/hibernate.cfg.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/classes/hibernate.cfg.xml")));
	    	//System.err.println("Copying file: " + "localConfigs/osworkflow.xml");
		    //copyInputStream(new FileInputStream("localConfigs/osworkflow.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/classes/osworkflow.xml")));
	    	System.err.println("Copying file: " + "localConfigs/propertyset.xml");
		    copyInputStream(new FileInputStream("localConfigs/propertyset.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/classes/propertyset.xml")));
		
		    /*
		    if(this.appServer.startsWith("JBoss"))
		    {
		    	//If JBoss we have to install the patched pluto driver which handles -exp-directories.
		    	System.err.println("Copying file: " + "lib/pluto-portal-1.0.1-JBOSSPatched.jar");
			    copyInputStream(new FileInputStream("lib/pluto-portal-1.0.1-JBOSSPatched.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/lib/pluto-portal-1.0.1.jar")));
			}
			*/
		}
		
		if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		{
	    	System.err.println("Copying file: " + "localConfigs/deliver-web.xml");
		    copyInputStream(new FileInputStream("localConfigs/deliver-web.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/web.xml")));

		    System.err.println("Copying file: " + "localConfigs/deliverPreview.properties");
		    copyInputStream(new FileInputStream("localConfigs/deliverPreview.properties"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/classes/deliver.properties")));
	    	System.err.println("Copying file: " + "localConfigs/database.xml");
		    copyInputStream(new FileInputStream("localConfigs/database.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/classes/database.xml")));

		    System.err.println("Copying file: " + "localConfigs/hibernate.cfg.xml");
		    copyInputStream(new FileInputStream("localConfigs/hibernate.cfg.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/classes/hibernate.cfg.xml")));
		    //System.err.println("Copying file: " + "localConfigs/osworkflow.xml");
		    //copyInputStream(new FileInputStream("localConfigs/osworkflow.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/classes/osworkflow.xml")));
	    	System.err.println("Copying file: " + "localConfigs/propertyset.xml");
		    copyInputStream(new FileInputStream("localConfigs/propertyset.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/classes/propertyset.xml")));
		    /*
		    if(this.appServer.startsWith("JBoss"))
		    {
		    	//If JBoss we have to install the patched pluto driver which handles -exp-directories.
		    	System.err.println("Copying file: " + "lib/pluto-portal-1.0.1-JBOSSPatched.jar");
			    copyInputStream(new FileInputStream("lib/pluto-portal-1.0.1-JBOSSPatched.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/lib/pluto-portal-1.0.1.jar")));
			}
			*/
		}
		
		if(this.createDeliverLive.equalsIgnoreCase("yes"))
		{
	    	System.err.println("Copying file: " + "localConfigs/deliver-web.xml");
		    copyInputStream(new FileInputStream("localConfigs/deliver-web.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/web.xml")));

	    	System.err.println("Copying file: " + "localConfigs/deliverLive.properties");
		    copyInputStream(new FileInputStream("localConfigs/deliverLive.properties"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/classes/deliver.properties")));
	    	System.err.println("Copying file: " + "localConfigs/database.xml");
		    copyInputStream(new FileInputStream("localConfigs/database.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/classes/database.xml")));

		    System.err.println("Copying file: " + "localConfigs/hibernate.cfg.xml");
		    copyInputStream(new FileInputStream("localConfigs/hibernate.cfg.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/classes/hibernate.cfg.xml")));
	    	//System.err.println("Copying file: " + "localConfigs/osworkflow.xml");
		    //copyInputStream(new FileInputStream("localConfigs/osworkflow.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/classes/osworkflow.xml")));
	    	System.err.println("Copying file: " + "localConfigs/propertyset.xml");
		    copyInputStream(new FileInputStream("localConfigs/propertyset.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/classes/propertyset.xml")));
		    /*
		    if(this.appServer.startsWith("JBoss"))
		    {
		    	//If JBoss we have to install the patched pluto driver which handles -exp-directories.
		    	System.err.println("Copying file: " + "lib/pluto-portal-1.0.1-JBOSSPatched.jar");
			    copyInputStream(new FileInputStream("lib/pluto-portal-1.0.1-JBOSSPatched.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/lib/pluto-portal-1.0.1.jar")));
			}
			*/
		}
		
		/*
		if(this.createCMS.equalsIgnoreCase("yes"))
		{
	        System.err.println("Moving cms context file: " + this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueCMS" + appNameSuffix + ".xml");
	        copyInputStream(new FileInputStream("localConfigs/infoglueCMS.xml"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueCMS" + appNameSuffix + ".xml")));
		}

		if(this.createDeliverWorking.equalsIgnoreCase("yes"))
		{
			System.err.println("Moving deliver working context file: " + this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverWorking" + appNameSuffix + ".xml");
			copyInputStream(new FileInputStream("localConfigs/infoglueDeliverWorking" + appNameSuffix + ".xml"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverWorking" + appNameSuffix + ".xml")));
		}
		
        if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		{
			System.err.println("Moving deliver preview context file: " + this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverPreview" + appNameSuffix + ".xml");
        	copyInputStream(new FileInputStream("localConfigs/infoglueDeliverPreview" + appNameSuffix + ".xml"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverPreview" + appNameSuffix + ".xml")));
		}
		
        if(this.createDeliverLive.equalsIgnoreCase("yes"))
		{
			System.err.println("Moving deliver live context file: " + this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverLive" + appNameSuffix + ".xml");
        	copyInputStream(new FileInputStream("localConfigs/infoglueDeliverLive" + appNameSuffix + ".xml"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + this.tomcatContextFolder + File.separator + "infoglueDeliverLive" + appNameSuffix + ".xml")));
		}
		*/
		
        System.err.println("Moving pluto files: " + this.applicationServerHomePath + File.separator + "server" + File.separator + "default" + File.separator + "lib" + File.separator);

        String serverPath = "server" + File.separator + "default" + File.separator + "lib" + File.separator;
        String libPath = "shared" + File.separator + "lib" + File.separator;
        //if(this.appServer.equalsIgnoreCase("JBoss 5.0"))
        //	libName = "lib" + File.separator;

        File oldPlutoRC2File = new File(this.applicationServerHomePath + File.separator + serverPath + "pluto-1.0.1-rc2.jar");
        if(oldPlutoRC2File.exists())
        	oldPlutoRC2File.delete();
        File oldPlutoRC4File = new File(this.applicationServerHomePath + File.separator + serverPath + "pluto-1.0.1-rc4.jar");
        if(oldPlutoRC4File.exists())
        	oldPlutoRC4File.delete();

        List<String> sharedLibs = getSharedLibs();
        Iterator<String> sharedLibsIterator = sharedLibs.iterator();
        while(sharedLibsIterator.hasNext())
        {
        	String sharedLib = sharedLibsIterator.next();
            copyInputStream(new FileInputStream("lib" + File.separator + sharedLib), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + libPath + sharedLib)));
        }
        
		Logger.logInfo("databaseTypeName:" + databaseTypeName);
		if(databaseTypeName.equalsIgnoreCase("MySQL"))
		{
        	//copyInputStream(new FileInputStream("lib/mysql-connector-java-3.0.6-stable-bin.jar"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + "server" + File.separator + "lib" + File.separator + "mysql-connector-java-3.0.6-stable-bin.jar")));
		}
		else if(databaseTypeName.equalsIgnoreCase("SQL Server"))
		{
			//copyInputStream(new FileInputStream("lib/jtds-0.7.jar"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + "server" + File.separator + "lib" + File.separator + "jtds-0.7.jar")));
	        
	        /*
	        copyInputStream(new FileInputStream("lib/msutil.jar"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + "server" + File.separator + "lib" + File.separator + "msutil.jar")));
	        copyInputStream(new FileInputStream("lib/mssqlserver.jar"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + "server" + File.separator + "lib" + File.separator + "mssqlserver.jar")));
	        copyInputStream(new FileInputStream("lib/msbase.jar"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + "server" + File.separator + "lib" + File.separator + "msbase.jar")));
			*/
		}
		else if(databaseTypeName.equalsIgnoreCase("Oracle"))
		{
			//copyInputStream(new FileInputStream("lib/ojdbc14.jar"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + "server" + File.separator + "lib" + File.separator + "ojdbc14.jar")));
			
			//System.err.println("Copying file: " + "configTemplates/oracle_mapping.xml");
			//copyInputStream(new FileInputStream("configTemplates/oracle_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/classes/mapping.xml")));
			
			//System.err.println("Copying file: " + "configTemplates/oracle_mapping.xml");
			//copyInputStream(new FileInputStream("configTemplates/oracle_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/classes/oracle_mapping.xml")));
			
			//if(this.createDeliverPreview.equalsIgnoreCase("yes"))
			//	copyInputStream(new FileInputStream("configTemplates/oracle_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/classes/oracle_mapping.xml")));

			//if(this.createDeliverLive.equalsIgnoreCase("yes"))
			//	copyInputStream(new FileInputStream("configTemplates/oracle_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/classes/oracle_mapping.xml")));
		}
		else if(databaseTypeName.equalsIgnoreCase("DB2"))
		{
			//copyInputStream(new FileInputStream("lib/db2jcc.jar"), new BufferedOutputStream(new FileOutputStream(this.applicationServerHomePath + File.separator + "server" + File.separator + "lib" + File.separator + "db2jcc.jar")));
			
			//System.err.println("Copying file: " + "configTemplates/db2_mapping.xml");
			//copyInputStream(new FileInputStream("configTemplates/db2_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/classes/db2_mapping.xml")));
			
			//System.err.println("Copying file: " + "configTemplates/db2_mapping.xml");
			//copyInputStream(new FileInputStream("configTemplates/db2_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/classes/db2_mapping.xml")));
			
			//if(this.createDeliverPreview.equalsIgnoreCase("yes"))
			//	copyInputStream(new FileInputStream("configTemplates/db2_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/classes/db2_mapping.xml")));

			//if(this.createDeliverLive.equalsIgnoreCase("yes"))
			//	copyInputStream(new FileInputStream("configTemplates/db2_mapping.xml"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/classes/db2_mapping.xml")));
		}
		
		if(checkIfXMLLibsIsNeeded())
		{
		    if(this.createCMS.equalsIgnoreCase("yes"))
			{
				copyInputStream(new FileInputStream("lib/xercesImpl.jar"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "xercesImpl.jar")));
				copyInputStream(new FileInputStream("lib/xml-apis.jar"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "xml-apis.jar")));
			}
		    
		    if(this.createDeliverWorking.equalsIgnoreCase("yes"))
			{
				copyInputStream(new FileInputStream("lib/xercesImpl.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "xercesImpl.jar")));
				copyInputStream(new FileInputStream("lib/xml-apis.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "xml-apis.jar")));
			}
		    
			if(this.createDeliverPreview.equalsIgnoreCase("yes"))
			{
				copyInputStream(new FileInputStream("lib/xercesImpl.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "xercesImpl.jar")));
				copyInputStream(new FileInputStream("lib/xml-apis.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "xml-apis.jar")));
			}
			
			if(this.createDeliverLive.equalsIgnoreCase("yes"))
			{
				copyInputStream(new FileInputStream("lib/xercesImpl.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "xercesImpl.jar")));
				copyInputStream(new FileInputStream("lib/xml-apis.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "xml-apis.jar")));
			}
		}
		
		//Replace jstl and standard if tomcat 4.
		if(appServer.startsWith("Tomcat 4"))
		{
		    if(this.createCMS.equalsIgnoreCase("yes"))
			{
			    File existingStandardJar = new File(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "standard.jar");
			    if(existingStandardJar.exists())
				    existingStandardJar.delete();
				File existingJSTLJar = new File(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "jstl.jar");
				if(existingJSTLJar.exists())
				    existingJSTLJar.delete();
				
				copyInputStream(new FileInputStream("lib/standard-1.0.4.jar"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "standard-1.0.4.jar")));
				copyInputStream(new FileInputStream("lib/jstl-1.0.2.jar"), new BufferedOutputStream(new FileOutputStream(this.cmsTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "jstl-1.0.2.jar")));		    
			}
		    
		    if(this.createDeliverWorking.equalsIgnoreCase("yes"))
			{
			    File existingStandardJar = new File(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "standard.jar");
			    if(existingStandardJar.exists())
				    existingStandardJar.delete();
				File existingJSTLJar = new File(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "jstl.jar");
				if(existingJSTLJar.exists())
				    existingJSTLJar.delete();
				
				copyInputStream(new FileInputStream("lib/standard-1.0.4.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "standard-1.0.4.jar")));
				copyInputStream(new FileInputStream("lib/jstl-1.0.2.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverWorkingTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "jstl-1.0.2.jar")));		    
			}
		    
			if(this.createDeliverPreview.equalsIgnoreCase("yes"))
			{
			    File existingStandardJar = new File(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "standard.jar");
			    if(existingStandardJar.exists())
				    existingStandardJar.delete();
				File existingJSTLJar = new File(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "jstl.jar");
				if(existingJSTLJar.exists())
				    existingJSTLJar.delete();
				
				copyInputStream(new FileInputStream("lib/standard-1.0.4.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "standard-1.0.4.jar")));
				copyInputStream(new FileInputStream("lib/jstl-1.0.2.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverPreviewTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "jstl-1.0.2.jar")));		    
			}
			
			if(this.createDeliverLive.equalsIgnoreCase("yes"))
			{
			    File existingStandardJar = new File(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "standard.jar");
			    if(existingStandardJar.exists())
				    existingStandardJar.delete();
				File existingJSTLJar = new File(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "jstl.jar");
				if(existingJSTLJar.exists())
				    existingJSTLJar.delete();
				
			    copyInputStream(new FileInputStream("lib/standard-1.0.4.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "standard-1.0.4.jar")));
				copyInputStream(new FileInputStream("lib/jstl-1.0.2.jar"), new BufferedOutputStream(new FileOutputStream(this.deliverLiveTempFolderFile.getPath() + File.separator + "WEB-INF/lib" + File.separator + "jstl-1.0.2.jar")));		    
			}
		}
	
	}

	public void modifyAllOSCachePropertyFiles() throws Exception
	{
	    if(this.createCMS.equalsIgnoreCase("yes"))
	        modifyOSCachePropertyFile(this.cmsTempFolderFile.getPath());
	    
	    if(this.createDeliverWorking.equalsIgnoreCase("yes"))
	        modifyOSCachePropertyFile(this.deliverWorkingTempFolderFile.getPath());
	    
	    if(this.createDeliverPreview.equalsIgnoreCase("yes"))
		    modifyOSCachePropertyFile(this.deliverPreviewTempFolderFile.getPath());
		
	    if(this.createDeliverLive.equalsIgnoreCase("yes"))
		    modifyOSCachePropertyFile(this.deliverLiveTempFolderFile.getPath());
	}

	public String getPortletBase() 
	{
	    return this.applicationServerHomePath + File.separator + "server" + File.separator + "default" + File.separator + "deploy";
	}

}
