/* ===============================================================================
 *
 * Part of the InfoGlue Content Management Platform (www.infoglue.org)
 *
 * ===============================================================================
 *
 *  Copyright (C)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2, as published by the
 * Free Software Foundation. See the file LICENSE.html for more information.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
 * Place, Suite 330 / Boston, MA 02111-1307 / USA.
 *
 * ===============================================================================
 */

package org.infoglue.cmsinstaller;

import javax.swing.*;
import javax.swing.border.BevelBorder;

import java.awt.*;

/**
 * This is the main class for the installer.
 */

public class IntroductionDialog extends JPanel
{
	private InfoGlueInstaller infoglueInstaller = null;
	
	private final static String introductionHeader  = "Welcome to the installation of InfoGlue CMS";
	private final static String introductionMessage = "This wizard will take you through the different steps of setting up InfoGlue to work on your server.\n\nThis installer knows how to upgrade your current infoglue database from a previous version, if you have one, so your don't have to loose data.\nAs this process is a bit sensitive we very strongly recommend that you take a backup of the database before continuing in case something goes wrong and you need to fall back to the original.\n\nThe previous InfoGlue-directories/files will not be upgraded but instead new ones will be created so you can remove any old InfoGlue directories if you want. If you have files in the old directories you have modified or \nadded be sure to backup them before continuing.";
	 
	public IntroductionDialog(InfoGlueInstaller infoglueInstaller)
	{
		this.infoglueInstaller = infoglueInstaller;
		
		this.setSize(300, 300);
		this.setLayout(null);
		this.setBackground(Color.white);
		
		JLabel introductionLabel = new JLabel(introductionHeader);
		introductionLabel.setBounds(0, 0, 400, 30);
		introductionLabel.setFont(new java.awt.Font("Dialog", java.awt.Font.BOLD, 16));
				
		JTextArea textArea = new JTextArea(introductionMessage);
		textArea.setEditable(false);
		//textArea.setBackground(Color.lightGray);
		textArea.setBounds(0, 30, 400, 230);
		textArea.setWrapStyleWord(true);
		textArea.setLineWrap(true);

		JTextArea versionArea = new JTextArea("This version of InfoGlue requires Java 5 (1.5.x or similar). \nYour Java-version: " + System.getProperty("java.version") + "\n\nClick next to continue if you think you have the right version.");
		versionArea.setEditable(false);
		versionArea.setBounds(0, 270, 400, 100);
		versionArea.setForeground(Color.RED);
		versionArea.setFont(new java.awt.Font("Dialog", java.awt.Font.BOLD, 12));
		versionArea.setWrapStyleWord(true);
		versionArea.setLineWrap(true);

		this.add(introductionLabel);
		this.add(textArea);
		this.add(versionArea);
		
		infoglueInstaller.setNextButtonCommand("ShowDatabaseDialog");
	}
		
	public void paint(Graphics g) 
	{
	    Graphics2D g2 = (Graphics2D)g;
		g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

		super.paint(g);
	}
}