/* ===============================================================================
 *
 * Part of the InfoGlue Content Management Platform (www.infoglue.org)
 *
 * ===============================================================================
 *
 *  Copyright (C)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2, as published by the
 * Free Software Foundation. See the file LICENSE.html for more information.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
 * Place, Suite 330 / Boston, MA 02111-1307 / USA.
 *
 * ===============================================================================
 */

package org.infoglue.cmsinstaller;

import java.io.*;
import java.util.*;
import javax.swing.*;


/**
 * This is the main class for the installer. What the installer should do is as follows:
 * 
 * 1. Ask for the root-access to the database we should use and set up a new database.
 * 2. All tables and access rights should be set upp by the installer as well as a small example site.
 * 3. Unpack the webarchive into the correct forlder and set up the property-files as the user specifies them. 
 */

public class InfoGlueInstaller
{
    private DatabaseCommander commander = null;
	public InstallerSkeleton installerSkeleton = null;
	
	public static void main(String[] args)
	{
	    /*
	    try
        {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        */
		InfoGlueInstaller infoGlueInstaller = new InfoGlueInstaller();
		infoGlueInstaller.showInstallerSkeleton();
	}
		
	public InfoGlueInstaller()
	{	
	}

	public void showInstallerSkeleton()
	{
		installerSkeleton = new InstallerSkeleton(this);
		JFrame.setDefaultLookAndFeelDecorated(true);
		installerSkeleton.setIconImage(new ImageIcon("images/windowIcon.gif").getImage());
		installerSkeleton.setTitle("InfoGlue Content Management Platform");
		installerSkeleton.showIntroductionDialog();
		installerSkeleton.show();				
	}

	public void setBackButtonCommand(String command)
	{
		this.installerSkeleton.backButton.setActionCommand(command);
	}

	public void setNextButtonCommand(String command)
	{
		this.installerSkeleton.nextButton.setActionCommand(command);
	}
	
	public void setNextButtonLabel(String label)
	{
		this.installerSkeleton.nextButton.setLabel(label);
	}

	public void setupDatabaseEnvironment() throws Exception
	{			
		if(installerSkeleton.databaseDialog.getDatabaseTypeName().equalsIgnoreCase("MySQL"))
		{
			String url = "jdbc:mysql://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + "/mysql";
			commander = new MySQLDatabaseCommander(installerSkeleton.databaseDialog.getDatabaseDriverName(), installerSkeleton.databaseDialog.getDatabaseServer(), installerSkeleton.databaseDialog.getDatabasePort(), installerSkeleton.databaseDialog.getDatabaseInstance(), url, installerSkeleton.databaseDialog.getDatabaseUser(), installerSkeleton.databaseDialog.getDatabasePassword(), installerSkeleton.databaseDialog.getInfoGlueUserName(), installerSkeleton.databaseDialog.getInfoGluePassword(), installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.serverDialog.getHostName(), installerSkeleton.databaseDialog.getCreateDatabase(), installerSkeleton.databaseDialog.getCreateInitialData(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples());
		}
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equalsIgnoreCase("SQL Server"))
		{
			//String url = "jdbc:microsoft:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":1433";
			//String url = "jdbc:jtds:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + "";
			String url = "jdbc:jtds:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + ((installerSkeleton.databaseDialog.getDatabaseInstance().equalsIgnoreCase("") ? "" : ";INSTANCE=" + installerSkeleton.databaseDialog.getDatabaseInstance()));
			commander = new SQLServerDatabaseCommander(installerSkeleton.databaseDialog.getDatabaseDriverName(), installerSkeleton.databaseDialog.getDatabaseServer(), installerSkeleton.databaseDialog.getDatabasePort(), installerSkeleton.databaseDialog.getDatabaseInstance(), url, installerSkeleton.databaseDialog.getDatabaseUser(), installerSkeleton.databaseDialog.getDatabasePassword(), installerSkeleton.databaseDialog.getInfoGlueUserName(), installerSkeleton.databaseDialog.getInfoGluePassword(), installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.serverDialog.getHostName(), installerSkeleton.databaseDialog.getCreateDatabase(), installerSkeleton.databaseDialog.getCreateInitialData(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples());
		}
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equalsIgnoreCase("Oracle"))
		{
			String url = "jdbc:oracle:thin:" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + ":" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix();
			commander = new OracleDatabaseCommander(installerSkeleton.databaseDialog.getDatabaseDriverName(), installerSkeleton.databaseDialog.getDatabaseServer(), installerSkeleton.databaseDialog.getDatabasePort(), installerSkeleton.databaseDialog.getDatabaseInstance(), url, installerSkeleton.databaseDialog.getDatabaseUser(), installerSkeleton.databaseDialog.getDatabasePassword(), installerSkeleton.databaseDialog.getInfoGlueUserName(), installerSkeleton.databaseDialog.getInfoGluePassword(), installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.serverDialog.getHostName(), installerSkeleton.databaseDialog.getCreateDatabase(), installerSkeleton.databaseDialog.getCreateInitialData(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples());
		}
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equalsIgnoreCase("DB2"))
		{
			String url = "jdbc:db2://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + "/" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix();
			commander = new DB2DatabaseCommander(installerSkeleton.databaseDialog.getDatabaseDriverName(), installerSkeleton.databaseDialog.getDatabaseServer(), installerSkeleton.databaseDialog.getDatabasePort(), installerSkeleton.databaseDialog.getDatabaseInstance(), url, installerSkeleton.databaseDialog.getDatabaseUser(), installerSkeleton.databaseDialog.getDatabasePassword(), installerSkeleton.databaseDialog.getInfoGlueUserName(), installerSkeleton.databaseDialog.getInfoGluePassword(), installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.serverDialog.getHostName(), installerSkeleton.databaseDialog.getCreateDatabase(), installerSkeleton.databaseDialog.getCreateInitialData(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples());
		}

		commander.createCastorRootFile();
		commander.createOSPropertiesRootFile();
		
		if(installerSkeleton.databaseDialog.getCreateDatabase() || installerSkeleton.databaseDialog.getCreateInitialData())
		{
			commander.setupDatabase();
		}
		else
		{
			String databaseServer 	= installerSkeleton.databaseDialog.getDatabaseServer();
			String databasePort 	= installerSkeleton.databaseDialog.getDatabasePort();
			String databaseName		= installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix();
			String userName 		= installerSkeleton.databaseDialog.getInfoGlueUserName(); //"infoglue" + installerSkeleton.databaseDialog.getDbSuffix();
			String password 		= installerSkeleton.databaseDialog.getInfoGluePassword();
			//new UpgradeManager(installerSkeleton.databaseDialog.getUpgradeDatabaseEncoding(), "ISO-8859-1").upgradeTo1_3(commander, databaseServer, databasePort, databaseName, userName, password);
			//new UpgradeManager(installerSkeleton.databaseDialog.getUpgradeDatabaseEncoding(), "ISO-8859-1").upgradeToCurrentVersion() .upgradeTo1_3_2(commander, databaseServer, databasePort, databaseName, userName, password);
			new UpgradeManager(installerSkeleton.databaseDialog.getUpgradeDatabaseEncoding(), "ISO-8859-1").upgradeToCurrentVersion(commander, databaseServer, databasePort, databaseName, userName, password);
		}
		
		commander.createCastorFile();
		//commander.createOSWorkflowFile();
		commander.createOSPropertiesFile();
	}


	public void checkDatabase() throws Exception
	{
		if(installerSkeleton.databaseDialog.getInfoGluePassword() == null || installerSkeleton.databaseDialog.getInfoGluePassword().length() == 0)
			throw new Exception("You must supply the InfoGlue password.");
			
		DatabaseCommander commander = null;
		if(installerSkeleton.databaseDialog.getDatabaseTypeName().equalsIgnoreCase("MySQL"))
		{
			String url = "jdbc:mysql://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + "/mysql";
			commander = new MySQLDatabaseCommander(installerSkeleton.databaseDialog.getDatabaseDriverName(), installerSkeleton.databaseDialog.getDatabaseServer(), installerSkeleton.databaseDialog.getDatabasePort(), installerSkeleton.databaseDialog.getDatabaseInstance(), url, installerSkeleton.databaseDialog.getDatabaseUser(), installerSkeleton.databaseDialog.getDatabasePassword(), installerSkeleton.databaseDialog.getInfoGlueUserName(), installerSkeleton.databaseDialog.getInfoGluePassword(), installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.databaseDialog.getDbSuffix(), null, installerSkeleton.databaseDialog.getCreateDatabase(), installerSkeleton.databaseDialog.getCreateInitialData(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples());
		}
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equalsIgnoreCase("SQL Server"))
		{
			//String url = "jdbc:microsoft:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":1433";
			//String url = "jdbc:jtds:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + "";
			String url = "jdbc:jtds:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + ((installerSkeleton.databaseDialog.getDatabaseInstance().equalsIgnoreCase("")) ? "" : ";INSTANCE=" + installerSkeleton.databaseDialog.getDatabaseInstance());
			commander = new SQLServerDatabaseCommander(installerSkeleton.databaseDialog.getDatabaseDriverName(), installerSkeleton.databaseDialog.getDatabaseServer(), installerSkeleton.databaseDialog.getDatabasePort(), installerSkeleton.databaseDialog.getDatabaseInstance(), url, installerSkeleton.databaseDialog.getDatabaseUser(), installerSkeleton.databaseDialog.getDatabasePassword(), installerSkeleton.databaseDialog.getInfoGlueUserName(), installerSkeleton.databaseDialog.getInfoGluePassword(), installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.databaseDialog.getDbSuffix(), null, installerSkeleton.databaseDialog.getCreateDatabase(), installerSkeleton.databaseDialog.getCreateInitialData(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples());
		}
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equalsIgnoreCase("Oracle"))
		{
			String url = "jdbc:oracle:thin:@" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + ":" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix();
			commander = new OracleDatabaseCommander(installerSkeleton.databaseDialog.getDatabaseDriverName(), installerSkeleton.databaseDialog.getDatabaseServer(), installerSkeleton.databaseDialog.getDatabasePort(), installerSkeleton.databaseDialog.getDatabaseInstance(), url, installerSkeleton.databaseDialog.getDatabaseUser(), installerSkeleton.databaseDialog.getDatabasePassword(), installerSkeleton.databaseDialog.getInfoGlueUserName(), installerSkeleton.databaseDialog.getInfoGluePassword(), installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.databaseDialog.getDbSuffix(), null, installerSkeleton.databaseDialog.getCreateDatabase(), installerSkeleton.databaseDialog.getCreateInitialData(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples());
		}
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equalsIgnoreCase("DB2"))
		{
			String url = "jdbc:db2://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + "/" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix();
			commander = new DB2DatabaseCommander(installerSkeleton.databaseDialog.getDatabaseDriverName(), installerSkeleton.databaseDialog.getDatabaseServer(), installerSkeleton.databaseDialog.getDatabasePort(), installerSkeleton.databaseDialog.getDatabaseInstance(), url, installerSkeleton.databaseDialog.getDatabaseUser(), installerSkeleton.databaseDialog.getDatabasePassword(), installerSkeleton.databaseDialog.getInfoGlueUserName(), installerSkeleton.databaseDialog.getInfoGluePassword(), installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.databaseDialog.getDbSuffix(), null, installerSkeleton.databaseDialog.getCreateDatabase(), installerSkeleton.databaseDialog.getCreateInitialData(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples(), installerSkeleton.databaseDialog.getCreateExamples());
		}

		
		if(installerSkeleton.databaseDialog.getCreateDatabase() || installerSkeleton.databaseDialog.getCreateInitialData())
		{
			commander.testSetupDummyDatabase();
		}
		else
		{
			commander.testConnectDatabase();
		}
		
	}

	
	public void setupPropertyFiles(InstallationCommander installationCommander) throws Exception
	{
		String url = "";
		if(installerSkeleton.databaseDialog.getDatabaseTypeName().equals("MySQL"))
		{
		    MySQLDatabaseCommander mySQLDatabaseCommander = (MySQLDatabaseCommander)commander;
		    if(mySQLDatabaseCommander.getMysqlVersion().indexOf("4.1") > -1 && mySQLDatabaseCommander.getCharset() != null)
		        url = "jdbc:mysql://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + "/" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix() + "?autoReconnect=true";
	        else
		        url = "jdbc:mysql://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + "/" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix() + "?autoReconnect=true&amp;useUnicode=true&amp;characterEncoding=UTF-8";
		}
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equals("SQL Server"))
		{
			url = "jdbc:jtds:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + ((installerSkeleton.databaseDialog.getDatabaseInstance().equalsIgnoreCase("")) ? ";DatabaseName=" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix() + ";SelectMethod=Cursor" : ";INSTANCE=" + installerSkeleton.databaseDialog.getDatabaseInstance() + ";DatabaseName=" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix() + ";SelectMethod=Cursor");
			//url = "jdbc:jtds:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + ";DatabaseName=" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix() + ";SelectMethod=Cursor";
			//url = "jdbc:microsoft:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":1433;DatabaseName=" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix() + ";SelectMethod=Cursor";
		}
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equals("Oracle"))
			url = "jdbc:oracle:thin:@" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + ":" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix();
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equals("DB2"))
			url = "jdbc:db2://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + "/" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix();
		
		String comment = "#";
		String installPreview = installerSkeleton.serverDialog.getCreateDeliverPreview();
		if(installPreview.equalsIgnoreCase("yes"))
			comment = "";
			
		ConfigurationFileCommander commander = new ConfigurationFileCommander(installerSkeleton.serverDialog.getHostName(), installerSkeleton.serverDialog.getApplicationServerHomePath(), installerSkeleton.serverDialog.getSmtpHostName(), installerSkeleton.serverDialog.getPortNumber(), installerSkeleton.serverDialog.getApplicationSuffix(), installerSkeleton.serverDialog.getApplicationPath(), comment, installerSkeleton.serverDialog.getSuperUserName(), installerSkeleton.serverDialog.getSuperUserPassword(), installerSkeleton.serverDialog.getActionDispatcher(), installerSkeleton.serverDialog.getEnablePortal(), installerSkeleton.databaseDialog.getDatabaseDriverName(), url, installerSkeleton.databaseDialog.getInfoGlueUserName(), installerSkeleton.databaseDialog.getInfoGluePassword(), installerSkeleton.databaseDialog.getDatabaseDialectName(), installerSkeleton.databaseDialog.getDatabaseTypeName());
		commander.createCMSPropertyFile();
		commander.createDeliverWorkingPropertyFile(installationCommander);
		commander.createDeliverPreviewPropertyFile(installationCommander);
		commander.createDeliverLivePropertyFile(installationCommander);
		commander.createCMSWebappFile();
		commander.createDeliverWebappFile();
		commander.createHibernateConfigFile();
		TomcatConfigFilesUpdater tomcatConfigFilesUpdater = new TomcatConfigFilesUpdater();
		tomcatConfigFilesUpdater.setAppDir(installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueCMS" + installerSkeleton.serverDialog.getApplicationSuffix());
		tomcatConfigFilesUpdater.setAppName("infoglueCMS" + installerSkeleton.serverDialog.getApplicationSuffix());
		tomcatConfigFilesUpdater.setDriverName(installerSkeleton.databaseDialog.getDatabaseDriverName());
		tomcatConfigFilesUpdater.setConnUrl(url);
		tomcatConfigFilesUpdater.setLogDir(installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueCMS" + installerSkeleton.serverDialog.getApplicationSuffix() + File.separator + "logs");
		tomcatConfigFilesUpdater.setPath(installerSkeleton.serverDialog.getApplicationServerHomePath() + File.separator + "conf");
		tomcatConfigFilesUpdater.setUsrName(installerSkeleton.databaseDialog.getInfoGlueUserName());
		tomcatConfigFilesUpdater.setUsrPass(installerSkeleton.databaseDialog.getInfoGluePassword());
		tomcatConfigFilesUpdater.updateConfiguration();
		
		tomcatConfigFilesUpdater.updateConfiguration("infoglueDeliverWorking" + installerSkeleton.serverDialog.getApplicationSuffix(), installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueDeliverWorking" + installerSkeleton.serverDialog.getApplicationSuffix(), installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueDeliverWorking" + installerSkeleton.serverDialog.getApplicationSuffix() + File.separator + "logs");
		tomcatConfigFilesUpdater.updateConfiguration("infoglueDeliverPreview" + installerSkeleton.serverDialog.getApplicationSuffix(), installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueDeliverPreview" + installerSkeleton.serverDialog.getApplicationSuffix(), installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueDeliverPreview" + installerSkeleton.serverDialog.getApplicationSuffix() + File.separator + "logs");
		tomcatConfigFilesUpdater.updateConfiguration("infoglueDeliverLive" + installerSkeleton.serverDialog.getApplicationSuffix(), installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueDeliverLive" + installerSkeleton.serverDialog.getApplicationSuffix(), installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueDeliverLive" + installerSkeleton.serverDialog.getApplicationSuffix() + File.separator + "logs");
	}
	
	public void finishInstallation() throws Exception
	{
		installerSkeleton.installingDialog.getTextArea().append("Setting up database properties.......");
		this.setupDatabaseEnvironment();
		installerSkeleton.installingDialog.getTextArea().append("Done.\n");

		installerSkeleton.installingDialog.getTextArea().append("Setting up system properties.......");
		InstallationCommander commander = InstallationCommander.getInstallationCommander(installerSkeleton.serverDialog.getApplicationServer(), installerSkeleton.serverDialog.getApplicationPath(), installerSkeleton.serverDialog.getApplicationSuffix(), installerSkeleton.serverDialog.getApplicationServerHomePath(), installerSkeleton.serverDialog.getCreateCMS(), installerSkeleton.serverDialog.getCreateDeliverWorking(), installerSkeleton.serverDialog.getCreateDeliverPreview(), installerSkeleton.serverDialog.getCreateDeliverLive(), getTomcatContextPath());
		this.setupPropertyFiles(commander);
		installerSkeleton.installingDialog.getTextArea().append("Done.\n");
		
		installerSkeleton.installingDialog.getTextArea().append("Installing InfoGlue applications.......");

		commander.installFiles(installerSkeleton.databaseDialog.getDatabaseTypeName());

		installerSkeleton.installingDialog.getTextArea().append("Done.\n");

		Uninstaller uninstaller = new Uninstaller();
		ArrayList dirs = new ArrayList();
		dirs.add(installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueCMS" + installerSkeleton.serverDialog.getApplicationSuffix());
		dirs.add(installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueDeliverWorking" + installerSkeleton.serverDialog.getApplicationSuffix());
		dirs.add(installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueDeliverPreview" + installerSkeleton.serverDialog.getApplicationSuffix());
		dirs.add(installerSkeleton.serverDialog.getApplicationPath() + File.separator + "infoglueDeliverLive" + installerSkeleton.serverDialog.getApplicationSuffix());
		
		String url = "";
		if(installerSkeleton.databaseDialog.getDatabaseTypeName().equals("MySQL"))
			url = "jdbc:mysql://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + "/" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix();
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equals("SQL Server"))
		{
			url = "jdbc:jtds:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + ((installerSkeleton.databaseDialog.getDatabaseInstance().equalsIgnoreCase("")) ? "" : ";INSTANCE=" + installerSkeleton.databaseDialog.getDatabaseInstance() + ";DatabaseName=" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix() + ";SelectMethod=Cursor");
			//url = "jdbc:jtds:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + ";DatabaseName=" + installerSkeleton.databaseDialog.getDatabaseName()  + installerSkeleton.databaseDialog.getDbSuffix() + ";SelectMethod=Cursor";
			//url = "jdbc:microsoft:sqlserver://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":1433;DatabaseName=" + installerSkeleton.databaseDialog.getDatabaseName()  + installerSkeleton.databaseDialog.getDbSuffix() + ";SelectMethod=Cursor";
		}
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equals("Oracle"))
			url = "jdbc:oracle:thin:@" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + ":" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix();
		else if(installerSkeleton.databaseDialog.getDatabaseTypeName().equals("DB2"))
			url = "jdbc:db2://" + installerSkeleton.databaseDialog.getDatabaseServer() + ":" + installerSkeleton.databaseDialog.getDatabasePort() + "/" + installerSkeleton.databaseDialog.getDatabaseName() + installerSkeleton.databaseDialog.getDbSuffix();

		//uninstaller.createStartMenuItems(dirs, url, installerSkeleton.databaseDialog.getDatabaseServer(), installerSkeleton.databaseDialog.getDatabaseDriverName(), installerSkeleton.serverDialog.getTomcatHomePath() + File.separator + "conf", "infoglue" + installerSkeleton.databaseDialog.getDbSuffix(), installerSkeleton.serverDialog.getHostName());		
	}
	
	
	/**
	 * This method gets the path where to store the context files.
	 */

	public String getTomcatContextPath()
	{
		String tomcatContextPath = "webapps";
		
		if(installerSkeleton.serverDialog.getApplicationServer().equals("Tomcat 5.x") ||
				installerSkeleton.serverDialog.getApplicationServer().equals("Tomcat 6.x"))
			tomcatContextPath = "conf" + File.separator + "Catalina" + File.separator + "localhost";
		
		return tomcatContextPath;		
	}
	
	public void logProgress(String message)
	{
		try
		{
			PrintWriter pw = new PrintWriter(new FileOutputStream("install.log"));
			pw.println("" + message);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
}