/* ===============================================================================
 *
 * Part of the InfoGlue Content Management Platform (www.infoglue.org)
 *
 * ===============================================================================
 *
 *  Copyright (C)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2, as published by the
 * Free Software Foundation. See the file LICENSE.html for more information.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
 * Place, Suite 330 / Boston, MA 02111-1307 / USA.
 *
 * ===============================================================================
 */

package org.infoglue.cmsinstaller;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * This is the main class for the installer.
 */

public class HelpButton extends JButton implements MouseListener
{
	private JLabel label = null;
	
	public HelpButton(JLabel label)
	{	
		super(new ImageIcon("images/help.gif"));
		this.setSize(20, 20);
		this.setBackground(Color.white);
		this.setBorder(null);
		this.setVerticalTextPosition(SwingConstants.CENTER);
		this.setHorizontalTextPosition(SwingConstants.CENTER);
   		//this.setLayout(null);
		this.setToolTipText(label.getToolTipText());
		this.addMouseListener(this);
	}
	
	
	public void mouseClicked(MouseEvent e)
	{
		ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
		toolTipManager.setInitialDelay(50);
		Component c = (Component)e.getSource();
		c.dispatchEvent( new KeyEvent (c, KeyEvent.KEY_PRESSED, 0, KeyEvent.CTRL_MASK, KeyEvent.VK_F1) );
		toolTipManager.setInitialDelay(500);
	} 

	public void mouseEntered(MouseEvent e){}; 
	public void mouseExited(MouseEvent e){}; 
	public void mousePressed(MouseEvent e){}; 
	public void mouseReleased(MouseEvent e){}; 

}