/* ===============================================================================
 *
 * Part of the InfoGlue Content Management Platform (www.infoglue.org)
 *
 * ===============================================================================
 *
 *  Copyright (C)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2, as published by the
 * Free Software Foundation. See the file LICENSE.html for more information.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
 * Place, Suite 330 / Boston, MA 02111-1307 / USA.
 *
 * ===============================================================================
 */

package org.infoglue.cmsinstaller;
import java.io.*;
import java.net.InetAddress;

public class ConfigurationFileCommander
{
	private String hostName				= null;
	private String portNumber			= null;
	private String tomcatPath			= null;
	private String smtpHostName			= null;
	private String nameSuffix			= null;
	private String applicationPath		= null;
	private String installPreview  		= null;
	private String superUserName		= null; 
	private String superUserPassword	= null;
	private String actionDispatcher		= null;
	private String enablePortal			= null;
	private String jdbcDriver			= null;
	private String connectionUrl 		= null;
	private String userName 			= null;
	private String password				= null;
	private String databaseDialectClass = null;
	private String databaseTypeName 	= null;
	
	public ConfigurationFileCommander(String hostName, String tomcatPath, String smtpHostName, String portNumber, String nameSuffix, String applicationPath, String installPreview, String superUserName, String superUserPassword, String actionDispatcher, String enablePortal, String jdbcDriver, String connectionUrl, String userName, String password, String databaseDialectClass, String databaseTypeName)
	{
		this.hostName 			= hostName;
		this.tomcatPath 		= tomcatPath;
		this.smtpHostName		= smtpHostName;
		this.portNumber			= portNumber;
		this.nameSuffix 		= nameSuffix;
		this.applicationPath	= applicationPath;
		this.installPreview     = installPreview;
		this.superUserName 		= superUserName;
		this.superUserPassword 	= superUserPassword;
		this.actionDispatcher 	= actionDispatcher;
		this.enablePortal		= enablePortal;
		this.jdbcDriver 		= jdbcDriver;
		this.connectionUrl		= connectionUrl;
		this.userName			= userName;
		this.password			= password;
		this.databaseDialectClass = databaseDialectClass;
		this.databaseTypeName 	= databaseTypeName;
	}
	
	public void createCMSPropertyFile() throws Exception
	{
		FileInputStream fis = new FileInputStream("configTemplates/cms.properties");
		String result = "";
		StringBuffer sb = new StringBuffer();
		
		int c;
		while((c = fis.read()) != -1)
		{
			sb.append((char)c);
		}
		result = sb.toString();
		
		applicationPath = applicationPath.replace('\\', '/');
		
		String webServerAddress = (this.hostName != null && !this.hostName.equals("") ? "http://" + this.hostName + (this.portNumber != null && !this.portNumber.equals("") ? ":" + this.portNumber : "") : "");
		String serverWebServerAddress = webServerAddress;
		if(!serverWebServerAddress.startsWith("http"))
			serverWebServerAddress = "http://" + getHostAddress() + (this.portNumber != null && !this.portNumber.equals("") ? ":" + this.portNumber : "") + webServerAddress;
		System.out.println("webServerAddress:" + webServerAddress);
		System.out.println("serverWebServerAddress:" + serverWebServerAddress);
			
		result = result.replaceAll("\\{hostName\\}", this.hostName);
		result = result.replaceAll("\\{portNumber\\}", this.portNumber);
		result = result.replaceAll("\\{applicationPath\\}", applicationPath);
		result = result.replaceAll("\\{applicationName\\}", "infoglueCMS" + this.nameSuffix);
		result = result.replaceAll("\\{applicationSuffix\\}", this.nameSuffix);
		result = result.replaceAll("\\{mailServer\\}", this.smtpHostName);
		result = result.replaceAll("\\{mail.contentType\\}", "text/html");
		result = result.replaceAll("\\{installPreview\\}", this.installPreview);
		result = result.replaceAll("\\{superUserName\\}", this.superUserName);
		result = result.replaceAll("\\{superUserPassword\\}", this.superUserPassword);
		result = result.replaceAll("\\@edition.pageSize\\@", "10");
		result = result.replaceAll("@edition.pageSize@", "10");
		result = result.replaceAll("\\{databaseEngine\\}", this.databaseTypeName);
		result = result.replaceAll("\\{useShortTableNames\\}", (this.databaseTypeName.equalsIgnoreCase("mysql") || this.databaseTypeName.equalsIgnoreCase("sqlserver") ? "false" : "true"));
		result = result.replaceAll("\\{webServerAddress\\}", webServerAddress);
		result = result.replaceAll("\\{serverWebServerAddress\\}", serverWebServerAddress);
		
		PrintWriter pw = new PrintWriter(new FileOutputStream("localConfigs/cms.properties"));
		pw.println(result);
		pw.close();
	}

	public void createDeliverWorkingPropertyFile(InstallationCommander installationCommander) throws Exception
	{
		FileInputStream fis = new FileInputStream("configTemplates/deliver.properties");
		String result = "";
		StringBuffer sb = new StringBuffer();
		
		int c;
		while((c = fis.read()) != -1)
		{
			sb.append((char)c);
		}
		result = sb.toString();
		
		applicationPath = applicationPath.replace('\\', '/');
		this.tomcatPath = tomcatPath.replace('\\', '/');
		String portletBase = installationCommander.getPortletBase().replace('\\', '/');
		
		String webServerAddress = (this.hostName != null && !this.hostName.equals("") ? "http://" + this.hostName + (this.portNumber != null && !this.portNumber.equals("") ? ":" + this.portNumber : "") : "");
		String serverWebServerAddress = webServerAddress;
		if(!serverWebServerAddress.startsWith("http"))
			serverWebServerAddress = "http://" + getHostAddress() + (this.portNumber != null && !this.portNumber.equals("") ? ":" + this.portNumber : "") + webServerAddress;
		System.out.println("webServerAddress:" + webServerAddress);
		System.out.println("serverWebServerAddress:" + serverWebServerAddress);
				
		result = result.replaceAll("\\{hostName\\}", this.hostName);
		result = result.replaceAll("\\{portNumber\\}", this.portNumber);
		result = result.replaceAll("\\{applicationPath\\}", applicationPath);
		result = result.replaceAll("\\{applicationName\\}", "infoglueDeliverWorking" + this.nameSuffix);
		result = result.replaceAll("\\{mailServer\\}", this.smtpHostName);
		result = result.replaceAll("\\{operatingMode\\}", "0");
		result = result.replaceAll("\\{cmsApplicationName\\}", "infoglueCMS" + this.nameSuffix);
		result = result.replaceAll("\\{enableEditOnSight\\}", "true");
		result = result.replaceAll("\\{applicationSuffix\\}", this.nameSuffix);
		result = result.replaceAll("\\{enablePortal\\}", this.enablePortal);
		result = result.replaceAll("\\{portletBase\\}", portletBase);
		result = result.replaceAll("\\{niceURIEncoding\\}", "UTF-8");
		result = result.replaceAll("\\{databaseEngine\\}", this.databaseTypeName);
		result = result.replaceAll("\\{useShortTableNames\\}", (this.databaseTypeName.equalsIgnoreCase("mysql") || this.databaseTypeName.equalsIgnoreCase("sqlserver") ? "false" : "true"));
		result = result.replaceAll("\\{webServerAddress\\}", webServerAddress);
		result = result.replaceAll("\\{serverWebServerAddress\\}", serverWebServerAddress);

		PrintWriter pw = new PrintWriter(new FileOutputStream("localConfigs/deliverWorking.properties"));
		pw.println(result);
		pw.close();

	}
	
	public void createDeliverPreviewPropertyFile(InstallationCommander installationCommander) throws Exception
	{
		FileInputStream fis = new FileInputStream("configTemplates/deliver.properties");
		String result = "";
		StringBuffer sb = new StringBuffer();
		
		int c;
		while((c = fis.read()) != -1)
		{
			sb.append((char)c);
		}
		result = sb.toString();
		
		applicationPath = applicationPath.replace('\\', '/');
		this.tomcatPath = tomcatPath.replace('\\', '/');
		String portletBase = installationCommander.getPortletBase().replace('\\', '/');

		String webServerAddress = (this.hostName != null && !this.hostName.equals("") ? "http://" + this.hostName + (this.portNumber != null && !this.portNumber.equals("") ? ":" + this.portNumber : "") : "");
		String serverWebServerAddress = webServerAddress;
		if(!serverWebServerAddress.startsWith("http"))
			serverWebServerAddress = "http://" + getHostAddress() + (this.portNumber != null && !this.portNumber.equals("") ? ":" + this.portNumber : "") + webServerAddress;
		System.out.println("webServerAddress:" + webServerAddress);
		System.out.println("serverWebServerAddress:" + serverWebServerAddress);
		
		result = result.replaceAll("\\{hostName\\}", this.hostName);
		result = result.replaceAll("\\{portNumber\\}", this.portNumber);
		result = result.replaceAll("\\{applicationPath\\}", applicationPath);
		result = result.replaceAll("\\{applicationName\\}", "infoglueDeliverPreview" + this.nameSuffix);
		result = result.replaceAll("\\{mailServer\\}", this.smtpHostName);
		result = result.replaceAll("\\{operatingMode\\}", "2");
		result = result.replaceAll("\\{cmsApplicationName\\}", "infoglueCMS" + this.nameSuffix);
		result = result.replaceAll("\\{enableEditOnSight\\}", "false");
		result = result.replaceAll("\\{applicationSuffix\\}", this.nameSuffix);
		result = result.replaceAll("\\{enablePortal\\}", this.enablePortal);
		result = result.replaceAll("\\{portletBase\\}", portletBase);
		result = result.replaceAll("\\{niceURIEncoding\\}", "UTF-8");
		result = result.replaceAll("\\{databaseEngine\\}", this.databaseTypeName);
		result = result.replaceAll("\\{useShortTableNames\\}", (this.databaseTypeName.equalsIgnoreCase("mysql") || this.databaseTypeName.equalsIgnoreCase("sqlserver") ? "false" : "true"));
		result = result.replaceAll("\\{webServerAddress\\}", webServerAddress);
		result = result.replaceAll("\\{serverWebServerAddress\\}", serverWebServerAddress);

		PrintWriter pw = new PrintWriter(new FileOutputStream("localConfigs/deliverPreview.properties"));
		pw.println(result);
		pw.close();

	}

	public void createDeliverLivePropertyFile(InstallationCommander installationCommander) throws Exception
	{
		FileInputStream fis = new FileInputStream("configTemplates/deliver.properties");
		String result = "";
		StringBuffer sb = new StringBuffer();
		
		int c;
		while((c = fis.read()) != -1)
		{
			sb.append((char)c);
		}
		result = sb.toString();
		
		applicationPath = applicationPath.replace('\\', '/');
		this.tomcatPath = tomcatPath.replace('\\', '/');
		String portletBase = installationCommander.getPortletBase().replace('\\', '/');

		String webServerAddress = (this.hostName != null && !this.hostName.equals("") ? "http://" + this.hostName + (this.portNumber != null && !this.portNumber.equals("") ? ":" + this.portNumber : "") : "");
		String serverWebServerAddress = webServerAddress;
		if(!serverWebServerAddress.startsWith("http"))
			serverWebServerAddress = "http://" + getHostAddress() + (this.portNumber != null && !this.portNumber.equals("") ? ":" + this.portNumber : "") + webServerAddress;
		System.out.println("webServerAddress:" + webServerAddress);
		System.out.println("serverWebServerAddress:" + serverWebServerAddress);
		
		result = result.replaceAll("\\{hostName\\}", this.hostName);
		result = result.replaceAll("\\{portNumber\\}", this.portNumber);
		result = result.replaceAll("\\{applicationPath\\}", applicationPath);
		result = result.replaceAll("\\{applicationName\\}", "infoglueDeliverLive" + this.nameSuffix);
		result = result.replaceAll("\\{mailServer\\}", this.smtpHostName);
		result = result.replaceAll("\\{operatingMode\\}", "3");
		result = result.replaceAll("\\{cmsApplicationName\\}", "infoglueCMS" + this.nameSuffix);
		result = result.replaceAll("\\{enableEditOnSight\\}", "false");
		result = result.replaceAll("\\{applicationSuffix\\}", this.nameSuffix);
		result = result.replaceAll("\\{enablePortal\\}", this.enablePortal);
		result = result.replaceAll("\\{portletBase\\}", portletBase);
		result = result.replaceAll("\\{niceURIEncoding\\}", "UTF-8");
		result = result.replaceAll("\\{databaseEngine\\}", this.databaseTypeName);
		result = result.replaceAll("\\{useShortTableNames\\}", (this.databaseTypeName.equalsIgnoreCase("mysql") || this.databaseTypeName.equalsIgnoreCase("sqlserver") ? "false" : "true"));
		result = result.replaceAll("\\{webServerAddress\\}", webServerAddress);
		result = result.replaceAll("\\{serverWebServerAddress\\}", serverWebServerAddress);

		PrintWriter pw = new PrintWriter(new FileOutputStream("localConfigs/deliverLive.properties"));
		pw.println(result);
		pw.close();

	}
	
	
	public void createCMSWebappFile() throws Exception
	{
		FileInputStream fis = new FileInputStream("configTemplates/cms-web.xml");
		String result = "";
		StringBuffer sb = new StringBuffer();
		
		int c;
		while((c = fis.read()) != -1)
		{
			sb.append((char)c);
		}
		result = sb.toString();
		
		applicationPath = applicationPath.replace('\\', '/');
		
		result = result.replaceAll("\\@actionDispatcher\\@", this.actionDispatcher);
		result = result.replaceAll("@actionDispatcher@", this.actionDispatcher);
		
		PrintWriter pw = new PrintWriter(new FileOutputStream("localConfigs/cms-web.xml"));
		pw.println(result);
		pw.close();
	}

	public void createDeliverWebappFile() throws Exception
	{
		FileInputStream fis = new FileInputStream("configTemplates/deliver-web.xml");
		String result = "";
		StringBuffer sb = new StringBuffer();
		
		int c;
		while((c = fis.read()) != -1)
		{
			sb.append((char)c);
		}
		result = sb.toString();
		
		applicationPath = applicationPath.replace('\\', '/');

		result = result.replaceAll("\\@actionDispatcher\\@", this.actionDispatcher);
		result = result.replaceAll("@actionDispatcher@", this.actionDispatcher);
		
		PrintWriter pw = new PrintWriter(new FileOutputStream("localConfigs/deliver-web.xml"));
		pw.println(result);
		pw.close();

	}

	public void createHibernateConfigFile() throws Exception
	{
		FileInputStream fis = new FileInputStream("configTemplates/hibernate.cfg.xml");
		String result = "";
		StringBuffer sb = new StringBuffer();
		
		int c;
		while((c = fis.read()) != -1)
		{
			sb.append((char)c);
		}
		result = sb.toString();
		
		applicationPath = applicationPath.replace('\\', '/');

		result = result.replaceAll("\\{jdbcDriver\\}", this.jdbcDriver);
        result = result.replaceAll("\\{connectionUrl\\}", this.connectionUrl);	        
	    
	    result = result.replaceAll("\\{userName\\}", this.userName);
		result = result.replaceAll("\\{password\\}", this.password);
		result = result.replaceAll("\\{databaseDialectClass\\}", this.databaseDialectClass);
		
		PrintWriter pw = new PrintWriter(new FileOutputStream("localConfigs/hibernate.cfg.xml"));
		pw.println(result);
		pw.close();

	}

	public String getHostAddress()
    {
    	String address = null;
    	
    	try
    	{
    		address = java.net.InetAddress.getLocalHost().getHostAddress();
    	}
    	catch(Exception e)
    	{
    		e.printStackTrace();
    	}
    	
    	return address;
    }


	public static void main(String[] args) throws Exception
	{
		System.out.println("Testing...");
		
		FileInputStream fis = new FileInputStream("configTemplates/deliver.properties");
		String result = "";
		StringBuffer sb = new StringBuffer();
		
		int c;
		while((c = fis.read()) != -1)
		{
			sb.append((char)c);
		}
		result = sb.toString();
		
		String applicationPath = "c:/Program/jboss-4.0.4.GA/server/default/deploy";
		String applicationServerHomePath = "c:/Program/jboss-4.0.4.GA";
		
		applicationPath = applicationPath.replace('\\', '/');
		applicationServerHomePath = applicationServerHomePath.replace('\\', '/');
	
	    String portletBase = applicationServerHomePath + File.separator + "server" + File.separator + "default" + File.separator + "deploy";

		result = result.replaceAll("\\{hostName\\}", "localhost");
		result = result.replaceAll("\\{portNumber\\}", "8082");
		result = result.replaceAll("\\{applicationPath\\}", applicationPath);
		result = result.replaceAll("\\{applicationName\\}", "infoglueDeliverWorking235");
		result = result.replaceAll("\\{mailServer\\}", "smtp.gu.se");
		result = result.replaceAll("\\{operatingMode\\}", "0");
		result = result.replaceAll("\\{cmsApplicationName\\}", "infoglueCMS235");
		result = result.replaceAll("\\{enableEditOnSight\\}", "true");
		result = result.replaceAll("\\{applicationSuffix\\}", "235");
		result = result.replaceAll("\\{enablePortal\\}", "true");
		result = result.replaceAll("\\{portletBase\\}", applicationPath);
		result = result.replaceAll("\\{niceURIEncoding\\}", "UTF-8");

		System.out.println("result:" + result);
		
		PrintWriter pw = new PrintWriter(new FileOutputStream("localConfigs/deliverWorkingTest.properties"));
		pw.println(result);
		pw.close();
	}

}
