alter table OS_CURRENTSTEP MODIFY OWNER varchar(255);
alter table OS_HISTORYSTEP MODIFY OWNER varchar(255);
alter table OS_CURRENTSTEP MODIFY CALLER varchar(255);
alter table OS_HISTORYSTEP MODIFY CALLER varchar(255);

DROP INDEX "OS_CURRENTSTEP_OWNERINDEX";
DROP INDEX "OS_CURRENTSTEP_OWNERCALLER";
DROP INDEX "OS_HISTORYSTEP_OWNERINDEX";
DROP INDEX "OS_HISTORYSTEP_CALLERINDEX";

CREATE INDEX "OS_CURRENTSTEP_OWNERINDEX" ON OS_CURRENTSTEP(OWNER);
CREATE INDEX "OS_CURRENTSTEP_OWNERCALLER" ON OS_CURRENTSTEP(CALLER);
CREATE INDEX "OS_HISTORYSTEP_OWNERINDEX" ON OS_HISTORYSTEP(OWNER);
CREATE INDEX "OS_HISTORYSTEP_CALLERINDEX" ON OS_HISTORYSTEP(CALLER);

CREATE INDEX "referencingEntityNameIndex" ON cmRegistry(referencingEntityName);
CREATE INDEX "referencingEntityIdIndex" ON cmRegistry(referencingEntityId);
CREATE INDEX "entityNameIndex" ON cmRegistry(entityName);
CREATE INDEX "entityIdIndex" ON cmRegistry(entityId);
CREATE INDEX "refEntityComplNameIndex" ON cmRegistry(referencingEntityComplName);
CREATE INDEX "refEntityComplIdIndex" ON cmRegistry(referencingEntityComplId);
CREATE INDEX "categoryContVerIdIndex" ON cmContentCategory(contentVersionId);
CREATE INDEX "contVerDigAssetDigAssIdIndex" ON cmContentVersionDigitalAsset(digitalAssetId);
CREATE INDEX "contVerDigAssetContVerIdIndex" ON cmContentVersionDigitalAsset(contentVersionId);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (31,'Workflow','Workflow.Create','This point checks access to creating a new workflow',1);
INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (31, 1);

alter table cmSiNoVer add pageCacheKey varchar(255) NOT NULL DEFAULT 'default';

CREATE SEQUENCE cmRedirect_seq START WITH 100000 INCREMENT BY 1;

DROP TABLE cmRedirect;

CREATE TABLE cmRedirect
(
	id				number NOT NULL,
	url				VARCHAR2(1024) NOT NULL,
	redirectUrl		varchar2(1024) NOT NULL,
	PRIMARY KEY (id)
);

alter table cmSiNo add metaInfoContentId number DEFAULT -1;
  
update
cmSiNo sn
set sn.metaInfoContentId = (select q.value
from
cmAvailServBind asb,
cmServBind sb,
cmQualifyer q,
cmSiNoVer snv,
cmSiNo sn
where
asb.AvailServBindId = sb.AvailServBindId AND
asb.name = 'Meta information' AND
snv.siNoVerId = sb.siNoVerId AND
sb.servBindId = q.servBindId AND
snv.siNoId = sn.siNoId);  