	
INSERT INTO cmContentVersion (stateId, versionValue, modifiedDateTime, versionComment, isCheckedOut, isActive, contentId, languageId, systemUserId) VALUES
  ('0','<?xml version=\'1.0\' encoding=\'UTF-8\'?><article xmlns=\'x-schema:ArticleSchema.xml\'><attributes><UserInputHTML><![CDATA[#macro(listChildContents $parentContentId)
  #if(!$childContent.isBranch)
     <tr>
        <td colspan=\"2\"><input type=\"checkbox\" name=\"exportContentId\" value=\"$parentContentId\">$scriptLogic.getContentController().getContentVOWithId($parentContentId).name</td>
    </tr>
  #end

  #foreach($childContent in $scriptLogic.getContentController().getContentChildren($parentContentId))

    #if(!$childContent.isBranch)
    <tr>
        <td colspan=\"2\"><input type=\"checkbox\" name=\"exportContentId\" value=\"$childContent.id\">$childContent.name</td>
      </tr>
    #end

    #if($childContent.isBranch)
      #listChildContents($childContent.id)
    #end
  #end
#end 

<html>
<head>
  <title>Export content</title>
  <link rel=\"stylesheet\" type=\"text/css\" href=\"css/cms.css\" /> 
  <META HTTP-EQUIV=\"pragma\" CONTENT=\"no-cache\" />
  <META HTTP-EQUIV=\"expires\" CONTENT=\"-1\" />
  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />	
	
  <script language=\"JavaScript\"> 
    window.resizeTo(400,600);
  </script> 
	
</head>
<body class=\"contenttooledit\">
<form name=\"inputForm\" method=\"get\" action=\"ViewExecuteTask!executeTask.action\">
<input type=\"hidden\" name=\"taskContentId\" value=\"$scriptLogic.request.getParameter(\"taskContentId\")\">
<input type=\"hidden\" name=\"contentId\" value=\"$scriptLogic.request.getParameter(\"contentId\")\">
<table border=\"0\" width=\"100%\" cellpadding=\"2\" cellspacing=\"0\">
<tr>
  <td class=\"actionheader\" colspan=\"2\">XML Export Content</td>
</tr>
<tr>
  <td colspan=\"2\">This task lets you select wich contents you want to export in the folder you marked before executing the task. The contents will be exported to a common transfer format of InfoGlue. This makes it possible for anybody to import it on another infoglue instance anywhere.</td> 
</tr>
<tr>
  <td>State which languages you wish to include in the export</td>
  <td>
    #foreach ($languageVO in $scriptLogic.getLanguageController().getLanguageVOList($scriptLogic.database))
        <input type=\"checkbox\" name=\"languageId\" value=\"$languageVO.getLanguageId()\">$languageVO.getName()
    #end
  </td>
</tr>
<tr>
  <td>What version do you want to export</td>
  <td><input type=\"radio\" name=\"method\" value=\"published\" checked=\"1\"> Published versions<br> <input type=\"radio\" name=\"method\" value=\"working\"> Latest versions
  </td>
</tr>
<tr>
  <td colspan=\"2\">&nbsp;</td>
</tr>
<tr>
  <td colspan=\"2\">State which contents you wish to export</td>
</tr>
#listChildContents($scriptLogic.getInteger($scriptLogic.request.getParameter(\"contentId\")))
<tr>
  <td colspan=\"2\">&nbsp;</td>
</tr>
<tr>
  <td colspan=\"2\"><input type=\"submit\" value=\"Export\"></td>
</tr>
</table>
</form>
</body>
</html>]]></UserInputHTML><ScriptCode><![CDATA[#macro(exportContent $contentId $languageIdArray)
  
  #set($contentController = $scriptLogic.getContentController())
  #set($currentContent = $contentController.getContentWithId($contentId, $scriptLogic.database))  
  $scriptLogic.logInfo(\"currentContent:\", $currentContent)

  #set($contentTypeDefinitionName = $currentContent.contentTypeDefinition.name))

  #set($method = $scriptLogic.getRequest().getParameter(\"method\"))
  
  #set($contentElement = $domBuilder.addElement($contentsElement, \"content\"))
  $domBuilder.addAttribute($contentElement, \"contentId\", \"$contentId\")
  $domBuilder.addAttribute($contentElement, \"name\", \"$currentContent.name\")
  
  #if($contentTypeDefinitionName)
  	$domBuilder.addAttribute($contentElement, \"contentTypeDefinitionName\", \"$!contentTypeDefinitionName\")
  #end
  
  #foreach($languageIdString in $languageIdArray)
  	  #set($languageId = $scriptLogic.getInteger($languageIdString))
      $scriptLogic.logInfo(\"contentId:\", $contentId)
	  $scriptLogic.logInfo(\"languageId:\", $languageId)
	  $scriptLogic.logInfo(\"contentId:\", $contentId.class.getName())
	  $scriptLogic.logInfo(\"db:\", $scriptLogic.database)
	
	  #if($method == \"published\")
	
	    #if(!$scriptLogic.isNull($scriptLogic.getContentVersionController().getLatestPublishedContentVersion($contentId, $languageId)))
	
	      #set($contentVersionElement = $domBuilder.addElement($contentElement, \"contentVersion\"))
	      
	      $domBuilder.addAttribute($contentVersionElement, \"languageId\", \"$languageId\")
	     
	      #set($contentVersionVO = $scriptLogic.getContentVersionController().getLatestPublishedContentVersion($contentId, $languageId))
		  
	      #set($versionDocument = $domBuilder.getDocument($contentVersionVO.versionValue))
	      $domBuilder.insertElement($contentVersionElement, $versionDocument.getRootElement())
	    #end
	
	  #else
	
	    #if(!$scriptLogic.isNull($scriptLogic.getContentVersionController().getLatestActiveContentVersionVO($contentId, $languageId)))
	
	      #set($contentVersionElement = $domBuilder.addElement($contentElement, \"contentVersion\"))
	      
	      $domBuilder.addAttribute($contentVersionElement, \"languageId\", \"$languageId\")
	
	      #set($contentVersionVO = $scriptLogic.getContentVersionController().getLatestActiveContentVersionVO($contentId, $languageId))
		
	      #set($versionDocument = $domBuilder.getDocument($contentVersionVO.versionValue))
	      $domBuilder.insertElement($contentVersionElement, $versionDocument.getRootElement())
	    #end
	
	  #end
  #end
#end


$scriptLogic.logInfo(\"******************************\")
$scriptLogic.logInfo(\"** Running task Export Content   **\")
$scriptLogic.logInfo(\"******************************\")

#set($languageIdArray = $scriptLogic.getRequest().getParameterValues(\"languageId\"))
#set($contents = $scriptLogic.getRequest().getParameterValues(\"exportContentId\"))

#foreach($contentId in $contents)
  $scriptLogic.logInfo($contentId)
#end

#set($date = $scriptLogic.getObjectWithName(\"java.util.Date\"))
#set($cmsPropertyHandler = $scriptLogic.getObjectWithName(\"org.infoglue.cms.util.CmsPropertyHandler\"))
#set($domBuilder = $scriptLogic.getObjectWithName(\"org.infoglue.cms.util.dom.DOMBuilder\"))
#set($document = $domBuilder.createDocument())

#set($rootElement = $domBuilder.addElement($document, \"export\"))

$domBuilder.addAttribute($rootElement , \"exportDateTime\", $date.toString())

#set($contentsElement= $domBuilder.addElement($rootElement , \"contents\"))
  
#foreach($contentId in $contents)
  ##exportContent($scriptLogic.getInteger($contentId) $scriptLogic.getInteger($languageId))
  #exportContent($scriptLogic.getInteger($contentId) $languageIdArray)
#end

#set($exportFileName = \"export_$date.getYear()-$date.getMonth()-$date.getDate()_${date.getTime()}.xml\")
#set($exportFileUrl = \"$cmsPropertyHandler.getProperty(\'webServerAddress\')/$cmsPropertyHandler.getProperty(\'digitalAssetBaseUrl\')/$exportFileName\")

#set($fileName = \"$cmsPropertyHandler.getProperty(\'digitalAssetPath\')/export_$date.getYear()-$date.getMonth()-$date.getDate()_${date.getTime()}.xml\")
$domBuilder.write($document, $fileName)

$scriptLogic.setOutputParameter(\"exportFileName\", $exportFileName)
$scriptLogic.setOutputParameter(\"exportFileUrl\", $exportFileUrl)


$scriptLogic.logInfo(\"Export finished\")]]></ScriptCode><UserOutputHTML><![CDATA[<html>
<head>
  <title>Export finished</title>
  <link rel=\"stylesheet\" type=\"text/css\" href=\"css/cms.css\" /> 
  <META HTTP-EQUIV=\"pragma\" CONTENT=\"no-cache\" />
  <META HTTP-EQUIV=\"expires\" CONTENT=\"-1\" />
  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />	
	
  <script language=\"JavaScript\"> 
    window.resizeTo(400,600);
  </script> 
	
</head>
<body class=\"contenttooledit\">
<form name=\"inputForm\" method=\"get\" action=\"ViewExecuteTask!executeTask.action\">
<input type=\"hidden\" name=\"contentId\" value=\"$scriptLogic.request.getParameter(\"contentId\")\">
<table border=\"0\" width=\"100%\" cellpadding=\"2\" cellspacing=\"0\">
<tr>
  <td class=\"actionheader\" colspan=\"2\">XML Content Export</td>
</tr>
<tr>
  <td colspan=\"2\">The export was successful and the resulting xml-file is available by clicking on the link below. Rightclick on the link and choose save as if you want to store it locally:<br><br> <b>Download:</b> <a href=\"$scriptLogic.getOutputParameter(\"exportFileUrl\")\">$scriptLogic.getOutputParameter(\"exportFileName\")</a></td>
</tr>
<tr>
  <td colspan=\"2\">&nbsp;</td>
</tr>
<tr>
  <td colspan=\"2\"><a href=\"javascript:window.close();\">Close</a></td>
</tr>
</table>
</form>
</body>
</html>]]></UserOutputHTML></attributes></article>','2003-08-18 00:00:00','','0','1','exportContentId','1','1');

#endquery

INSERT INTO cmContentVersion (stateId, versionValue, modifiedDateTime, versionComment, isCheckedOut, isActive, contentId, languageId, systemUserId) VALUES
  ('0','<?xml version=\'1.0\' encoding=\'UTF-8\'?><article xmlns=\'x-schema:ArticleSchema.xml\'><attributes><UserInputHTML><![CDATA[<html>
<head>  
  <title>Import Contents</title>
  <link rel=\"stylesheet\" type=\"text/css\" href=\"css/cms.css\" /> 
  <META HTTP-EQUIV=\"pragma\" CONTENT=\"no-cache\" />
  <META HTTP-EQUIV=\"expires\" CONTENT=\"-1\" />
  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />	
	
  <script language=\"JavaScript\"> 
    window.resizeTo(400,600);
  </script> 
	
</head>
<body class=\"contenttooledit\">
<form enctype=\"multipart/form-data\" name=\"inputForm\" method=\"post\" action=\"ViewExecuteTask!executeTask.action\">
<input type=\"hidden\" name=\"taskContentId\" value=\"$scriptLogic.request.getParameter(\"taskContentId\")\">
<input type=\"hidden\" name=\"contentId\" value=\"$scriptLogic.request.getParameter(\"contentId\")\">
<table border=\"0\" width=\"100%\" cellpadding=\"2\" cellspacing=\"0\">
<tr>
  <td class=\"actionheader\" colspan=\"2\">Content Import</td>
</tr>
<tr>
  <td colspan=\"2\">&nbsp;</td>
</tr>
<tr>
  <td colspan=\"2\">This task lets you import contents previously exported to XML. It will import the contents to the folder you stood on when you clicked execute task.</td> 
</tr>
<tr>
  <td colspan=\"2\">Point out the xml-file that contain the exported contents</td>
</tr>
<tr>
  <td colspan=\"2\"><input type=\"file\" name=\"xmlFile\"></td>
</tr>
<tr>
  <td colspan=\"2\">&nbsp;</td>
</tr>
<tr>
  <td colspan=\"2\"><input type=\"submit\" value=\"Import\"></td>
</tr>
</table>
</form>
</body>
</html>]]></UserInputHTML><ScriptCode><![CDATA[#macro(createContent $parentContentId $name $contentTypeDefinitionName $repositoryId $isBranch)

  #set($contentTypeDefinitionController = $scriptLogic.getObjectWithName(\"org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController\"))

  #foreach($contentTypeDefinition in $contentTypeDefinitionController.contentTypeDefinitionVOList)
    #if($contentTypeDefinition.name == \"$contentTypeDefinitionName\")
      #set($contentTypeDefinitionId = $contentTypeDefinition.id)
    #end
  #end

  #set($newContentVO = $contentController.getNewVO())
  $newContentVO.setName($name)
  $newContentVO.setIsBranch($isBranch)
  
  $scriptLogic.logInfo(\"File:\", $scriptLogic.database)
  $scriptLogic.logInfo(\"File:\", $parentContentId)
  $scriptLogic.logInfo(\"File:\", $contentTypeDefinitionId)
  $scriptLogic.logInfo(\"File:\", $repositoryId)
  $scriptLogic.logInfo(\"File:\", $newContentVO)

  #set($newContent = $contentController.create($scriptLogic.database, $parentContentId, $contentTypeDefinitionId, \"$remoteUser\", $repositoryId, $newContentVO))
  $scriptLogic.logInfo(\"content created:\", $newContent)

#end


$scriptLogic.logInfo(\"***********************************\")
$scriptLogic.logInfo(\"** Running task Import Content   **\")
$scriptLogic.logInfo(\"***********************************\")

#set($remoteUser = $scriptLogic.getRequest().getRemoteUser())
$scriptLogic.logInfo(\"remoteUser:\", $remoteUser)

#set($fileUploadHelper = $scriptLogic.getObjectWithName(\"org.infoglue.cms.util.FileUploadHelper\"))
#set($file = $fileUploadHelper.getUploadedFile($scriptLogic.getActionContext().getMultiPartRequest()))

$scriptLogic.logInfo(\"File:\", $file.getName())

#set($domBuilder = $scriptLogic.getObjectWithName(\"org.infoglue.cms.util.dom.DOMBuilder\"))
#set($importDocument = $domBuilder.getDocument($file))
$domBuilder.writeDebug($importDocument)

#set($contentElements = $importDocument.selectNodes(\"//content\"))
$scriptLogic.logInfo(\"Contents\", $contentElements.size())

#set($parentContentId = $scriptLogic.getInteger($scriptLogic.request.getParameter(\"contentId\")))
$scriptLogic.logInfo(\"ParentContentId:\", $parentContentId)

#set($contentController = $scriptLogic.getContentController())
#set($parentContent = $contentController.getContentWithId($parentContentId, $scriptLogic.database))  
#set($repositoryId = $parentContent.repository.id)

#foreach($contentElement in $contentElements)
  #set($contentId = $contentElement.attribute(\"contentId\").getValue())
  #set($name = $contentElement.attribute(\"name\").getValue())
  #set($contentTypeDefinitionName = $contentElement.attribute(\"contentTypeDefinitionName\").getValue())

  #set($isFolder = true)
  #if($contentTypeDefinitionName)
  	#set($isFolder = false)
  #end
  	
  $scriptLogic.logInfo(\"ContentId:\", $contentId)
  $scriptLogic.logInfo(\"Name:\", $name)
  $scriptLogic.logInfo(\"ContentTypeDefinitionName:\", $contentTypeDefinitionName)
	
  #createContent($parentContentId $name $contentTypeDefinitionName $repositoryId $isFolder)
  $scriptLogic.logInfo(\"Content created:\", $newContent.contentId)

  #foreach($contentVersionElement in $contentElement.elements(\"contentVersion\"))
	  #set($languageId = $contentVersionElement.attribute(\"languageId\").getValue())
	  $scriptLogic.logInfo(\"LanguageId:\", $languageId)
	
	  #set($newContentVersionVO = $scriptLogic.getObjectWithName(\"org.infoglue.cms.entities.content.ContentVersionVO\"))
	  #set($date = $scriptLogic.getObjectWithName(\"java.util.Date\"))
	  $newContentVersionVO.setLanguageId($languageId)
	  $newContentVersionVO.setStateId(0)
	  $newContentVersionVO.setModifiedDateTime($date)
	  $newContentVersionVO.setVersionComment(\"Imported\")
	  #set($versionValue = $domBuilder.encodeString($contentVersionElement.elements().get(0).asXML(), \"UTF-8\"))
	  $newContentVersionVO.setVersionValue(\"<?xml version=\'1.0\' encoding=\'UTF-8\'?>$versionValue\")
	
	  $scriptLogic.logInfo(\"Adding version as follows\", $newContent.contentId)
	  $scriptLogic.logInfo(\"languageId\", $languageId)
	  $scriptLogic.logInfo(\"languageId\", $languageId.class.name)
	  $scriptLogic.logInfo(\"remoteUser\", $remoteUser)
	  $scriptLogic.logInfo(\"newContentVersionVO\", $newContentVersionVO)
	  $scriptLogic.logInfo(\"database\", $scriptLogic.database)
	
	  $scriptLogic.logInfo(\"version\", $newContentVersionVO.versionValue)
	  
	  #set($newContentVersion = $scriptLogic.getContentVersionController().create($newContent.contentId, $scriptLogic.getInteger($languageId), \"$remoteUser\", $newContentVersionVO, null, $scriptLogic.database))
	
	  $scriptLogic.logInfo(\"ContentVersion created:\", $newContentVersion.contentVersionId)
  #end
  
#end

$scriptLogic.logInfo(\"Import finished\")
]]></ScriptCode><UserOutputHTML><![CDATA[<html>
<head>
  <title>Import finished</title>
  <link rel=\"stylesheet\" type=\"text/css\" href=\"css/cms.css\" /> 
  <META HTTP-EQUIV=\"pragma\" CONTENT=\"no-cache\" />
  <META HTTP-EQUIV=\"expires\" CONTENT=\"-1\" />
  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />	
	
  <script language=\"JavaScript\"> 
    window.resizeTo(400,600);
  </script> 
	
</head>
<body class=\"contenttooledit\">
<form name=\"inputForm\" method=\"get\" action=\"ViewExecuteTask!executeTask.action\">
<input type=\"hidden\" name=\"contentId\" value=\"$scriptLogic.request.getParameter(\"contentId\")\">
<table border=\"0\" width=\"100%\" cellpadding=\"2\" cellspacing=\"0\">
<tr>
  <td colspan=\"2\" class=\"actionheader\">Content Import</td>
</tr>
<tr>
  <td colspan=\"2\">The import was successful</td>
</tr>
<tr>
  <td colspan=\"2\">&nbsp;</td>
</tr>
<tr>
  <td colspan=\"2\"><a href=\"javascript:window.close();\">Close</a></td>
</tr>
</table>
</form>
</body>
</html>]]></UserOutputHTML></attributes></article>','2003-08-18 00:00:00','','0','1','importContentId','1','1');