alter table OS_CURRENTSTEP ALTER COLUMN OWNER varchar(255);
alter table OS_HISTORYSTEP ALTER COLUMN OWNER varchar(255);
alter table OS_CURRENTSTEP ALTER COLUMN CALLER varchar(255);
alter table OS_HISTORYSTEP ALTER COLUMN CALLER varchar(255);

DROP INDEX OS_CURRENTSTEP.OWNER;
DROP INDEX OS_CURRENTSTEP.CALLER;
DROP INDEX OS_HISTORYSTEP.OWNER;
DROP INDEX OS_HISTORYSTEP.CALLER;

CREATE INDEX OWNER ON OS_CURRENTSTEP(OWNER);
CREATE INDEX CALLER ON OS_CURRENTSTEP(CALLER);
CREATE INDEX OWNER ON OS_HISTORYSTEP(OWNER);
CREATE INDEX CALLER ON OS_HISTORYSTEP(CALLER);

DROP INDEX cmRegistry.referencingEntityName;
DROP INDEX cmRegistry.referencingEntityId;
DROP INDEX cmRegistry.entityName;
DROP INDEX cmRegistry.entityId;
DROP INDEX cmRegistry.referencingEntityComplName;
DROP INDEX cmRegistry.referencingEntityComplId;
DROP INDEX cmContentCategory.categoryContVersionId;
DROP INDEX cmContentVersionDigitalAsset.contVerDigAssetDigAssId;
DROP INDEX cmContentVersionDigitalAsset.contVerDigAssetContVerId;

CREATE INDEX referencingEntityName ON cmRegistry(referencingEntityName);
CREATE INDEX referencingEntityId ON cmRegistry(referencingEntityId);
CREATE INDEX entityName ON cmRegistry(entityName);
CREATE INDEX entityId ON cmRegistry(entityId);
CREATE INDEX referencingEntityComplName ON cmRegistry(referencingEntityComplName);
CREATE INDEX referencingEntityComplId ON cmRegistry(referencingEntityComplId);
CREATE INDEX categoryContVersionId ON cmContentCategory(contentVersionId);
CREATE INDEX contVerDigAssetDigAssId ON cmContentVersionDigitalAsset(digitalAssetId);
CREATE INDEX contVerDigAssetContVerId ON cmContentVersionDigitalAsset(contentVersionId);


set identity_insert cmInterceptionPoint on;

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (31,'Workflow','Workflow.Create','This point checks access to creating a new workflow',1);

set identity_insert cmInterceptionPoint off;

set identity_insert cmInterceptionPointInterceptor on;

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (31, 1);

set identity_insert cmInterceptionPointInterceptor off;

alter table cmSiteNodeVersion add pageCacheKey varchar(255) NOT NULL default 'default';
  
CREATE TABLE cmRedirect
(
	id			[int] IDENTITY (1, 1) NOT NULL,
	url			VARCHAR(1024) NOT NULL,
	redirectUrl	VARCHAR(1024) NOT NULL,
	PRIMARY KEY (id)
)  

Alter table cmSiteNode add metaInfoContentId integer NULL default '-1';
  
update
cmSiteNode
set cmSiteNode.metaInfoContentId = cmQualifyer.value
from
cmAvailableServiceBinding,
cmServiceBinding,
cmQualifyer,
cmSiteNodeVersion,
cmSiteNode
where
cmAvailableServiceBinding.availableServiceBindingId = cmServiceBinding.availableServiceBindingId AND
cmAvailableServiceBinding.name = 'Meta information' AND
cmSiteNodeVersion.siteNodeVersionId = cmServiceBinding.siteNodeVersionId AND
cmServiceBinding.serviceBindingId = cmQualifyer.serviceBindingId AND
cmSiteNodeVersion.siteNodeId = cmSiteNode.siteNodeId;