CREATE proc sp_Dropindex
	@objname nvarchar(776)
as
declare @NAME varchar(50),
             @objid int,
             @dbname sysname
if @dbname is not null and @dbname <> db_name()
begin
	raiserror(15250,-1,-1)
	return (1)
end
select @objid = object_id(@objname)
if @objid is NULL
begin
	raiserror(15001,-1,-1,@objname)
	return (1)
end

declare db cursor for
select name from sysindexes where
id=(select id from sysobjects where type ='u' and name=@objname)
and indid > 0 and indid < 255 and (status & 64)=0

open db
fetch next from db INTO @NAME
if @@fetch_status = -1
Begin
             raiserror(15472,-1,-1) --'Object does not have any indexes.'
             close db
            deallocate db
	return (1)
End

while @@fetch_status=0
BEGIN
   if @@fetch_status=0
        begin
   exec('Drop index '+@objname+'.'+@name)
END
    fetch next from db INTO @NAME
end
   close db
   deallocate db
;

CREATE proc sp_Dropconstraints @objname nvarchar(776)
as
declare @NAME varchar(50), @objid int, @dbname sysname

if @dbname is not null and @dbname <> db_name()
begin
	raiserror(15250,-1,-1)
	return (1)
end

select @objid = object_id(@objname)
if @objid is NULL
begin
	raiserror(15001,-1,-1,@objname)
	return (1)
end

declare db cursor for
select OBJECT_NAME(constid) from sysconstraints where
OBJECT_NAME(id)=@objname

open db
fetch next from db INTO @NAME
if @@fetch_status = -1
Begin
             raiserror(15472,-1,-1) --'Object does not have any indexes.'
             close db
            deallocate db
	return (1)
End

while @@fetch_status=0
BEGIN
   if @@fetch_status=0
        begin
   exec('ALTER TABLE '+@objname+' DROP CONSTRAINT '+@name)
END
    fetch next from db INTO @NAME
end
   close db
   deallocate db
;


if exists (select * from dbo.sysobjects where id = object_id(N'[cmAction]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmAction;
if exists (select * from dbo.sysobjects where id = object_id(N'[cmActionDefinition]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmActionDefinition;
if exists (select * from dbo.sysobjects where id = object_id(N'[cmActor]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmActor;
if exists (select * from dbo.sysobjects where id = object_id(N'[cmConsequence]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmConsequence;
if exists (select * from dbo.sysobjects where id = object_id(N'[cmConsequenceDefinition]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmConsequenceDefinition;
if exists (select * from dbo.sysobjects where id = object_id(N'[cmFunction]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmFunction;
if exists (select * from dbo.sysobjects where id = object_id(N'[cmWorkflow]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmWorkflow;

sp_rename 'cmRole.[name]', 'roleName', 'COLUMN';
ALTER TABLE cmRole ALTER COLUMN roleName varchar(255) NOT NULL;

sp_Dropconstraints 'cmContentTypeDefinition';
sp_Dropindex 'cmContentTypeDefinition';
ALTER TABLE cmContentTypeDefinition ALTER COLUMN name varchar(50) NOT NULL;

sp_Dropconstraints 'cmSystemUserRole';
sp_Dropindex 'cmSystemUserRole';

ALTER TABLE cmSystemUserRole DROP COLUMN systemUserRoleId;
ALTER TABLE cmSystemUserRole ADD userName varchar(255) NOT NULL default '';
ALTER TABLE cmSystemUserRole ADD roleName varchar(255) NOT NULL default '';

UPDATE cmSystemUserRole SET userName = (SELECT userName FROM cmSystemUser where cmSystemUserRole.systemUserId = cmSystemUser.systemUserId);
UPDATE cmSystemUserRole SET roleName = (SELECT roleName FROM cmRole where cmSystemUserRole.roleId = cmRole.roleId);

ALTER TABLE cmContent ADD creator varchar(255) NOT NULL default 'administrator';
UPDATE cmContent SET creator = (SELECT userName FROM cmSystemUser where cmContent.systemUserId = cmSystemUser.systemUserId);
sp_Dropconstraints 'cmContent';
ALTER TABLE cmContent DROP COLUMN systemUserId;

ALTER TABLE cmContentVersion ADD versionModifier varchar(255) NOT NULL default 'administrator';
UPDATE cmContentVersion SET versionModifier = (SELECT userName FROM cmSystemUser where cmContentVersion.systemUserId = cmSystemUser.systemUserId);
sp_Dropconstraints 'cmContentVersion';
ALTER TABLE cmContentVersion DROP COLUMN systemUserId;

ALTER TABLE cmEvent ADD creator varchar(255) NOT NULL default 'administrator';
UPDATE cmEvent SET creator = (SELECT userName FROM cmSystemUser where cmEvent.systemUserId = cmSystemUser.systemUserId);
sp_Dropconstraints 'cmEvent';
ALTER TABLE cmEvent DROP COLUMN systemUserId;

ALTER TABLE cmSiteNode ADD creator varchar(255) NOT NULL default 'administrator';
UPDATE cmSiteNode SET creator = (SELECT userName FROM cmSystemUser where cmSiteNode.systemUserId = cmSystemUser.systemUserId);
sp_Dropconstraints 'cmSiteNode';
ALTER TABLE cmSiteNode DROP COLUMN systemUserId;

ALTER TABLE cmSiteNodeVersion ADD versionModifier varchar(255) NOT NULL default 'administrator';
UPDATE cmSiteNodeVersion SET versionModifier = (SELECT userName FROM cmSystemUser where cmSiteNodeVersion.systemUserId = cmSystemUser.systemUserId);
sp_Dropconstraints 'cmSiteNodeVersion';
ALTER TABLE cmSiteNodeVersion DROP COLUMN systemUserId;

ALTER TABLE cmPublication ADD publisher varchar(255) NOT NULL default 'administrator';
UPDATE cmPublication SET publisher = (SELECT userName FROM cmSystemUser where cmPublication.systemUserId = cmSystemUser.systemUserId);
sp_Dropconstraints 'cmPublication';
ALTER TABLE cmPublication DROP COLUMN systemUserId;

ALTER TABLE cmPublicationDetail ADD publisher varchar(255) NOT NULL default 'administrator';
UPDATE cmPublicationDetail SET publisher = (SELECT userName FROM cmSystemUser where cmPublicationDetail.systemUserId = cmSystemUser.systemUserId);
sp_Dropconstraints 'cmPublicationDetail';
ALTER TABLE cmPublicationDetail DROP COLUMN systemUserId;


ALTER TABLE cmSystemUserRole DROP COLUMN systemUserId;
ALTER TABLE cmSystemUserRole DROP COLUMN roleId;

sp_Dropconstraints 'cmSystemUser';
sp_Dropindex 'cmSystemUser';
sp_Dropconstraints 'cmRole';
sp_Dropindex 'cmRole';

ALTER TABLE cmSystemUser DROP COLUMN systemUserId;
ALTER TABLE cmRole DROP COLUMN roleId;

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cmRoleContentTypeDefinition]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmRoleContentTypeDefinition;

CREATE TABLE cmRoleContentTypeDefinition (
  roleContentTypeDefinitionId [int] IDENTITY (1, 1) NOT NULL,
  roleName varchar(100) NOT NULL,
  contentTypeDefinitionId integer NOT NULL default '0',
  PRIMARY KEY  (roleContentTypeDefinitionId)
)


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cmRoleProperties]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmRoleProperties;

CREATE TABLE cmRoleProperties (
  rolePropertiesId [int] IDENTITY (1, 1) NOT NULL,
  roleName varchar(100) NOT NULL,
  contentTypeDefinitionId integer NOT NULL default '0',
  value ntext NOT NULL,
  languageId integer NOT NULL default '0',
  PRIMARY KEY  (rolePropertiesId)
)


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cmUserContentTypeDefinition]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmUserContentTypeDefinition;

CREATE TABLE cmUserContentTypeDefinition (
  userContentTypeDefinitionId [int] IDENTITY (1, 1) NOT NULL,
  userName varchar(100) NOT NULL,
  contentTypeDefinitionId integer NOT NULL default '0',
  PRIMARY KEY  (userContentTypeDefinitionId)
)


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cmUserProperties]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmUserProperties;

CREATE TABLE cmUserProperties (
  userPropertiesId [int] IDENTITY (1, 1) NOT NULL,
  userName varchar(100) NOT NULL,
  contentTypeDefinitionId integer NOT NULL default '0',
  value ntext NOT NULL,
  languageId integer NOT NULL default '0',
  PRIMARY KEY  (userPropertiesId)
)


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cmAccessRight]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmAccessRight;

CREATE TABLE cmAccessRight (
  accessRightId [int] IDENTITY (1, 1) NOT NULL,
  parameters varchar(1024) NULL,
  roleName varchar(100) NOT NULL,
  interceptionPointId integer NOT NULL default '0',
  PRIMARY KEY  (accessRightId)
)


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cmInterceptionPoint]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmInterceptionPoint;

CREATE TABLE cmInterceptionPoint (
  interceptionPointId [int] IDENTITY (1, 1) NOT NULL,
  category varchar(100) NOT NULL,
  name varchar(100) NOT NULL,
  description varchar(1024) NOT NULL,
  usesExtraDataForAccessControl integer NOT NULL default '0',
  PRIMARY KEY  (interceptionPointId)
)


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cmInterceptionPointInterceptor]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmInterceptionPointInterceptor;

CREATE TABLE cmInterceptionPointInterceptor (
  interceptionPointId [int] IDENTITY (1, 1) NOT NULL,
  interceptorId integer NOT NULL default '0',
  PRIMARY KEY  (interceptionPointId, interceptorId)
)


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cmInterceptor]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
DROP TABLE cmInterceptor;

CREATE TABLE cmInterceptor (
  interceptorId [int] IDENTITY (1, 1) NOT NULL,
  name varchar(255) NOT NULL,
  className varchar(255) NOT NULL,
  description varchar(1024) NOT NULL,
  PRIMARY KEY  (interceptorId)
)



if exists (select * from dbo.sysobjects where id = object_id(N'[OS_PROPERTYENTRY]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [OS_PROPERTYENTRY];

if exists (select * from dbo.sysobjects where id = object_id(N'[OS_CURRENTSTEP_PREV]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [OS_CURRENTSTEP_PREV];

if exists (select * from dbo.sysobjects where id = object_id(N'[OS_HISTORYSTEP_PREV]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [OS_HISTORYSTEP_PREV];

if exists (select * from dbo.sysobjects where id = object_id(N'[OS_CURRENTSTEP]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [OS_CURRENTSTEP];

if exists (select * from dbo.sysobjects where id = object_id(N'[OS_HISTORYSTEP]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [OS_HISTORYSTEP];

if exists (select * from dbo.sysobjects where id = object_id(N'[OS_WFENTRY]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
drop table [OS_WFENTRY];


create table OS_WFENTRY
(
    ID int,
    NAME varchar(128),
    STATE smallint,
    primary key (ID)
);

create table OS_CURRENTSTEP
(
    ID int,
    ENTRY_ID int,
    STEP_ID smallint,
    ACTION_ID smallint,
    OWNER varchar(20),
    START_DATE datetime,
    FINISH_DATE datetime,
    DUE_DATE datetime,
    STATUS varchar(20),
    CALLER varchar(20),
    primary key (ID),
    foreign key (ENTRY_ID) references OS_WFENTRY(ID)

);

create table OS_HISTORYSTEP
(
    ID int,
    ENTRY_ID int,
    STEP_ID smallint,
    ACTION_ID smallint,
    OWNER varchar(20),
    START_DATE datetime,
    FINISH_DATE datetime,
    DUE_DATE datetime,
    STATUS varchar(20),
    CALLER varchar(20),
    primary key (ID),
    foreign key (ENTRY_ID) references OS_WFENTRY(ID)
);

create table OS_CURRENTSTEP_PREV
(
    ID int,
    PREVIOUS_ID int,
    primary key (ID, PREVIOUS_ID),
    foreign key (ID) references OS_CURRENTSTEP(ID),
    foreign key (PREVIOUS_ID) references OS_HISTORYSTEP(ID)
);

create table OS_HISTORYSTEP_PREV
(
    ID int,
    PREVIOUS_ID int,
    primary key (ID, PREVIOUS_ID),
    foreign key (ID) references OS_HISTORYSTEP(ID),
    foreign key (PREVIOUS_ID) references OS_HISTORYSTEP(ID)
);

CREATE TABLE OS_STEPIDS
(
	ID int,
	primary key (ID)
);

CREATE TABLE OS_PROPERTYENTRY
(
  GLOBAL_KEY varchar(255),
  ITEM_KEY varchar(255),
  ITEM_TYPE smallint,
  STRING_VALUE varchar(255),
  DATE_VALUE datetime,
  DATA_VALUE image,
  FLOAT_VALUE float,
  NUMBER_VALUE numeric,
  primary key (GLOBAL_KEY, ITEM_KEY)
);
 

INSERT INTO cmRole (roleName, description) VALUES
  ('anonymous','Must be present to model the default anonymous extranet role.');


INSERT INTO cmSystemUser (userName, password, firstName, lastName, email) VALUES
  ('anonymous','anonymous','Anonymous','User','anonymous@infoglue.org');


INSERT INTO cmSystemUserRole (userName, roleName) VALUES
  ('anonymous','anonymous');


set identity_insert cmInterceptionPoint on;

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (1,'Repository','Repository.Read','Gives a user access to look at a repository',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (2,'ManagementTool','ManagementTool.Read','Gives a user access to the management tool',0);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (3,'ContentTool','ContentTool.Read','Gives a user access to the content tool',0);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (4,'StructureTool','StructureTool.Read','Gives a user access to the structure tool',0);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (5,'PublishingTool','PublishingTool.Read','Gives a user access to the publishing tool',0);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (6,'Content','Content.Read','Intercepts the read of a content',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (7,'Content','Content.Write','Intercepts the write of a content',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (8,'SiteNodeVersion','SiteNodeVersion.Read','Intercepts the read of a SiteNodeVersion',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (9,'SiteNodeVersion','SiteNodeVersion.Write','Intercepts the write of a SiteNodeVersion',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (10,'Content','Content.Create','Intercepts the creation of a new content or folder',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (11,'Content','Content.Delete','Intercepts the deletion of a content',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (12,'Content','Content.Move','Intercepts the movement of a content',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (13,'Content','Content.SubmitToPublish','Intercepts the submittance to publish of all content versions',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (14,'Content','Content.ChangeAccessRights','Intercepts the attempt to change access rights',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (15,'Content','Content.CreateVersion','Intercepts the creation of a new contentversion',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (16,'ContentVersion','ContentVersion.Delete','Intercepts the deletion of a contentversion',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (17,'ContentVersion','ContentVersion.Write','Intercepts the editing of a contentversion',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (18,'ContentVersion','ContentVersion.Read','Intercepts the read of a contentversion',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (19,'SiteNodeVersion','SiteNodeVersion.CreateSiteNode','Intercepts the creation of a new sitenode',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (20,'SiteNodeVersion','SiteNodeVersion.DeleteSiteNode','Intercepts the deletion of a sitenode',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (21,'SiteNodeVersion','SiteNodeVersion.MoveSiteNode','Intercepts the movement of a sitenode',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (22,'SiteNodeVersion','SiteNodeVersion.SubmitToPublish','Intercepts the submittance to publish of all content versions',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (23,'SiteNodeVersion','SiteNodeVersion.ChangeAccessRights','Intercepts the attempt to change access rights',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES
  (24,'ContentVersion','ContentVersion.Publish','Intercepts the direct publishing of a content version',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES
  (25,'SiteNodeVersion','SiteNodeVersion.Publish','Intercepts the direct publishing of a siteNode version',1);

INSERT INTO cmInterceptionPoint (interceptionPointId, category, name, description, usesExtraDataForAccessControl) VALUES 
  (26,'MyDesktopTool','MyDesktopTool.Read','Gives a user access to the MyDesktop tool',0);

set identity_insert cmInterceptionPoint off;


set identity_insert cmInterceptor on;

INSERT INTO cmInterceptor (interceptorId, name, className, description) VALUES
  (1,'InfoGlue Common Access Rights Interceptor','org.infoglue.cms.security.interceptors.InfoGlueCommonAccessRightsInterceptor','Takes care of bla');

set identity_insert cmInterceptor off;


set identity_insert cmInterceptionPointInterceptor on;

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (1, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (2, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (3, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (4, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (5, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (6, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (7, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (8, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (9, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (10, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (11, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (12, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (13, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (14, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (15, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (16, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (17, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (18, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (19, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (20, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (21, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (22, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (23, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (24, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (25, 1);

INSERT INTO cmInterceptionPointInterceptor (interceptionPointId, interceptorId) VALUES
  (26, 1);

set identity_insert cmInterceptionPointInterceptor off


set identity_insert cmAccessRight on

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (1, '1', 'administrators', 1);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (2, '1', 'cmsUser', 1);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (3, '2', 'administrators', 1);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (4, '2', 'cmsUser', 1);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (5, '3', 'administrators', 1);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (6, '3', 'cmsUser', 1);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (7, '4', 'administrators', 1);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (8, '4', 'cmsUser', 1);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (9, NULL, 'administrators', 3);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (10, NULL, 'cmsUser', 3);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (11, NULL, 'administrators', 2);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (12, NULL, 'cmsUser', 2);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (13, NULL, 'administrators', 4);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (14, NULL, 'cmsUser', 4);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (15, NULL, 'administrators', 5);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (16, NULL, 'cmsUser', 5);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (17, NULL, 'administrators', 26);

INSERT INTO cmAccessRight (accessRightId, parameters, roleName, interceptionPointId) VALUES
  (18, NULL, 'cmsUser', 26);

set identity_insert cmAccessRight off;


CREATE INDEX serviceBindingId ON cmQualifyer(serviceBindingId);
CREATE INDEX serviceDefinitionId ON cmServiceBinding(serviceDefinitionId);
CREATE INDEX availableServiceBindingId ON cmServiceBinding(availableServiceBindingId);
CREATE INDEX siteNodeVersionId ON cmServiceBinding(siteNodeVersionId);
CREATE INDEX name ON cmContentTypeDefinition(name);
CREATE INDEX contentId ON cmContentVersion(contentId);
CREATE INDEX siteNodeId ON cmSiteNodeVersion(siteNodeId);

COMMIT;