/* ===============================================================================
 *
 * Part of the InfoGlue Content Management Platform (www.infoglue.org)
 *
 * ===============================================================================
 *
 *  Copyright (C)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2, as published by the
 * Free Software Foundation. See the file LICENSE.html for more information.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
 * Place, Suite 330 / Boston, MA 02111-1307 / USA.
 *
 * ===============================================================================
 */

package org.infoglue.cmsinstaller;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

/**
 * This is the database dialog.
 */

public class ServerDialog extends JPanel implements ActionListener
{
	private InfoGlueInstaller infoglueInstaller = null;
	
	private final static String introductionHeader  = "Server setup";
	private final static String introductionMessage = "For the system to work we also have to set up the properties below so they corresponds to your configuration. Tip: All fields have a help text if you put your mouse over the label.\n\nPlease supply the information needed below.";
	
	private final static String applicationServerLabel	= "Application server"; 
	private final static String hostNameLabel	  		= "Host Name"; 
	private final static String portNumberLabel	  		= "Port number"; 
	private final static String applicationSuffixLabel	= "Application suffix"; 
	private final static String digitalAssetPathLabel	= "Digital asset path"; 
	private final static String enablePortalLabel		= "Enable JSR 168 support";
	private final static String applicationPathLabel	= "InfoGlue HOME"; 
	private final static String smtpHostNameLabel		= "SMTP Host"; 
	private final static String applicationServerHomePathLabel = "App Server HOME"; 

	private final static String superUserLabel			= "Superuser"; 
	private final static String superUserPasswordLabel	= "Password"; 

	private JComboBox applicationServer    	= null;
	private JTextField hostName       		= null;
	private JTextField digitalAssetPath 	= null;
	private JTextField applicationPath 		= null;
	private JTextField portNumber     		= null;
	private JTextField applicationSuffix 	= null;
	private JTextField smtpHostName			= null;
	private JTextField applicationServerHomePath = null;
	private JCheckBox createCMS  			= null;
	private JCheckBox createDeliverWorking	= null;
	private JCheckBox createDeliverPreview	= null;
	private JCheckBox createDeliverLive		= null;

	private JTextField superUserName		= null;
	private JTextField superUserPassword	= null;
	
	private JCheckBox enablePortal			= null;
	
	private JTextArea errorMessage    		= null;

	/*
	private int xPosLabels = 0;
	private int xPosLabelsWidth = 120;
	private int xPosValues = 130;
	private int xPosValuesWidth = 190;
	*/
	private int xPosLabels = 0;
	private int xPosLabelsWidth = 140;
	private int xPosValues = 150;
	private int xPosValuesWidth = 230;

	
	private static String keylist = "abcdefghijklmnopqrstuvwxyz123456789";
	
	public static String generatePassword(int length)
	{
	    String temp = "";
	    for (int i=0; i < length; i++)
	        temp += keylist.charAt((int)Math.floor(Math.random() * keylist.length()));
	    
        return temp;
	}
	
	public ServerDialog(InfoGlueInstaller infoglueInstaller)
	{
		this.infoglueInstaller = infoglueInstaller;
		
		this.setSize(450, 400);
		this.setLayout(null);
		this.setBackground(Color.white);
		JLabel introductionLabel = new JLabel(introductionHeader);
		introductionLabel.setBounds(xPosLabels, 0, 400, 30);
		introductionLabel.setFont(new java.awt.Font("Dialog", java.awt.Font.BOLD, 16));
		
		JTextArea textArea = new JTextArea(introductionMessage); 
		textArea.setEditable(false);
		textArea.setBounds(xPosLabels, 30, 400, 80);
		textArea.setWrapStyleWord(true);
		textArea.setLineWrap(true);
		
		//here comes all input fields
		JLabel appServerJLabel = new JLabel(applicationServerLabel);
		appServerJLabel.setBounds(xPosLabels, 120, 130, 20);
		appServerJLabel.setToolTipText("<html>The application server you wish to run InfoGlue on.</html>");
		this.applicationServer = new JComboBox();
		this.applicationServer.addActionListener(this);
		this.applicationServer.addItem("Tomcat 5.x");
		this.applicationServer.addItem("Tomcat 6.x");
		this.applicationServer.addItem("Tomcat 4.x");
		this.applicationServer.addItem("JBoss 4.0");
		this.applicationServer.setBounds(xPosValues, 120, xPosValuesWidth, 20);
		this.applicationServer.setBackground(new Color(230, 230, 245));
		HelpButton helpButton = new HelpButton(appServerJLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 120, 20, 20);
		this.add(helpButton);
		
		JLabel hostNameJLabel = new JLabel(hostNameLabel);
		hostNameJLabel.setBounds(xPosLabels, 140, 130, 20);
		hostNameJLabel.setToolTipText("<html>The hostname or IP-address of the application server you are installing InfoGlue on.<br>If you want people to access your site from other computers this is important to set correctly.</html>");
		this.hostName = new JTextField("localhost");
		this.hostName.setBounds(xPosValues, 140, xPosValuesWidth, 20);
		this.hostName.setBackground(new Color(230, 230, 245));
		helpButton = new HelpButton(hostNameJLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 140, 20, 20);
		this.add(helpButton);
		
		JLabel portNumberJLabel = new JLabel(portNumberLabel);
		portNumberJLabel.setBounds(xPosLabels, 160, 130, 20);
		portNumberJLabel.setToolTipText("<html>The port number tomcat operates on.</html>");
		this.portNumber = new JTextField("8080");
		this.portNumber.setBounds(xPosValues, 160, xPosValuesWidth, 20);
		this.portNumber.setBackground(new Color(230, 230, 245));
		helpButton = new HelpButton(portNumberJLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 160, 20, 20);
		this.add(helpButton);
		
		JLabel applicationSuffixJLabel = new JLabel(applicationSuffixLabel);
		applicationSuffixJLabel.setBounds(xPosLabels, 180, 130, 20);
		applicationSuffixJLabel.setToolTipText("<html>The suffix will be added to the name of the infoglue applications.<br>This feature is mostly used in shared environments like hosting services.<br>You can leave it out if this is a one-client installation.</html>");
		//this.applicationSuffix = new JTextField("");
		this.applicationSuffix = new JTextField("");
		this.applicationSuffix.setBounds(xPosValues, 180, xPosValuesWidth, 20);
		this.applicationSuffix.setBackground(new Color(230, 230, 245));
		helpButton = new HelpButton(applicationSuffixJLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 180, 20, 20);
		this.add(helpButton);
		
		JLabel appServerHomePathJLabel = new JLabel(applicationServerHomePathLabel);
		appServerHomePathJLabel.setBounds(xPosLabels, 200, 130, 20);
		appServerHomePathJLabel.setToolTipText("<html>Point out the home directory of your application server.<br>Often something like c:\\Program Files\\Apache Software Foundation\\Tomcat 5.5</html>");
		this.applicationServerHomePath = new JTextField(InfoGlueCommandLineInstaller.getTomcatHomePath());
		this.applicationServerHomePath.setName("applicationServerHomePath");
		this.applicationServerHomePath.setBounds(xPosValues, 200, xPosValuesWidth - 40, 20);
		this.applicationServerHomePath.setBackground(new Color(230, 230, 245));
		//java.awt.FileDialog openFileDialog = new java.awt.FileDialog(this);
		JButton browseButton = new BrowseButton("...", infoglueInstaller.installerSkeleton, applicationServerHomePath);
		browseButton.setBounds(xPosValues + xPosValuesWidth - 40, 200, 40, 20);
		helpButton = new HelpButton(appServerHomePathJLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 200, 20, 20);
		this.add(helpButton);
				
		/*
		JLabel tomcatVersionJLabel = new JLabel(tomcatVersionLabel);
		tomcatVersionJLabel.setBounds(xPosLabels, 220, 130, 20);
		tomcatVersionJLabel.setToolTipText("<html>Which version of tomcat do you run.</html>");
		this.tomcatVersion = new JComboBox();
		this.tomcatVersion.addItem("5");
		this.tomcatVersion.addItem("4");
		this.tomcatVersion.setBounds(xPosValues, 220, xPosValuesWidth - 40, 20);
		this.tomcatVersion.setBackground(new Color(230, 230, 245));
		helpButton = new HelpButton(tomcatVersionJLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 220, 20, 20);
		this.add(helpButton);
		*/
		
		JLabel applicationPathJLabel = new JLabel(applicationPathLabel);
		applicationPathJLabel.setBounds(xPosLabels, 220, 130, 20);
		applicationPathJLabel.setToolTipText("<html>Point out the home directory of your InfoGlue directory.<br>As InfoGlue will create a couple of applications/subdirectories you are wise<br>to create a common InfoGlue directory somewhere on the disc which you supply.</html>");
		this.applicationPath = new JTextField(InfoGlueCommandLineInstaller.getTomcatHomePath());
		this.applicationPath.setBounds(xPosValues, 220, xPosValuesWidth - 40, 20);
		this.applicationPath.setBackground(new Color(230, 230, 245));
        //java.awt.FileDialog openFileDialog = new java.awt.FileDialog(this);
		JButton browseButton2 = new BrowseButton("...", infoglueInstaller.installerSkeleton, applicationPath);
		browseButton2.setBounds(xPosValues + xPosValuesWidth - 40, 220, 40, 20);
		helpButton = new HelpButton(applicationPathJLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 220, 20, 20);
		this.add(helpButton);

		this.applicationPath.setText(this.applicationServerHomePath.getText() + File.separator + "webapps");
        this.applicationPath.setEditable(false);
        browseButton2.setEnabled(false);
        browseButton2.setVisible(false);
		
		JLabel enablePortalJLabel = new JLabel(enablePortalLabel);
		enablePortalJLabel.setBounds(xPosLabels, 240, 150, 20);
		enablePortalJLabel.setToolTipText("<html>Do you want to be able to use portlets in InfoGlue?<br>You can activate this later if you don't want it now.<html>");
		this.enablePortal = new JCheckBox("Yes (forces install under tomcat)");
		this.enablePortal.setBounds(xPosValues, 240, xPosValuesWidth, 20);
		this.enablePortal.setSelected(true);
		this.enablePortal.setEnabled(true);
		this.enablePortal.setBackground(Color.white);
		helpButton = new HelpButton(enablePortalJLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 240, 20, 20);
		this.add(helpButton);
		
		JLabel selectApplicationsLabel = new JLabel("Applications to install");
		selectApplicationsLabel.setBounds(xPosLabels, 280, 130, 20);
		selectApplicationsLabel.setToolTipText("<html>InfoGlue consists of several applications and two are mandatory.<br>You are also able to select if you wish to install a preview-deliver and a live-deliver.<br>The preview-deliver is used for preview at publication and the live site shows only<br>published data and are aimed to be the deliver used for the public. Both options are recommended.<html>");
		this.createCMS = new JCheckBox("InfoGlue CMS");
		this.createCMS.setBounds(xPosValues, 280, xPosValuesWidth, 20);
		this.createCMS.setSelected(true);
		//this.createCMS.setEnabled(false);
		this.createCMS.setBackground(Color.white);
		this.createDeliverWorking = new JCheckBox("InfoGlue Deliver Working");
		this.createDeliverWorking.setBounds(xPosValues, 300, xPosValuesWidth, 20);
		this.createDeliverWorking.setSelected(true);
		//this.createDeliverWorking.setEnabled(false);
		this.createDeliverWorking.setBackground(Color.white);
		this.createDeliverPreview = new JCheckBox("InfoGlue Deliver Preview");
		this.createDeliverPreview.setBounds(xPosValues, 320, xPosValuesWidth, 20);
		this.createDeliverPreview.setBackground(Color.white);
		this.createDeliverLive = new JCheckBox("InfoGlue Deliver Live");
		this.createDeliverLive.setBounds(xPosValues, 340, xPosValuesWidth, 20);
		this.createDeliverLive.setBackground(Color.white);
		helpButton = new HelpButton(selectApplicationsLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 280, 20, 20);
		this.add(helpButton);
		
		JLabel smtpHostNameJLabel = new JLabel(smtpHostNameLabel);
		smtpHostNameJLabel.setBounds(xPosLabels, 360, 130, 20);
		smtpHostNameJLabel.setToolTipText("<html>Your email server used for outgoing mail.</html>");
		this.smtpHostName = new JTextField("your.emailserver.com");
		this.smtpHostName.setBounds(xPosValues, 360, xPosValuesWidth, 20);
		this.smtpHostName.setBackground(new Color(230, 230, 245));
		helpButton = new HelpButton(smtpHostNameJLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 360, 20, 20);
		this.add(helpButton);

		/*
		JLabel digitalAssetPathJLabel = new JLabel(digitalAssetPathLabel);
		digitalAssetPathJLabel.setBounds(xPosLabels, 380, 130, 20);
		this.digitalAssetPath = new JTextField();
		this.digitalAssetPath.setBounds(xPosValues, 380, xPosValuesWidth, 20);
		*/
		
		JLabel superUserJLabel = new JLabel(superUserLabel);
		superUserJLabel.setBounds(xPosLabels, 400, 130, 20);
		superUserJLabel.setToolTipText("<html>State what user name should be used for super user access to the cms.</html>");
		this.superUserName = new JTextField("root");
		this.superUserName.setBounds(xPosValues, 400, xPosValuesWidth, 20);
		this.superUserName.setBackground(new Color(230, 230, 245));
		helpButton = new HelpButton(superUserJLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 400, 20, 20);
		this.add(helpButton);

		JLabel superUserPasswordJLabel = new JLabel(superUserPasswordLabel);
		superUserPasswordJLabel.setBounds(xPosLabels, 420, 130, 20);
		superUserPasswordJLabel.setToolTipText("<html>State what password the super user should use to access the cms.</html>");
		this.superUserPassword = new JTextField(generatePassword(6));
		this.superUserPassword.setBounds(xPosValues, 420, xPosValuesWidth, 20);
		this.superUserPassword.setBackground(new Color(230, 230, 245));
		helpButton = new HelpButton(superUserPasswordJLabel);
		helpButton.setBounds(xPosValues + xPosValuesWidth + 2, 420, 20, 20);
		this.add(helpButton);

		new PortletCheckboxListener(enablePortal, applicationPath, applicationServerHomePath, browseButton2);

		this.errorMessage = new JTextArea("");
		this.errorMessage.setForeground(Color.red);
		//this.errorMessage.setBackground(Color.yellow);
		this.errorMessage.setEditable(false);
		this.errorMessage.setBounds(xPosLabels, 440, 450, 60);
		this.errorMessage.setWrapStyleWord(true);
		this.errorMessage.setLineWrap(true);
		
		this.add(introductionLabel);
		this.add(textArea);
		this.add(appServerJLabel);
		this.add(applicationServer);
		
		this.add(hostNameJLabel);
		this.add(hostName);
		this.add(portNumberJLabel);
		this.add(portNumber);
		this.add(applicationSuffixJLabel);
		this.add(applicationSuffix);
		this.add(selectApplicationsLabel);
		this.add(createCMS);
		this.add(createDeliverWorking);
		this.add(createDeliverPreview);
		this.add(createDeliverLive);
		//this.add(digitalAssetPathJLabel);
		//this.add(digitalAssetPath);
		this.add(smtpHostNameJLabel);
		this.add(smtpHostName);
		this.add(appServerHomePathJLabel);
		this.add(applicationServerHomePath);
		//this.add(tomcatVersionJLabel);
		//this.add(tomcatVersion);
		this.add(enablePortalJLabel);
		this.add(enablePortal);
		this.add(applicationPathJLabel);
		this.add(applicationPath);
		this.add(browseButton);
		this.add(browseButton2);

		this.add(superUserJLabel);
		this.add(superUserName);
		this.add(superUserPasswordJLabel);
		this.add(superUserPassword);

		this.add(errorMessage);		
		
		infoglueInstaller.setBackButtonCommand("ShowDatabaseDialog");
		infoglueInstaller.setNextButtonCommand("ShowFinishDialog");
		infoglueInstaller.setNextButtonLabel("Next");
	}	
	
	public void actionPerformed(ActionEvent e)
	{
		if(e.getSource().equals(this.applicationServer))
        {
        	if(this.applicationPath != null)
        	{
        		if(this.getApplicationServer().startsWith("JBoss 4"))
        		{
        			this.applicationPath.setEditable(false);
        		}
        		else if(this.getApplicationServer().startsWith("Tomcat"))
        		{
        			if(this.getEnablePortal().equalsIgnoreCase("false"))
        			{	
        				this.applicationPath.setEditable(true);
        			}
        		}
        	}
        }
	}
	
	public void setErrorMessage(String errorMessage)
	{
		this.errorMessage.setText("An error made the installation stop: \n" + errorMessage);
	}
	
	public String getHostName()
	{
		return this.hostName.getText();
	}
	
	public String getPortNumber()
	{
		return this.portNumber.getText();
	}

	public String getApplicationSuffix()
	{
		return this.applicationSuffix.getText();
	}

	public String getDigitalAssetPath()
	{
		return this.digitalAssetPath.getText();
	}
	
	public String getSmtpHostName()
	{
		return this.smtpHostName.getText();
	}
	
	public String getApplicationServerHomePath()
	{
		return this.applicationServerHomePath.getText();
	}
	
	public void setApplicationServerHomePath(String applicationServerHomePath)
	{
		this.applicationServerHomePath.setText(applicationServerHomePath);
	}
	
	public void setApplicationPath(String applicationPath)
	{
		this.applicationPath.setText(applicationPath);
	}

	public String getApplicationServer()
	{
		return this.applicationServer.getSelectedItem().toString();
	}

	/*
	public String getTomcatVersion()
	{
		return this.tomcatVersion.getSelectedItem().toString();
	}
	*/
	
	public String getCreateCMS()
	{
		if(createCMS.isSelected())
			return "Yes";
		else
			return "No";
	}

	public String getCreateDeliverLive()
	{
		if(createDeliverLive.isSelected())
			return "Yes";
		else
			return "No";
	}

	public String getCreateDeliverPreview()
	{
		if(createDeliverPreview.isSelected())
			return "Yes";
		else
			return "No";
	}

	public String getCreateDeliverWorking()
	{
		if(createDeliverWorking.isSelected())
			return "Yes";
		else
			return "No";
	}

	public String getApplicationPath()
	{
		return applicationPath.getText();
	}

	public void paint(Graphics g) 
	{
	    Graphics2D g2 = (Graphics2D)g;
		g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

		super.paint(g);
	}

    public String getSuperUserName()
    {
        return superUserName.getText();
    }
    
    public String getSuperUserPassword()
    {
        return superUserPassword.getText();
    }

    public String getActionDispatcher()
    {
        if(this.enablePortal.isSelected())
            return "org.infoglue.deliver.portal.dispatcher.PortalServletDispatcher";
        else
            return "webwork.dispatcher.ServletDispatcher";
    }

    public String getEnablePortal()
    {
        if(this.enablePortal.isSelected())
            return "true";
        else
            return "false";
    }

}