/* ===============================================================================
 *
 * Part of the InfoGlue Content Management Platform (www.infoglue.org)
 *
 * ===============================================================================
 *
 *  Copyright (C)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2, as published by the
 * Free Software Foundation. See the file LICENSE.html for more information.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
 * Place, Suite 330 / Boston, MA 02111-1307 / USA.
 *
 * ===============================================================================
 */

package org.infoglue.cmsinstaller;

import javax.swing.*;
import java.awt.*;

/**
 * This is the main class for the installer.
 */

public class InstallingDialog extends JPanel
{
	private InfoGlueInstaller infoGlueInstaller = null;
	
	private final static String introductionHeader  = "Installing InfoGlue CMS";
	private final JTextArea textArea = new JTextArea("InfoGlue CMS is being installed. \n\n");
	
	public InstallingDialog(InfoGlueInstaller infoGlueInstaller)
	{
		this.infoGlueInstaller = infoGlueInstaller;
		
		this.setSize(450, 350);
		this.setLayout(null);
		this.setBackground(Color.white);
		
		JLabel introductionLabel = new JLabel(introductionHeader);
		introductionLabel.setBounds(0, 0, 400, 30);
		introductionLabel.setFont(new java.awt.Font("Dialog", java.awt.Font.BOLD, 16));
		
		textArea.setEditable(false);
		//textArea.setBackground(Color.lightGray);
		textArea.setBounds(0, 30, 400, 400);
		textArea.setWrapStyleWord(true);
		textArea.setLineWrap(true);
		
		this.add(introductionLabel);
		this.add(textArea);
		
		infoGlueInstaller.installerSkeleton.backButton.hide();
		infoGlueInstaller.installerSkeleton.nextButton.hide();
	}
		
	public void paint(Graphics g) 
	{
	    Graphics2D g2 = (Graphics2D)g;
		g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

		super.paint(g);
	}
	
    public JTextArea getTextArea()
    {
        return textArea;
    }
}