/* ===============================================================================
 *
 * Part of the InfoGlue Content Management Platform (www.infoglue.org)
 *
 * ===============================================================================
 *
 *  Copyright (C)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2, as published by the
 * Free Software Foundation. See the file LICENSE.html for more information.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
 * Place, Suite 330 / Boston, MA 02111-1307 / USA.
 *
 * ===============================================================================
 */

package org.infoglue.cmsinstaller;
import javax.swing.*;
import java.awt.*;

/**
 * This is the main class for the installer.
 */

public class InstallerSkeleton extends JFrame
{
	private InfoGlueInstaller infoglueInstaller = null;

	public IntroductionDialog introductionDialog = null;
	public DatabaseDialog databaseDialog         = null;
	public ServerDialog serverDialog             = null;
	public FinishDialog finishDialog             = null;
	public InstallingDialog installingDialog     = null;
	public DoneDialog doneDialog                 = null;
	
	protected JButton backButton = null;
	protected JButton nextButton = null;
	protected String previousPanel = "";
	private int mainXStart  = 205;
	private int mainXWidth  = 422;
	private int mainYStart  = 5;
	private int mainYHeight = 520;
	
	public InstallerSkeleton(InfoGlueInstaller infoglueInstaller)
	{
		this.infoglueInstaller = infoglueInstaller;
		
		this.setDefaultCloseOperation(EXIT_ON_CLOSE);
		
		this.setSize(640, 590);
		this.getContentPane().setLayout(null);
		this.getContentPane().setBackground(Color.WHITE);
		this.setResizable(false);
		
		ImagePanel imagePanel = new ImagePanel();
		imagePanel.setBounds(0, 0, 400, 590);
		imagePanel.setBackground(Color.BLACK);

		JPanel linePanel = new JPanel();
		linePanel.setBounds(0, 522, 640, 2);
		linePanel.setBackground(Color.BLACK);
		
		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(null);
		buttonPanel.setBounds(0, 524, 640, 40);
		buttonPanel.setBackground(new Color(212, 208, 200));

		backButton = new JButton("<< Back");
		backButton.setBounds(400, 7, 100, 24);
		backButton.setBackground(new Color(212, 208, 200));
		//nextButton.addMouseListener(new InstallerMouseAdapter(infoglueInstaller));
		backButton.addActionListener(new InstallerMouseAdapter(infoglueInstaller));
		buttonPanel.add(backButton);

		nextButton = new JButton("Next >>");
		nextButton.setBounds(500, 7, 100, 24);
		nextButton.setBackground(new Color(212, 208, 200));
		//nextButton.addMouseListener(new InstallerMouseAdapter(infoglueInstaller));
		nextButton.addActionListener(new InstallerMouseAdapter(infoglueInstaller));
		buttonPanel.add(nextButton);
				
		this.getContentPane().add(imagePanel);
		this.getContentPane().add(linePanel);
		this.getContentPane().add(buttonPanel);
	}
		
	
	public void showIntroductionDialog()
	{
		if(introductionDialog == null)
		    introductionDialog = new IntroductionDialog(this.infoglueInstaller);
		introductionDialog.setBounds(mainXStart, mainYStart, mainXWidth, mainYHeight);
		
		infoglueInstaller.setBackButtonCommand("");
		infoglueInstaller.setNextButtonCommand("ShowDatabaseDialog");
		
		//System.out.println("this.getPreviousPanel():" + this.getPreviousPanel());
		if(this.getPreviousPanel().equalsIgnoreCase("databaseDialog"))
		    this.getContentPane().remove(databaseDialog);
		this.setPreviousPanel("");
		this.backButton.hide();
		
		this.getContentPane().add(introductionDialog);
		this.getContentPane().repaint();
	}

	public void showDatabaseServerDialog()
	{
		if(databaseDialog == null)
		    databaseDialog = new DatabaseDialog(this.infoglueInstaller);
		databaseDialog.setBounds(mainXStart, mainYStart, mainXWidth, mainYHeight);
		
		infoglueInstaller.setBackButtonCommand("ShowIntroductionDialog");
		infoglueInstaller.setNextButtonCommand("ShowServerDialog");
		
		if(this.getPreviousPanel().equalsIgnoreCase("serverDialog"))
		    this.getContentPane().remove(serverDialog);
		else
			this.getContentPane().remove(introductionDialog);
		this.setPreviousPanel("databaseDialog");
		this.backButton.show();
		
		this.getContentPane().add(databaseDialog);
		this.getContentPane().repaint();
	}

	public void showServerDialog()
	{
		if(serverDialog == null)
		    serverDialog = new ServerDialog(this.infoglueInstaller);
		serverDialog.setBounds(mainXStart, mainYStart, mainXWidth, mainYHeight);
			
		infoglueInstaller.setBackButtonCommand("ShowDatabaseDialog");
		infoglueInstaller.setNextButtonCommand("ShowFinishDialog");

		if(this.getPreviousPanel().equalsIgnoreCase("finishDialog"))
		    this.getContentPane().remove(finishDialog);
		else
		    this.getContentPane().remove(databaseDialog);
		this.setPreviousPanel("serverDialog");
		this.nextButton.setLabel("Next");
		
		this.getContentPane().add(serverDialog);
		this.getContentPane().repaint();
	}
	
	public void showFinishDialog()
	{
		finishDialog = new FinishDialog(this.infoglueInstaller);
		finishDialog.setBounds(mainXStart, mainYStart, mainXWidth, mainYHeight);
		
		infoglueInstaller.setBackButtonCommand("ShowServerDialog");
		infoglueInstaller.setNextButtonCommand("ShowDOneDialog");

		this.setPreviousPanel("finishDialog");
		this.nextButton.setLabel("Finish");
		
		this.getContentPane().remove(serverDialog);
		this.getContentPane().add(finishDialog);
		this.getContentPane().repaint();
	}

	public void showInstallingDialog()
	{
		installingDialog = new InstallingDialog(this.infoglueInstaller);
		installingDialog.setBounds(mainXStart, mainYStart, mainXWidth, mainYHeight);
		this.getContentPane().remove(finishDialog);
		this.getContentPane().add(installingDialog);
		this.getContentPane().repaint();
	}

	public void showDoneDialog()
	{
		doneDialog = new DoneDialog(this.infoglueInstaller);
		doneDialog.setBounds(mainXStart, mainYStart, mainXWidth, mainYHeight);
		this.getContentPane().remove(installingDialog);
		this.getContentPane().add(doneDialog);
		this.getContentPane().repaint();
	}

    public String getPreviousPanel()
    {
        return previousPanel;
    }
    public void setPreviousPanel(String previousPanel)
    {
        this.previousPanel = previousPanel;
    }
}