/* ===============================================================================
 *
 * Part of the InfoGlue Content Management Platform (www.infoglue.org)
 *
 * ===============================================================================
 *
 *  Copyright (C)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2, as published by the
 * Free Software Foundation. See the file LICENSE.html for more information.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
 * Place, Suite 330 / Boston, MA 02111-1307 / USA.
 *
 * ===============================================================================
 */

package org.infoglue.cmsinstaller;

import java.awt.event.*;
import java.io.*;

public class InstallerMouseAdapter implements ActionListener //MouseAdapter
{
	private InfoGlueInstaller infoglueInstaller = null;
	
	public InstallerMouseAdapter(InfoGlueInstaller infoglueInstaller)
	{
		this.infoglueInstaller = infoglueInstaller;
	}	

	//public void mouseClicked(MouseEvent e)
	public void actionPerformed(ActionEvent e)
	{
		//String actionCommand = ((JButton)e.getComponent()).getActionCommand();
		String actionCommand = e.getActionCommand();
		
		if(actionCommand.equalsIgnoreCase("ShowIntroductionDialog"))
		{
			this.infoglueInstaller.installerSkeleton.showIntroductionDialog();
		}
		else if(actionCommand.equalsIgnoreCase("ShowDatabaseDialog"))
		{
			this.infoglueInstaller.installerSkeleton.showDatabaseServerDialog();
		}
		else if(actionCommand.equalsIgnoreCase("ShowServerDialog"))
		{
			try
			{
				//this.infoglueInstaller.setupDatabaseEnvironment();
				this.infoglueInstaller.checkDatabase();
				
				this.infoglueInstaller.installerSkeleton.showServerDialog();
			}
			catch(Exception exception)
			{
				this.infoglueInstaller.installerSkeleton.databaseDialog.setErrorMessage(exception.getMessage());
				this.infoglueInstaller.logProgress("An error occurred:" + exception.getMessage());
				exception.printStackTrace();
			}
		}
		else if(actionCommand.equalsIgnoreCase("ShowFinishDialog"))
		{
			try
			{
				if(this.infoglueInstaller.installerSkeleton.serverDialog.getApplicationServer().startsWith("Tomcat"))
				{
					File tomcatHome = new File(this.infoglueInstaller.installerSkeleton.serverDialog.getApplicationServerHomePath());
					File tomcatWebbappsHome = new File(this.infoglueInstaller.installerSkeleton.serverDialog.getApplicationServerHomePath() + File.separator + "webapps");
					if(!tomcatHome.exists() || !tomcatHome.isDirectory() || !tomcatWebbappsHome.exists())
						throw new Exception("The directory you selected as tomcat home is not valid.");
						
					File applicationHome = new File(this.infoglueInstaller.installerSkeleton.serverDialog.getApplicationPath());
					if(!applicationHome.exists() || !applicationHome.isDirectory())
						throw new Exception("The directory you selected as application home is not valid.");
				}
				else if(this.infoglueInstaller.installerSkeleton.serverDialog.getApplicationServer().startsWith("JBoss"))
				{
					File jBossHome = new File(this.infoglueInstaller.installerSkeleton.serverDialog.getApplicationServerHomePath());
					File jBossDeployHome = new File(this.infoglueInstaller.installerSkeleton.serverDialog.getApplicationServerHomePath() + File.separator + "server" + File.separator + "default" + File.separator + "deploy");
					if(!jBossHome.exists() || !jBossHome.isDirectory() || !jBossDeployHome.exists())
						throw new Exception("The directory you selected as jboss home is not valid.");
				}
				
				//this.infoglueInstaller.setupPropertyFiles();
				this.infoglueInstaller.installerSkeleton.showFinishDialog();
			}
			catch(Exception exception)
			{
				this.infoglueInstaller.installerSkeleton.serverDialog.setErrorMessage(exception.getMessage());
				this.infoglueInstaller.logProgress("An error occurred:" + exception.getMessage());
				exception.printStackTrace();
			}
		}
		else if(actionCommand.equalsIgnoreCase("ShowDoneDialog"))
		{
			try
			{
				this.infoglueInstaller.installerSkeleton.showInstallingDialog();
				//this.infoglueInstaller.finishInstallation();
				//this.infoglueInstaller.installerSkeleton.showDoneDialog();
				Thread t = new Thread(new FinishThread(this.infoglueInstaller));
		        t.start();
			}
			catch(Exception exception)
			{
				this.infoglueInstaller.installerSkeleton.finishDialog.setErrorMessage(exception.getMessage());
				this.infoglueInstaller.logProgress("An error occurred:" + exception.getMessage());
				exception.printStackTrace();
			}
		}
		else if(actionCommand.equalsIgnoreCase("Exit"))
		{
			Logger.logInfo("Exiting application");
			System.exit(0);
		}
			
	} 

}

class FinishThread implements Runnable
{
    private InfoGlueInstaller infoglueInstaller = null;
    
    public FinishThread(InfoGlueInstaller infoglueInstaller)
    {
        this.infoglueInstaller = infoglueInstaller;   
    }
    
    public void run() 
    {
        try
		{
			this.infoglueInstaller.finishInstallation();
			this.infoglueInstaller.installerSkeleton.showDoneDialog();
		}
		catch(Exception exception)
		{
			this.infoglueInstaller.installerSkeleton.finishDialog.setErrorMessage(exception.getMessage());
			this.infoglueInstaller.logProgress("An error occurred:" + exception.getMessage());
			exception.printStackTrace();
		}
    }
    
}
