/* ===============================================================================
 *
 * Part of the InfoGlue Content Management Platform (www.infoglue.org)
 *
 * ===============================================================================
 *
 *  Copyright (C)
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License version 2, as published by the
 * Free Software Foundation. See the file LICENSE.html for more information.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
 * Place, Suite 330 / Boston, MA 02111-1307 / USA.
 *
 * ===============================================================================
 */

package org.infoglue.cmsinstaller;

import javax.swing.*;
import java.awt.event.*;
import java.io.File;

public class BrowseButton extends JButton
{
	private InstallerSkeleton installerSkeleton = null;
	private JFileChooser openFileDialog = null;
	private JTextField field = null;
		
	public BrowseButton(String label, InstallerSkeleton installerSkeleton, JTextField field)
	{
		super(label);
		this.installerSkeleton = installerSkeleton;
		this.field = field;
		this.addMouseListener(new BrowseMouseAdapter());
	}
	
	public String getPath()
	{
		return this.openFileDialog.getSelectedFile().getPath();
	}
	
	public class BrowseMouseAdapter extends MouseAdapter
	{	
		public void mouseClicked(MouseEvent e)
		{
			openFileDialog = new JFileChooser();	
			openFileDialog.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			openFileDialog.setVisible(true);
			openFileDialog.showOpenDialog(installerSkeleton);
			field.setText(openFileDialog.getSelectedFile().getPath());
			//installerSkeleton.serverDialog.setTomcatHomePath(openFileDialog.getSelectedFile().getPath());
			
			if(field.getName() != null && field.getName().equals("applicationServerHomePath") && installerSkeleton.serverDialog.getEnablePortal().equals("true"))
			{
				installerSkeleton.serverDialog.setApplicationPath(field.getText() + File.separator + "webapps");
			}
		} 
	}
}