-- ===============================================================================
--
-- Part of the InfoGlue Content Management Platform (www.infoglue.org)
--
-- ===============================================================================
--
--  Copyright (C)
--
-- This program is free software; you can redistribute it and/or modify it under
-- the terms of the GNU General Public License version 2, as published by the
-- Free Software Foundation. See the file LICENSE.html for more information.
--
-- This program is distributed in the hope that it will be useful, but WITHOUT
-- ANY WARRANTY, including the implied warranty of MERCHANTABILITY or FITNESS
-- FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- this program; if not, write to the Free Software Foundation, Inc. / 59 Temple
-- Place, Suite 330 / Boston, MA 02111-1307 / USA.
--
-- ===============================================================================
--
-- $Id: update-db-2.8-to-2.9.sql,v 1.1 2008/07/03 15:35:20 mattias Exp $
--
-- This script contains the database updates required to go from 2.8 to 2.9.

DROP SEQUENCE cmFormEntry_seq;

CREATE SEQUENCE cmFormEntry_seq START WITH 100 INCREMENT BY 1;

DROP TABLE cmFormEntry;

CREATE TABLE cmFormEntry
(
	id					number NOT NULL,
	originAddress		VARCHAR2(1024) NOT NULL,
	formName			VARCHAR2(255) NOT NULL,
	formContentId		number NOT NULL,
	userIP				VARCHAR2(20) NOT NULL,
	userAgent			VARCHAR2(1024) NOT NULL,
	PRIMARY KEY (id)
);


DROP SEQUENCE cmFormEntryValue_seq;

CREATE SEQUENCE cmFormEntryValue_seq START WITH 100 INCREMENT BY 1;

DROP TABLE cmFormEntryValue;

CREATE TABLE cmFormEntryValue
(
	id			number NOT NULL,
	name		VARCHAR2(128) NOT NULL,
	value		VARCHAR2(4000) NOT NULL,
	formEntryId	number NOT NULL,
	PRIMARY KEY (id)
);


DROP SEQUENCE cmSubscription_seq;

CREATE SEQUENCE cmSubscription_seq START WITH 100 INCREMENT BY 1;

DROP TABLE cmSubscription;

CREATE TABLE cmSubscription
(
	id						number NOT NULL,
	interceptionPointId		number NOT NULL,
	name					VARCHAR2(100) NOT NULL,
	isGlobal				number default 0 NOT NULL,
	entityName				VARCHAR2(100),
	entityId				VARCHAR2(200),
	userName				VARCHAR2(150) NOT NULL,
	userEmail				VARCHAR2(150),
	lastNotifiedDateTime	date default sysdate,
	PRIMARY KEY (id)
);



DROP SEQUENCE cmSubscriptionFilter_seq;

CREATE SEQUENCE cmSubscriptionFilter_seq START WITH 100 INCREMENT BY 1;

DROP TABLE cmSubscriptionFilter;

CREATE TABLE cmSubscriptionFilter
(
	id						number NOT NULL,
	subscriptionId			number NOT NULL,
	filterType				VARCHAR2(50) NOT NULL,
	filterCondition			VARCHAR2(255) NOT NULL,
	isAndCondition			number default 0 NOT NULL,
	PRIMARY KEY (id)
);