/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.exolab.castor.jdo.DbMetaInfo;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.Query;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.QueryResults;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.jdo.engine.DatabaseImpl;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLTypes;
import org.exolab.castor.jdo.engine.SimpleQueryExecutor;
import org.exolab.castor.jdo.oql.Lexer;
import org.exolab.castor.jdo.oql.ParamInfo;
import org.exolab.castor.jdo.oql.ParseTreeNode;
import org.exolab.castor.jdo.oql.ParseTreeWalker;
import org.exolab.castor.jdo.oql.Parser;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.persist.spi.QueryExpression;
import org.exolab.castor.util.Messages;

public class OQLQueryImpl
implements Query,
OQLQuery {
    private LockEngine _dbEngine;
    private DatabaseImpl _dbImpl;
    private Class _objClass;
    private JDOClassDescriptor _clsDesc;
    private QueryExpression _expr;
    private String _spCall;
    private Class[] _bindTypes;
    private Object[] _bindValues;
    private Hashtable _paramInfo;
    private int _fieldNum;
    private int _projectionType;
    private Vector _pathInfo;
    private PersistenceQuery _query;
    private QueryResults _results;
    static /* synthetic */ Class class$java$lang$Object;

    OQLQueryImpl(DatabaseImpl dbImpl) {
        this._dbImpl = dbImpl;
    }

    public void bind(Object value) {
        if (this._expr == null && this._spCall == null) {
            throw new IllegalStateException("Must create query before using it");
        }
        if (this._fieldNum == this._paramInfo.size()) {
            throw new IllegalArgumentException("Only " + this._paramInfo.size() + " fields in this query");
        }
        ParamInfo info = (ParamInfo)this._paramInfo.get(new Integer(this._fieldNum + 1));
        Class paramClass = info.getTheClass();
        Class fieldClass = info.getFieldType();
        Class sqlClass = info.getSQLType();
        if (value != null) {
            Class<?> valueClass = value.getClass();
            if (paramClass.isAssignableFrom(valueClass)) {
                ClassMolder molder = this._dbImpl.getLockEngine().getClassMolder(valueClass);
                if (molder != null) {
                    value = molder.getActualIdentity(this._dbImpl.getClassLoader(), value);
                }
            } else if (info.isUserDefined()) {
                throw new IllegalArgumentException("Query paramter " + (this._fieldNum + 1) + " is not of the expected type " + paramClass + " it is an instance of the class " + valueClass);
            }
            if (sqlClass != null && !sqlClass.isAssignableFrom(valueClass)) {
                if (fieldClass != valueClass) {
                    try {
                        TypeConvertor tc = SQLTypes.getConvertor(valueClass, fieldClass);
                        value = tc.convert(value, null);
                    }
                    catch (MappingException e) {
                        throw new IllegalArgumentException("Query parameter " + (this._fieldNum + 1) + " cannot be converted from " + valueClass + " to " + paramClass + ", because no convertor can be found.");
                    }
                }
                if (info.getConvertor() != null) {
                    value = info.getConvertor().convert(value, info.getConvertorParam());
                }
            }
        }
        if (this._bindValues == null) {
            this._bindValues = new Object[this._bindTypes.length];
        }
        this._bindValues[this._fieldNum++] = value;
    }

    public void bind(boolean value) {
        this.bind(new Boolean(value));
    }

    public void bind(short value) {
        this.bind(new Short(value));
    }

    public void bind(int value) {
        this.bind(new Integer(value));
    }

    public void bind(long value) {
        this.bind(new Long(value));
    }

    public void bind(float value) {
        this.bind(new Float(value));
    }

    public void bind(double value) {
        this.bind(new Double(value));
    }

    public void create(String oql) throws PersistenceException {
        this._fieldNum = 0;
        this._expr = null;
        this._spCall = null;
        if (oql.startsWith("CALL ")) {
            this.createCall(oql);
            return;
        }
        Lexer lexer = new Lexer(oql);
        Parser parser = new Parser(lexer);
        ParseTreeNode parseTree = parser.getParseTree();
        this._dbEngine = this._dbImpl.getLockEngine();
        if (this._dbEngine == null) {
            throw new QueryException("Could not get a persistence engine");
        }
        TransactionContext trans = this._dbImpl.getTransaction();
        DbMetaInfo dbInfo = trans.getConnectionInfo(this._dbEngine);
        ParseTreeWalker walker = new ParseTreeWalker(this._dbEngine, parseTree, this._dbImpl.getClassLoader(), dbInfo);
        this._objClass = walker.getObjClass();
        this._clsDesc = walker.getClassDescriptor();
        this._expr = walker.getQueryExpression();
        this._paramInfo = walker.getParamInfo();
        this._projectionType = walker.getProjectionType();
        this._pathInfo = walker.getPathInfo();
        this._bindTypes = new Class[this._paramInfo.size()];
        int paramIndex = 0;
        Enumeration e = this._paramInfo.elements();
        while (e.hasMoreElements()) {
            ParamInfo info = (ParamInfo)e.nextElement();
            this._bindTypes[paramIndex++] = info.getSQLType() == null ? info.getTheClass() : info.getSQLType();
        }
    }

    public void createCall(String oql) throws QueryException {
        int i;
        Integer paramNo;
        ParamInfo info;
        StringBuffer sb;
        if (!oql.startsWith("CALL ")) {
            throw new QueryException("Stored procedure call must start with CALL");
        }
        int as = oql.lastIndexOf(" AS ");
        if (as < 0) {
            throw new QueryException("Stored procedure call must end with \"AS <class-name>\"");
        }
        int leftParen = oql.indexOf("(");
        int rightParen = oql.indexOf(")");
        StringBuffer sql = new StringBuffer();
        int paramCnt = 0;
        this._paramInfo = new Hashtable();
        if (oql.startsWith("CALL SQL")) {
            int startOff = oql.toUpperCase().indexOf("WHERE ");
            if (startOff >= 0) {
                sql.append(oql.substring(5, startOff += 6));
                for (int i2 = startOff; i2 < as; ++i2) {
                    if (oql.charAt(i2) == '$') {
                        sb = new StringBuffer();
                        boolean didParam = false;
                        for (int j = i2 + 1; j < as; ++j) {
                            char c = oql.charAt(j);
                            if (!Character.isDigit(c)) {
                                didParam = true;
                                sql.append("?");
                                break;
                            }
                            sb.append(c);
                        }
                        if (!didParam) {
                            sql.append('?');
                        }
                        if ((info = (ParamInfo)this._paramInfo.get(paramNo = sb.length() > 0 ? Integer.valueOf(sb.toString()) : new Integer(paramCnt + 1))) == null) {
                            info = new ParamInfo("", "java.lang.Object", null, this._dbImpl.getClassLoader());
                        }
                        this._paramInfo.put(paramNo, info);
                        ++paramCnt;
                        i2 += sb.length();
                        continue;
                    }
                    sql.append(oql.charAt(i2));
                }
            } else {
                sql.append(oql.substring(5, as));
            }
        } else if (leftParen < 0 && rightParen < 0) {
            sql.append(oql.substring(5, as));
        } else {
            if (leftParen < 0 && rightParen >= 0 || leftParen > rightParen) {
                throw new QueryException("Syntax error: parenthesis");
            }
            sql.append(oql.substring(5, leftParen));
            sql.append('(');
            for (i = leftParen + 1; i < rightParen; ++i) {
                char c;
                if (oql.charAt(i) != '$') continue;
                sb = new StringBuffer();
                for (int j = i + 1; j < rightParen && (c = oql.charAt(j)) >= '0' && c <= '9'; ++j) {
                    sb.append(c);
                }
                paramNo = sb.length() > 0 ? Integer.valueOf(sb.toString()) : new Integer(paramCnt + 1);
                info = (ParamInfo)this._paramInfo.get(paramNo);
                if (info == null) {
                    info = new ParamInfo("", "java.lang.Object", null, this._dbImpl.getClassLoader());
                }
                this._paramInfo.put(paramNo, info);
                ++paramCnt;
            }
            for (i = 0; i < paramCnt; ++i) {
                sql.append('?');
                if (i >= paramCnt - 1) continue;
                sql.append(',');
            }
            sql.append(')');
        }
        this._spCall = sql.toString();
        this._projectionType = 3;
        this._bindTypes = new Class[paramCnt];
        for (i = 0; i < paramCnt; ++i) {
            this._bindTypes[i] = class$java$lang$Object == null ? OQLQueryImpl.class$("java.lang.Object") : class$java$lang$Object;
        }
        String objType = oql.substring(as + 4).trim();
        if (objType.length() == 0) {
            throw new QueryException("Missing object name");
        }
        try {
            this._objClass = this._dbImpl.getClassLoader() == null ? Class.forName(objType) : this._dbImpl.getClassLoader().loadClass(objType);
        }
        catch (ClassNotFoundException except) {
            throw new QueryException("Could not find class " + objType);
        }
        this._dbEngine = this._dbImpl.getLockEngine();
        if (this._dbEngine == null || this._dbEngine.getPersistence(this._objClass) == null) {
            throw new QueryException("Could not find an engine supporting class " + objType);
        }
    }

    public QueryResults execute() throws QueryException, PersistenceException, TransactionNotInProgressException {
        return this.execute(null);
    }

    public QueryResults execute(boolean scrollable) throws QueryException, PersistenceException, TransactionNotInProgressException {
        return this.execute(null, scrollable);
    }

    public QueryResults execute(short accessMode) throws QueryException, PersistenceException, TransactionNotInProgressException {
        return this.execute(accessMode, false);
    }

    public QueryResults execute(short accessMode, boolean scrollable) throws QueryException, PersistenceException, TransactionNotInProgressException {
        switch (accessMode) {
            case 0: {
                return this.execute(AccessMode.ReadOnly, scrollable);
            }
            case 1: {
                return this.execute(AccessMode.Shared, scrollable);
            }
            case 2: {
                return this.execute(AccessMode.Exclusive, scrollable);
            }
            case 3: {
                return this.execute(AccessMode.DbLocked, scrollable);
            }
        }
        throw new IllegalArgumentException("Value for 'accessMode' is invalid");
    }

    private QueryResults execute(AccessMode accessMode) throws QueryException, PersistenceException, TransactionNotInProgressException {
        return this.execute(accessMode, false);
    }

    private QueryResults execute(AccessMode accessMode, boolean scrollable) throws QueryException, PersistenceException, TransactionNotInProgressException {
        if (this._expr == null && this._spCall == null) {
            throw new IllegalStateException("Must create query before using it");
        }
        if (this._results != null) {
            this._results.close();
        }
        switch (this._projectionType) {
            case 3: 
            case 4: 
            case 5: {
                try {
                    SQLEngine engine = (SQLEngine)this._dbEngine.getPersistence(this._objClass);
                    this._query = this._expr != null ? engine.createQuery(this._expr, this._bindTypes, accessMode) : engine.createCall(this._spCall, this._bindTypes);
                    if (this._bindValues != null) {
                        for (int i = 0; i < this._bindValues.length; ++i) {
                            this._query.setParameter(i, this._bindValues[i]);
                        }
                    }
                }
                catch (QueryException except) {
                    throw new QueryException(except.getMessage());
                }
                org.exolab.castor.persist.QueryResults results = this._dbImpl.getTransaction().query(this._dbEngine, this._query, accessMode, scrollable);
                this._fieldNum = 0;
                if (this._projectionType == 3) {
                    this._results = new OQLEnumeration(results);
                    break;
                }
                this._results = new OQLEnumeration(results, this._pathInfo, this._clsDesc);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                try {
                    Connection conn = (Connection)this._dbImpl.getTransaction().getConnection(this._dbEngine);
                    SimpleQueryExecutor sqe = new SimpleQueryExecutor(this._dbImpl);
                    this._results = sqe.execute(conn, this._expr, this._bindValues);
                }
                catch (QueryException except) {
                    throw new QueryException(Messages.message("persist.simple.query.failed"), except);
                }
                this._fieldNum = 0;
            }
        }
        return this._results;
    }

    public String getSQL() throws QueryException {
        if (this._expr != null) {
            return this._expr.getStatement(true);
        }
        return this._spCall;
    }

    public void close() {
        if (this._query != null) {
            this._query.close();
            this._query = null;
        }
        if (this._results != null) {
            this._results.close();
            this._results = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class OQLEnumeration
    implements QueryResults,
    Enumeration {
        private Object _lastObject;
        private Vector _pathInfo;
        private JDOClassDescriptor _classDescriptor;
        private org.exolab.castor.persist.QueryResults _results;

        OQLEnumeration(org.exolab.castor.persist.QueryResults results, Vector pathInfo, JDOClassDescriptor clsDesc) {
            this._results = results;
            this._pathInfo = pathInfo;
            this._classDescriptor = clsDesc;
        }

        OQLEnumeration(org.exolab.castor.persist.QueryResults results) {
            this._results = results;
            this._pathInfo = null;
            this._classDescriptor = null;
        }

        public boolean absolute(int row) throws PersistenceException {
            return this._results.absolute(row);
        }

        public int size() throws PersistenceException {
            return this._results.size();
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore(true);
            }
            catch (PersistenceException except) {
                return false;
            }
        }

        public boolean hasMore() throws PersistenceException {
            return this.hasMore(false);
        }

        public boolean hasMore(boolean skipError) throws PersistenceException {
            block9: {
                if (this._lastObject != null) {
                    return true;
                }
                if (this._results == null) {
                    return false;
                }
                try {
                    Object identity = this._results.nextIdentity();
                    while (identity != null) {
                        try {
                            this._lastObject = this._results.fetch();
                            if (this._lastObject == null) continue;
                            break;
                        }
                        catch (ObjectNotFoundException except) {
                            identity = this._results.nextIdentity();
                        }
                        catch (PersistenceException except) {
                            identity = this._results.nextIdentity();
                            if (skipError) continue;
                            throw except;
                        }
                    }
                    if (identity == null) {
                        this._results.close();
                        this._results = null;
                    }
                }
                catch (PersistenceException except) {
                    this._results.close();
                    this._results = null;
                    if (skipError) break block9;
                    throw except;
                }
            }
            return this._lastObject != null;
        }

        public Object nextElement() throws NoSuchElementException {
            try {
                return this.next(true);
            }
            catch (PersistenceException except) {
                return null;
            }
        }

        public Object next() throws PersistenceException, NoSuchElementException {
            return this.next(false);
        }

        private Object next(boolean skipError) throws PersistenceException, NoSuchElementException {
            block13: {
                if (this._lastObject != null) {
                    Object result = this._lastObject;
                    this._lastObject = null;
                    if (this._pathInfo == null) {
                        return result;
                    }
                    return this.followPath(result);
                }
                if (this._results == null) {
                    throw new NoSuchElementException();
                }
                try {
                    Object identity = this._results.nextIdentity();
                    while (identity != null) {
                        block12: {
                            try {
                                Object result = this._results.fetch();
                                if (result != null) {
                                    if (this._pathInfo == null) {
                                        return result;
                                    }
                                    return this.followPath(result);
                                }
                            }
                            catch (ObjectNotFoundException except) {
                            }
                            catch (PersistenceException except) {
                                if (skipError) break block12;
                                throw except;
                            }
                        }
                        identity = this._results.nextIdentity();
                    }
                    if (identity == null) {
                        this._results.close();
                        this._results = null;
                    }
                }
                catch (PersistenceException except) {
                    this._results.close();
                    this._results = null;
                    if (skipError) break block13;
                    throw except;
                }
            }
            throw new NoSuchElementException();
        }

        public void close() {
            if (this._results != null) {
                this._results.close();
                this._results = null;
            }
        }

        private Object followPath(Object parent) {
            JDOClassDescriptor curClassDesc = this._classDescriptor;
            Object curObject = parent;
            for (int i = 1; i < this._pathInfo.size(); ++i) {
                String curFieldName = (String)this._pathInfo.elementAt(i);
                try {
                    JDOFieldDescriptor curFieldDesc = curClassDesc.getField(curFieldName);
                    FieldHandler handler = curFieldDesc.getHandler();
                    curObject = handler.getValue(curObject);
                    curClassDesc = (JDOClassDescriptor)curFieldDesc.getClassDescriptor();
                    continue;
                }
                catch (Exception ex) {
                    throw new NoSuchElementException("An exception was thrown trying to access get methods to follow the path expression. " + ex.toString());
                }
            }
            return curObject;
        }
    }
}

