/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.util.Enumeration;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.ClassInfoResolver;
import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.SGTypes;
import org.exolab.castor.builder.binding.XMLBindingComponent;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.simpletypes.ListType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public class MemberFactory {
    private FieldInfoFactory _infoFactory = null;
    private BuilderConfiguration _config = null;

    public MemberFactory(BuilderConfiguration config) {
        this(config, new FieldInfoFactory());
    }

    public MemberFactory(BuilderConfiguration config, FieldInfoFactory infoFactory) {
        if (config == null) {
            String err = "The 'BuilderConfiguration' argument must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._config = config;
        this._infoFactory = infoFactory == null ? new FieldInfoFactory() : infoFactory;
        if (this._config.generateExtraCollectionMethods()) {
            this._infoFactory.setCreateExtraMethods(true);
        }
        String suffix = this._config.getProperty("org.exolab.castor.builder.collections.reference.suffix", null);
        this._infoFactory.setReferenceMethodSuffix(suffix);
        if (this._config.boundPropertiesEnabled()) {
            this._infoFactory.setBoundProperties(true);
        }
    }

    public FieldInfo createFieldInfoForAny(Wildcard any) {
        String nsURI;
        if (any == null) {
            return null;
        }
        if (any.isAttributeWildcard()) {
            return null;
        }
        XSClass xsType = new XSClass(SGTypes.Object, "any");
        String vName = "_anyObject";
        String xmlName = null;
        FieldInfo result = null;
        if (any.getMaxOccurs() > 1 || any.getMaxOccurs() < 0) {
            result = this._infoFactory.createCollection(xsType, vName, "anyObject");
            XSList xsList = ((CollectionInfo)result).getXSList();
            xsList.setMinimumSize(any.getMinOccurs());
            xsList.setMaximumSize(any.getMaxOccurs());
        } else {
            result = this._infoFactory.createFieldInfo(xsType, vName);
        }
        if (any.getMinOccurs() > 0) {
            result.setRequired(true);
        } else {
            result.setRequired(false);
        }
        result.setNodeName(xmlName);
        if (any.getNamespaces().hasMoreElements() && (nsURI = (String)any.getNamespaces().nextElement()).length() > 0) {
            if (nsURI.equals("##targetNamespace")) {
                Schema schema = any.getSchema();
                if (schema != null) {
                    result.setNamespaceURI(schema.getTargetNamespace());
                }
            } else if (!nsURI.startsWith("##")) {
                result.setNamespaceURI(nsURI);
            }
        }
        return result;
    }

    public FieldInfo createFieldInfoForContent(XSType xsType) {
        String fieldName = "_content";
        FieldInfo fInfo = null;
        fInfo = xsType.getType() == 45 ? this._infoFactory.createCollection(((XSList)xsType).getContentType(), fieldName, null) : this._infoFactory.createFieldInfo(xsType, fieldName);
        fInfo.setNodeType((short)2);
        fInfo.setComment("internal content storage");
        fInfo.setRequired(false);
        fInfo.setNodeName("#text");
        if (xsType instanceof XSString) {
            fInfo.setDefaultValue("\"\"");
        }
        return fInfo;
    }

    public FieldInfo createFieldInfo(XMLBindingComponent component, ClassInfoResolver resolver) {
        String comment;
        String value;
        String xmlName = component.getXMLName();
        String memberName = component.getJavaMemberName();
        if (!memberName.startsWith("_")) {
            memberName = "_" + memberName;
        }
        XMLType xmlType = component.getXMLType();
        ClassInfo classInfo = resolver.resolve(component);
        XSType xsType = null;
        FieldInfo fieldInfo = null;
        boolean enumeration = false;
        boolean simpleTypeCollection = false;
        if (xmlType != null) {
            if (xmlType.isSimpleType()) {
                SimpleType simpleType = (SimpleType)xmlType;
                SimpleType baseType = null;
                String derivationMethod = simpleType.getDerivationMethod();
                if (derivationMethod != null && "restriction".equals(derivationMethod)) {
                    baseType = (SimpleType)simpleType.getBaseType();
                }
                if (simpleType.hasFacet("enumeration")) {
                    enumeration = true;
                    if (resolver != null) {
                        classInfo = resolver.resolve(xmlType);
                    }
                    if (classInfo != null) {
                        xsType = classInfo.getSchemaType();
                    }
                } else if (simpleType instanceof ListType || baseType instanceof ListType) {
                    if (baseType != null) {
                        if (!baseType.isBuiltInType()) {
                            simpleTypeCollection = true;
                        }
                    } else if (!simpleType.isBuiltInType()) {
                        simpleTypeCollection = true;
                    }
                }
                if (xsType == null) {
                    xsType = component.getJavaType();
                }
            } else if (xmlType.isAnyType()) {
                if (classInfo != null) {
                    xsType = classInfo.getSchemaType();
                }
                if (xsType == null) {
                    xsType = new XSClass(SGTypes.Object);
                }
            } else if (xmlType.isComplexType() && xmlType.getName() != null && this._config.mappingSchemaType2Java()) {
                XMLBindingComponent temp = new XMLBindingComponent(this._config);
                temp.setBinding(component.getBinding());
                temp.setView(xmlType);
                String className = temp.getQualifiedName();
                if (className != null) {
                    xsType = new XSClass(new JClass(className));
                    className = null;
                }
            }
        } else {
            switch (component.getAnnotated().getStructureType()) {
                case 3: 
                case 8: {
                    xsType = new XSClass(SGTypes.Object);
                    break;
                }
            }
        }
        if (xsType == null) {
            String className = component.getQualifiedName();
            xsType = new XSClass(new JClass(className));
            className = null;
        }
        int maxOccurs = component.getUpperBound();
        int minOccurs = component.getLowerBound();
        if (simpleTypeCollection || maxOccurs < 0 || maxOccurs > 1) {
            String vName = memberName + "List";
            CollectionInfo cInfo = this._infoFactory.createCollection(xsType, vName, component.getJavaMemberName());
            XSList xsList = cInfo.getXSList();
            if (!simpleTypeCollection) {
                xsList.setMaximumSize(maxOccurs);
                xsList.setMinimumSize(minOccurs);
            }
            fieldInfo = cInfo;
        } else {
            switch (xsType.getType()) {
                case 25: {
                    fieldInfo = this._infoFactory.createIdentity(memberName);
                    break;
                }
                case 45: {
                    String collectionName = component.getCollectionType();
                    fieldInfo = this._infoFactory.createCollection(((XSList)xsType).getContentType(), memberName, xmlName, collectionName);
                    break;
                }
                default: {
                    fieldInfo = this._infoFactory.createFieldInfo(xsType, memberName);
                }
            }
        }
        boolean createForElement = false;
        boolean createForAttribute = false;
        fieldInfo.setNodeName(xmlName);
        fieldInfo.setRequired(minOccurs > 0);
        switch (component.getAnnotated().getStructureType()) {
            case 8: {
                fieldInfo.setNodeType((short)1);
                ElementDecl element = (ElementDecl)component.getAnnotated();
                createForElement = true;
                break;
            }
            case 3: {
                fieldInfo.setNodeType((short)0);
                createForAttribute = true;
                break;
            }
            case 10: 
            case 16: {
                fieldInfo.setNodeName("-error-if-this-is-used-");
                fieldInfo.setContainer(true);
            }
        }
        String nsURI = component.getTargetNamespace();
        if (nsURI != null && nsURI.length() > 0) {
            fieldInfo.setNamespaceURI(nsURI);
        }
        if ((value = component.getValue()) != null) {
            switch (xsType.getType()) {
                case 14: {
                    value = value + 'f';
                    break;
                }
                case 11: {
                    Boolean bool = new Boolean(value);
                    value = bool.toString();
                    break;
                }
            }
            if (value.length() == 0) {
                value = "\"\"";
            }
            if (xsType.getJType().toString().equals("java.lang.String")) {
                char ch = value.charAt(0);
                switch (ch) {
                    case '\"': 
                    case '\'': {
                        break;
                    }
                    default: {
                        value = '\"' + value + '\"';
                        break;
                    }
                }
            } else if (enumeration) {
                JType jType = null;
                jType = classInfo != null ? classInfo.getJClass() : xsType.getJType();
                String tmp = jType.getName() + ".valueOf(\"" + value;
                value = tmp = tmp + "\")";
            } else if (!xsType.getJType().isPrimitive() && !xsType.isDateTime()) {
                value = "new " + xsType.getJType().toString() + "(\"" + value + "\")";
            }
            if (component.isFixed()) {
                fieldInfo.setFixedValue(value);
            } else {
                fieldInfo.setDefaultValue(value);
            }
        }
        if (component.isNillable()) {
            fieldInfo.setNillable(true);
        }
        if ((comment = this.createComment(component.getAnnotated())) != null) {
            fieldInfo.setComment(comment);
        }
        if (component.getXMLFieldHandler() != null) {
            fieldInfo.setXMLFieldHandler(component.getXMLFieldHandler());
        }
        if (component.getValidator() != null) {
            fieldInfo.setValidator(component.getValidator());
        }
        return fieldInfo;
    }

    private String createComment(Annotated annotated) {
        Enumeration enumeration = annotated.getAnnotations();
        if (enumeration.hasMoreElements()) {
            return this.createComment((Annotation)enumeration.nextElement());
        }
        switch (annotated.getStructureType()) {
            case 8: {
                ElementDecl elem = (ElementDecl)annotated;
                if (!elem.isReference()) break;
                return this.createComment(elem.getReference());
            }
            case 3: {
                AttributeDecl att = (AttributeDecl)annotated;
                if (!att.isReference()) break;
                return this.createComment(att.getReference());
            }
        }
        return null;
    }

    private String createComment(Annotation annotation) {
        if (annotation == null) {
            return null;
        }
        Enumeration enumeration = annotation.getDocumentation();
        if (enumeration.hasMoreElements()) {
            Documentation documentation = (Documentation)enumeration.nextElement();
            return MemberFactory.normalize(documentation.getContent());
        }
        return null;
    }

    private static String normalize(String value) {
        if (value == null) {
            return null;
        }
        char[] chars = value.toCharArray();
        char[] newChars = new char[chars.length];
        int count = 0;
        int i = 0;
        boolean skip = false;
        while (i < chars.length) {
            char ch;
            if ((ch = chars[i++]) == ' ' || ch == '\t') {
                if (!skip && count != 0) {
                    newChars[count++] = 32;
                }
                skip = true;
                continue;
            }
            if (count == 0 && (ch == '\r' || ch == '\n')) continue;
            newChars[count++] = ch;
            skip = false;
        }
        return new String(newChars, 0, count);
    }
}

