/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.xqj.SaxonDuration;

public class SaxonXMLGregorianCalendar
extends XMLGregorianCalendar {
    private BigInteger year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int microsecond;
    private int tzOffset;

    public SaxonXMLGregorianCalendar(CalendarValue value) {
        this.clear();
        this.setCalendarValue(value);
    }

    private SaxonXMLGregorianCalendar() {
    }

    public void setCalendarValue(CalendarValue value) {
        try {
            if (value instanceof GYearValue) {
                this.year = BigInteger.valueOf(((Int64Value)value.getComponent(1)).longValue());
            } else if (value instanceof GYearMonthValue) {
                this.year = BigInteger.valueOf(((Int64Value)value.getComponent(1)).longValue());
                this.month = (int)((Int64Value)value.getComponent(2)).longValue();
            } else if (value instanceof GMonthValue) {
                this.month = (int)((Int64Value)value.getComponent(2)).longValue();
            } else if (value instanceof GMonthDayValue) {
                this.month = (int)((Int64Value)value.getComponent(2)).longValue();
                this.day = (int)((Int64Value)value.getComponent(3)).longValue();
            } else if (value instanceof GDayValue) {
                this.day = (int)((Int64Value)value.getComponent(3)).longValue();
            } else if (value instanceof DateValue) {
                this.year = BigInteger.valueOf(((Int64Value)value.getComponent(1)).longValue());
                this.month = (int)((Int64Value)value.getComponent(2)).longValue();
                this.day = (int)((Int64Value)value.getComponent(3)).longValue();
            } else if (value instanceof TimeValue) {
                this.hour = (int)((Int64Value)value.getComponent(4)).longValue();
                this.minute = (int)((Int64Value)value.getComponent(5)).longValue();
                this.second = (int)((Int64Value)value.getComponent(12)).longValue();
                this.microsecond = (int)((Int64Value)value.getComponent(11)).longValue();
            } else {
                this.year = BigInteger.valueOf(((Int64Value)value.getComponent(1)).longValue());
                this.month = (int)((Int64Value)value.getComponent(2)).longValue();
                this.day = (int)((Int64Value)value.getComponent(3)).longValue();
                this.hour = (int)((Int64Value)value.getComponent(4)).longValue();
                this.minute = (int)((Int64Value)value.getComponent(5)).longValue();
                this.second = (int)((Int64Value)value.getComponent(12)).longValue();
                this.microsecond = (int)((Int64Value)value.getComponent(11)).longValue();
            }
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void clear() {
        this.year = null;
        this.month = Integer.MIN_VALUE;
        this.day = Integer.MIN_VALUE;
        this.hour = Integer.MIN_VALUE;
        this.minute = Integer.MIN_VALUE;
        this.second = Integer.MIN_VALUE;
        this.microsecond = Integer.MIN_VALUE;
        this.tzOffset = Integer.MIN_VALUE;
    }

    public void reset() {
        this.clear();
    }

    public void setYear(BigInteger year) {
        this.year = year;
    }

    public void setYear(int year) {
        this.year = BigInteger.valueOf(year);
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void setTimezone(int offset) {
        this.tzOffset = offset;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public void setMillisecond(int millisecond) {
        this.microsecond = millisecond * 1000;
    }

    public void setFractionalSecond(BigDecimal fractional) {
        this.second = fractional.intValue();
        BigInteger micros = fractional.movePointRight(6).toBigInteger();
        micros = micros.remainder(BigInteger.valueOf(1000000L));
        this.microsecond = micros.intValue();
    }

    public BigInteger getEon() {
        return this.year.divide(BigInteger.valueOf(1000000000L));
    }

    public int getYear() {
        return this.year.intValue();
    }

    public BigInteger getEonAndYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getTimezone() {
        return this.tzOffset;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMicrosecond() {
        BigDecimal fractionalSeconds = this.getFractionalSecond();
        if (fractionalSeconds == null) {
            return Integer.MIN_VALUE;
        }
        return this.getFractionalSecond().movePointRight(6).intValue();
    }

    public BigDecimal getFractionalSecond() {
        if (this.second == Integer.MIN_VALUE) {
            return null;
        }
        return BigDecimal.valueOf(this.microsecond).movePointLeft(6);
    }

    public int compare(XMLGregorianCalendar xmlGregorianCalendar) {
        return this.toCalendarValue().getSchemaComparable().compareTo(((SaxonXMLGregorianCalendar)xmlGregorianCalendar).toCalendarValue().getSchemaComparable());
    }

    public XMLGregorianCalendar normalize() {
        return new SaxonXMLGregorianCalendar(this.toCalendarValue().adjustTimezone(0));
    }

    public String toXMLFormat() {
        return this.toCalendarValue().getStringValue();
    }

    public QName getXMLSchemaType() {
        if (this.second == Integer.MIN_VALUE) {
            if (this.year == null) {
                if (this.month == Integer.MIN_VALUE) {
                    return DatatypeConstants.GDAY;
                }
                if (this.day == Integer.MIN_VALUE) {
                    return DatatypeConstants.GMONTH;
                }
                return DatatypeConstants.GMONTHDAY;
            }
            if (this.day == Integer.MIN_VALUE) {
                if (this.month == Integer.MIN_VALUE) {
                    return DatatypeConstants.GYEAR;
                }
                return DatatypeConstants.GYEARMONTH;
            }
            return DatatypeConstants.DATE;
        }
        if (this.year == null) {
            return DatatypeConstants.TIME;
        }
        return DatatypeConstants.DATETIME;
    }

    public boolean isValid() {
        return true;
    }

    public void add(Duration duration) {
        try {
            CalendarValue cv = this.toCalendarValue().add(((SaxonDuration)duration).getDurationValue());
            this.setCalendarValue(cv);
        }
        catch (XPathException err) {
            throw new IllegalArgumentException(err.getMessage());
        }
    }

    public GregorianCalendar toGregorianCalendar() {
        return this.toCalendarValue().getCalendar();
    }

    public GregorianCalendar toGregorianCalendar(TimeZone timezone, Locale aLocale, XMLGregorianCalendar defaults) {
        GregorianCalendar gc = new GregorianCalendar(timezone, aLocale);
        gc.setGregorianChange(new Date(Long.MIN_VALUE));
        gc.set(0, this.year.signum());
        gc.set(1, this.year.abs().intValue());
        gc.set(2, this.month);
        gc.set(5, this.day);
        gc.set(10, this.hour);
        gc.set(12, this.minute);
        gc.set(13, this.second);
        gc.set(14, this.getMillisecond() / 1000);
        return gc;
    }

    public TimeZone getTimeZone(int defaultZoneoffset) {
        if (this.tzOffset == Integer.MIN_VALUE) {
            if (defaultZoneoffset == Integer.MIN_VALUE) {
                return new GregorianCalendar().getTimeZone();
            }
            return new SimpleTimeZone(defaultZoneoffset * 60000, "XXX");
        }
        return new SimpleTimeZone(this.tzOffset * 60000, "XXX");
    }

    public Object clone() {
        SaxonXMLGregorianCalendar s = new SaxonXMLGregorianCalendar();
        s.setYear(this.year);
        s.setMonth(this.month);
        s.setDay(this.day);
        s.setHour(this.hour);
        s.setMinute(this.minute);
        s.setSecond(this.second);
        s.setMillisecond(this.microsecond / 1000);
        s.setTimezone(this.tzOffset);
        return s;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CalendarValue toCalendarValue() {
        if (this.second != Integer.MIN_VALUE) {
            if (this.year != null) return new DateTimeValue(this.year.intValue(), (byte)this.month, (byte)this.day, (byte)this.hour, (byte)this.minute, (byte)this.second, this.getMicrosecond(), this.tzOffset);
            return new TimeValue((byte)this.hour, (byte)this.minute, (byte)this.second, this.getMicrosecond(), this.tzOffset);
        }
        if (this.year != null) {
            if (this.day != Integer.MIN_VALUE) return new DateValue(this.year.intValue(), (byte)this.month, (byte)this.day, this.tzOffset);
            if (this.month != Integer.MIN_VALUE) return new GYearMonthValue(this.year.intValue(), (byte)this.month, this.tzOffset);
            return new GYearValue(this.year.intValue(), this.tzOffset);
        }
        if (this.month == Integer.MIN_VALUE) {
            new GDayValue((byte)this.day, this.tzOffset);
            return new DateValue(this.year.intValue(), (byte)this.month, (byte)this.day, this.tzOffset);
        }
        if (this.day != Integer.MIN_VALUE) return new GMonthDayValue((byte)this.month, (byte)this.day, this.tzOffset);
        return new GMonthValue((byte)this.month, this.tzOffset);
    }
}

