/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util.webservices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infoglue.deliver.util.webservices.DynamicWebserviceElement;

public class DynamicWebserviceSerializer {
    private static final Object MARKER = null;
    private Map legalTypes;

    public DynamicWebserviceSerializer() {
    }

    public DynamicWebserviceSerializer(Map legalTypes) {
        this.legalTypes = legalTypes;
    }

    public List serializeCollection(Collection collection) {
        Collection c = collection == null ? new ArrayList() : collection;
        List result = this.createResultList(c.getClass(), c.size());
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            result.addAll(this.serializeObject(i.next()));
        }
        return result;
    }

    public List serializeMap(Map map) {
        Map m = map == null ? new HashMap() : map;
        List result = this.createResultList(m.getClass(), m.size());
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            result.addAll(this.serializeObject(key));
            result.addAll(this.serializeObject(value));
        }
        return result;
    }

    public List serializeDynamicWebserviceElement(DynamicWebserviceElement element) {
        List arguments = element.serialize();
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            this.checkType(i.next());
        }
        List result = this.createResultList(element.getClass(), arguments.size());
        result.addAll(arguments);
        return result;
    }

    private List serializeObject(Object o) {
        if (o instanceof Map) {
            return this.serializeMap((Map)o);
        }
        if (o instanceof Collection) {
            return this.serializeCollection((Collection)o);
        }
        if (o instanceof DynamicWebserviceElement) {
            return this.serializeDynamicWebserviceElement((DynamicWebserviceElement)o);
        }
        this.checkType(o);
        ArrayList<Object> dummy = new ArrayList<Object>();
        dummy.add(o);
        return dummy;
    }

    private List createResultList(Class c, int size) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(MARKER);
        list.add(c.getName());
        list.add(new Integer(size).toString());
        return list;
    }

    private void checkType(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null objects are not allowed in collections...");
        }
    }

    public Object deserialize(Object[] array) throws Throwable {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return this.deserializeElement(list);
    }

    private Object deserializeMap(List c, Map map, int count) throws Throwable {
        int i = 0;
        while (i < count) {
            Object key = this.deserializeElement(c);
            Object value = this.deserializeElement(c);
            map.put(key, value);
            ++i;
        }
        return map;
    }

    private Object deserializeCollection(List c, Collection collection, int count) throws Throwable {
        int i = 0;
        while (i < count) {
            Object o = this.deserializeElement(c);
            collection.add(o);
            ++i;
        }
        return collection;
    }

    private Object deserializeDynamicWebserviceElement(List c, DynamicWebserviceElement element, int count) throws Throwable {
        ArrayList arguments = new ArrayList();
        int i = 0;
        while (i < count) {
            arguments.add(c.remove(0));
            ++i;
        }
        element.deserialize(arguments);
        return element;
    }

    private Object deserializeElement(List c) throws Throwable {
        Object o = c.remove(0);
        if (o == MARKER) {
            Object oo = Class.forName(c.remove(0).toString()).newInstance();
            int count = new Integer(c.remove(0).toString());
            if (oo instanceof Map) {
                return this.deserializeMap(c, (Map)oo, count);
            }
            if (oo instanceof Collection) {
                return this.deserializeCollection(c, (Collection)oo, count);
            }
            return this.deserializeDynamicWebserviceElement(c, (DynamicWebserviceElement)oo, count);
        }
        return o;
    }
}

