/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util.webservices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.log4j.Logger;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.deliver.util.webservices.DynamicWebserviceSerializer;
import org.infoglue.deliver.util.webservices.Parameter;

public class DynamicWebservice {
    private static final Logger logger = Logger.getLogger((String)DynamicWebservice.class.getName());
    private static final String PRINCIPAL_ARGUMENT_NAME = "principal";
    private static final String DEFAULT_NAMESPACE_URI = "http://soapinterop.org/";
    private String targetEndpointAddress;
    private String operationName;
    private QName returnType;
    private final List parameters = new ArrayList();
    private final List arguments = new ArrayList();
    private final Map mappings = new HashMap();
    private final Map standardMappings = new HashMap();
    private Service service;
    private Call call;
    private Object result;
    private DynamicWebserviceSerializer serializer;

    public DynamicWebservice(InfoGluePrincipal remotePrincipal) {
        this.configureStandardMappings();
        this.serializer = new DynamicWebserviceSerializer(this.standardMappings);
        this.addArgument(PRINCIPAL_ARGUMENT_NAME, remotePrincipal.getName());
    }

    public void callService() {
        try {
            this.service = new Service();
            this.call = (Call)this.service.createCall();
            this.configureBasic();
            this.configureMappings();
            this.configureParameters();
            this.result = this.call.invoke(this.arguments.toArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configureStandardMappings() {
        this.standardMappings.put(Boolean.class, XMLType.XSD_BASE64);
        this.standardMappings.put(Boolean.class, XMLType.XSD_BOOLEAN);
        this.standardMappings.put(Double.class, XMLType.XSD_DOUBLE);
        this.standardMappings.put(Float.class, XMLType.XSD_FLOAT);
        this.standardMappings.put(Integer.class, XMLType.XSD_INT);
        this.standardMappings.put(Long.class, XMLType.XSD_LONG);
        this.standardMappings.put(String.class, XMLType.XSD_STRING);
    }

    private void configureBasic() {
        this.call.setTimeout(Integer.valueOf(30000));
        this.call.setTargetEndpointAddress(this.targetEndpointAddress);
        this.call.setOperationName(new QName(DEFAULT_NAMESPACE_URI, this.operationName));
        this.call.setEncodingStyle("javax.xml.rpc.encodingstyle.namespace.uri");
        this.call.setReturnType(this.returnType);
    }

    private void configureParameters() {
        for (Parameter parameter : this.parameters) {
            this.call.addParameter(parameter.name, parameter.type, ParameterMode.IN);
        }
    }

    private void configureMappings() {
        for (Class clazz : this.mappings.keySet()) {
            QName type = (QName)this.mappings.get(clazz);
            this.call.registerTypeMapping(clazz, type, BeanSerializerFactory.class, BeanDeserializerFactory.class);
        }
    }

    public Object getResult() {
        return this.result;
    }

    public void setTargetEndpointAddress(String targetEndpointAddress) {
        logger.debug((Object)("targetEndpointAddress=[" + targetEndpointAddress + "]"));
        this.targetEndpointAddress = targetEndpointAddress;
    }

    public void setOperationName(String operationName) {
        logger.debug((Object)("operationName=[" + operationName + "]"));
        this.operationName = operationName;
    }

    public void setReturnType(Class c) {
        logger.debug((Object)("returnType=[" + (c == null ? "null" : this.getClassName(c)) + "]"));
        this.returnType = this.mappingForClass(c);
    }

    public void setReturnType(Class c, QName type) {
        logger.debug((Object)("returnType=[" + (c == null ? "null" : type.getLocalPart()) + "]"));
        this.mappings.put(c, type);
        this.returnType = this.mappingForClass(c);
    }

    public void addArgument(String name, Object value) {
        this.assertNameNotNull(name);
        logger.debug((Object)("addArgument=[" + name + "," + value + "]"));
        this.addArgument(name, this.mappingForClass(value.getClass()), value);
    }

    public void addArgument(String name, Map value) {
        this.assertNameNotNull(name);
        logger.debug((Object)("addArgument=[" + name + "," + value + "] (Map)"));
        this.addArgument(name, XMLType.SOAP_ARRAY, this.serializer.serializeMap(value).toArray());
    }

    public void addArgument(String name, Collection value) {
        this.assertNameNotNull(name);
        logger.debug((Object)("addArgument=[" + name + "," + value + "] (Collection)"));
        this.addArgument(name, XMLType.SOAP_ARRAY, this.serializer.serializeCollection(value).toArray());
    }

    public void addArgument(String name, Collection value, Class[] objectClass) {
        this.assertNameNotNull(name);
        logger.debug((Object)("addArgument=[" + name + "," + value + "] (Collection)"));
        int i = 0;
        while (i < objectClass.length) {
            this.mappings.put(objectClass[i], new QName("infoglue", this.getClassName(objectClass[i])));
            this.mappingForClass(objectClass[i], "infoglue");
            ++i;
        }
        this.addArgument(name, XMLType.SOAP_ARRAY, this.serializer.serializeCollection(value).toArray());
    }

    public void addArgument(String name, Map value, Class[] objectClass) {
        this.assertNameNotNull(name);
        logger.debug((Object)("addArgument=[" + name + "," + value + "] (Map)"));
        int i = 0;
        while (i < objectClass.length) {
            this.mappings.put(objectClass[i], new QName("infoglue", this.getClassName(objectClass[i])));
            this.mappingForClass(objectClass[i], "infoglue");
            ++i;
        }
        this.addArgument(name, XMLType.SOAP_ARRAY, this.serializer.serializeMap(value).toArray());
    }

    public void addNonSerializedArgument(String name, Collection value) {
        this.assertNameNotNull(name);
        logger.debug((Object)("addArgument=[" + name + "," + value + "] (Collection)"));
        this.addArgument(name, XMLType.SOAP_ARRAY, value);
    }

    private void assertNameNotNull(String argument) {
        if (argument == null) {
            throw new IllegalArgumentException("A parameter name can't be null.");
        }
    }

    private void addArgument(String name, QName type, Object value) {
        this.parameters.add(new Parameter(name, type));
        this.arguments.add(value);
    }

    private QName mappingForClass(Class c) {
        if (c == null) {
            return null;
        }
        if (this.standardMappings.containsKey(c)) {
            return (QName)this.standardMappings.get(c);
        }
        if (this.mappings.containsKey(c)) {
            return (QName)this.mappings.get(c);
        }
        return this.addMapping(c);
    }

    private QName mappingForClass(Class c, String namespace) {
        if (c == null) {
            return null;
        }
        if (this.standardMappings.containsKey(c)) {
            return (QName)this.standardMappings.get(c);
        }
        if (this.mappings.containsKey(c)) {
            return (QName)this.mappings.get(c);
        }
        return this.addMapping(c, namespace);
    }

    private QName addMapping(Class c) {
        String className = this.getClassName(c);
        QName type = new QName(DEFAULT_NAMESPACE_URI + className, className);
        this.mappings.put(c, type);
        logger.debug((Object)("addMapping=[" + c.getName() + "," + type + "]"));
        return type;
    }

    private QName addMapping(Class c, String namespace) {
        String className = this.getClassName(c);
        QName type = new QName(String.valueOf(namespace) + className, className);
        this.mappings.put(c, type);
        logger.debug((Object)("addMapping=[" + c.getName() + "," + type + "]"));
        return type;
    }

    public String getClassName(Class c) {
        int firstChar = c.getName().lastIndexOf(46) + 1;
        return firstChar > 0 ? c.getName().substring(firstChar) : c.getName();
    }
}

