/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util.webloggers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.util.webloggers.Logger;

public class IISLogger
extends Logger {
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)IISLogger.class.getName());
    protected static final String[] monthnames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    protected static String noUrl = "*NOURL*";
    private byte[] msgbuf = null;
    protected RandomAccessFile log = null;
    protected RandomAccessFile errlog = null;
    protected RandomAccessFile trace = null;
    protected int bufsize = 8192;
    protected int bufptr = 0;
    protected int rotateLevel = 0;
    protected byte[] buffer = null;
    protected int year = -1;
    protected int month = -1;
    protected int day = -1;
    protected int hour = -1;
    private Calendar cal = null;
    private long datestamp = -1L;
    private char[] datecache = new char[]{'D', 'D', '/', 'M', 'M', 'M', '/', 'Y', 'Y', 'Y', 'Y', ':', 'H', 'H', ':', 'M', 'M', ':', 'S', 'S', ' ', '+', '0', '0', '0', '0'};
    private static String hostAddress = null;
    private static String hostName = null;
    private String headerLine1 = "#Software: Microsoft Internet Information Services 5.0";
    private String headerLine2 = "#Version: 1.0";
    private String headerLine3 = "#Date: " + new Date();
    private String headerLine4 = "#Fields: date time c-ip cs-username s-sitename s-computername s-ip s-port cs-method cs-uri-stem cs-uri-query sc-status sc-win32-status sc-bytes cs-bytes time-taken cs-version cs-host cs(User-Agent) cs(Cookie) cs(Referer)";
    private List logBuffer = new ArrayList();

    public void logRequest(HttpServletRequest request, HttpServletResponse response, String pagePath, long duration) {
    }

    public void initialize() {
    }

    IISLogger() {
        this.msgbuf = new byte[128];
    }

    protected void writeRequest(String date, String row) {
        this.logBuffer.add(row);
        if (this.logBuffer.size() > 20) {
            block14: {
                String logPath = CmsPropertyHandler.getStatisticsLogPath();
                File file = new File(String.valueOf(logPath) + File.separator + "stat" + date + ".log");
                boolean isFileCreated = file.exists();
                PrintWriter pout = null;
                try {
                    try {
                        pout = new PrintWriter(new FileOutputStream(file, true));
                        if (!isFileCreated) {
                            pout.println(this.headerLine1);
                            pout.println(this.headerLine2);
                            pout.println(this.headerLine3);
                            pout.println(this.headerLine4);
                        }
                        Iterator i = this.logBuffer.iterator();
                        while (i.hasNext()) {
                            pout.println(i.next().toString());
                        }
                        pout.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        try {
                            pout.close();
                        }
                        catch (Exception exception) {}
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        pout.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    pout.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.logBuffer = new ArrayList();
        }
    }

    public String getCurrentDate(String pattern) {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        String dateString = formatter.format(date);
        return dateString;
    }

    public String getHostAddress() {
        if (hostAddress != null) {
            return hostAddress;
        }
        String address = null;
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        hostAddress = address;
        return address;
    }

    public String getHostName() {
        if (hostName != null) {
            return hostName;
        }
        String name = null;
        try {
            name = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        hostName = name;
        return name;
    }

    public String defaultValueIfNull(String value) {
        if (value == null || value.equals("")) {
            return "-";
        }
        return value;
    }
}

