/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util.webloggers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.util.webloggers.Logger;

public class CommonLogger
extends Logger {
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)CommonLogger.class.getName());
    private static String hostAddress = null;
    private static String hostName = null;
    private List logBuffer = new ArrayList();

    public void logRequest(HttpServletRequest request, HttpServletResponse response, String pagePath, long duration) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.defaultValueIfNull(request.getRemoteAddr()));
        sb.append(" ");
        sb.append("-");
        sb.append(" ");
        sb.append(this.defaultValueIfNull(request.getRemoteUser()));
        sb.append(" ");
        sb.append("[" + this.defaultValueIfNull(this.getCurrentDate("dd/MMM/yyyy:HH:mm:ss")) + " " + this.getOffset() + "]");
        sb.append(" ");
        sb.append("\"" + request.getMethod() + " " + pagePath + " " + request.getProtocol() + "\"");
        sb.append(" ");
        sb.append("304");
        sb.append(" ");
        sb.append("-");
        sb.append(" ");
        sb.append("\"" + this.defaultValueIfNull(request.getHeader("Referer")) + "\"");
        sb.append(" ");
        sb.append("\"" + this.defaultValueIfNull(request.getHeader("User-Agent")) + "\"");
        this.writeRequest(this.getCurrentDate("yyyy-MM-dd"), sb.toString());
    }

    public void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeRequest(String date, String row) {
        List list = this.logBuffer;
        synchronized (list) {
            this.logBuffer.add(row);
            if (this.logBuffer.size() > 100) {
                block17: {
                    String logPath = CmsPropertyHandler.getStatisticsLogPath();
                    String statisticsLogOneFilePerDay = CmsPropertyHandler.getStatisticsLogOneFilePerDay();
                    File file = new File(String.valueOf(logPath) + File.separator + "statistics.log");
                    if (statisticsLogOneFilePerDay != null && statisticsLogOneFilePerDay.equalsIgnoreCase("true")) {
                        file = new File(String.valueOf(logPath) + File.separator + "stat" + date + ".log");
                    }
                    boolean isFileCreated = file.exists();
                    PrintWriter pout = null;
                    try {
                        try {
                            pout = new PrintWriter(new FileOutputStream(file, true));
                            Iterator i = this.logBuffer.iterator();
                            while (i.hasNext()) {
                                pout.println(i.next().toString());
                            }
                            pout.close();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            try {
                                pout.close();
                            }
                            catch (Exception exception) {}
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            pout.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        pout.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.logBuffer = new ArrayList();
            }
        }
    }

    public String getCurrentDate(String pattern) {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        String dateString = formatter.format(date);
        return dateString;
    }

    private String getOffset() {
        Calendar cal = Calendar.getInstance();
        String offsetString = "";
        int offset = (cal.get(15) + cal.get(16)) / 3600000;
        offsetString = offset < 10 && offset > -10 ? (offset > 0 ? "+0" + offset + "00" : "-0" + offset + "00") : (offset > 0 ? "+" + offset + "00" : "-" + offset + "00");
        return offsetString;
    }

    public String getHostAddress() {
        if (hostAddress != null) {
            return hostAddress;
        }
        String address = null;
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        hostAddress = address;
        return address;
    }

    public String getHostName() {
        if (hostName != null) {
            return hostName;
        }
        String name = null;
        try {
            name = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        hostName = name;
        return name;
    }

    public String defaultValueIfNull(String value) {
        if (value == null || value.equals("")) {
            return "-";
        }
        return value;
    }
}

