/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util.rss;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class RssHelper {
    private static final Logger logger = Logger.getLogger((String)RssHelper.class.getName());
    private static final String COULD_NOT_GENERATE_FEED_ERROR = "Could not generate feed";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private String defaultFeedType = "atom_0.3";

    public String render(SyndFeed feed) {
        String output = null;
        try {
            SyndFeedOutput out = new SyndFeedOutput();
            output = out.outputString(feed);
        }
        catch (FeedException fe) {
            String msg = COULD_NOT_GENERATE_FEED_ERROR;
            logger.error((Object)msg, (Throwable)fe);
        }
        return output;
    }

    public SyndFeed getFeed(String feedType, String title, String link, String description, String encoding) throws IOException, FeedException {
        SyndFeedImpl feed = new SyndFeedImpl();
        feedType = feedType != null ? feedType : this.defaultFeedType;
        feed.setFeedType(feedType);
        feed.setTitle(title);
        feed.setLink(link);
        feed.setDescription(description);
        feed.setEncoding(encoding);
        ArrayList entries = new ArrayList();
        feed.setEntries(entries);
        return feed;
    }

    public void addEntry(SyndFeed feed, String title, String link, Date publishedDate, String description, String descriptionContentType) throws IOException, FeedException {
        SimpleDateFormat dateParser = new SimpleDateFormat(DATE_FORMAT);
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setTitle(title);
        entry.setLink(link);
        entry.setPublishedDate(publishedDate);
        SyndContentImpl syndContent = new SyndContentImpl();
        syndContent.setType(descriptionContentType);
        syndContent.setValue(description);
        entry.setDescription((SyndContent)syndContent);
        feed.getEntries().add(entry);
    }
}

