/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.infoglue.deliver.util.graphics.FontSaver;

public class ImageRenderer {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private int canvasWidth = 300;
    private int canvasHeight = 100;
    private int textStartPosX = 5;
    private int textStartPosY = 25;
    private int textWidth = 300;
    private int textHeight = 100;
    private String fontName = "Dialog";
    private int fontStyle = 0;
    private int fontSize = 12;
    private int alignment = 0;
    private Color backgroundColor = null;
    private Color foreGroundColor = null;
    private String backgroundImageUrl = null;

    public void generateGifImageFromText(String file, String text, String encoding) throws Exception {
        BufferedImage image = new BufferedImage(this.canvasWidth, this.canvasHeight, 2);
        this.drawText((Graphics2D)image.getGraphics(), text);
        Hashtable<String, String> arguments = new Hashtable<String, String>();
        arguments.put("encoding", "websafe");
        File outputFile = new File(file);
        ImageIO.write((RenderedImage)image, "PNG", outputFile);
    }

    private void drawText(Graphics2D g2d, String text) throws Exception {
        Font font = FontSaver.create(this.fontName, this.fontStyle, this.fontSize);
        if (this.backgroundImageUrl != null) {
            URL url = new URL(this.backgroundImageUrl);
            BufferedImage bufferedImage = ImageIO.read(url);
            g2d.drawImage((Image)bufferedImage, 0, 0, null);
        } else {
            g2d.setBackground(this.backgroundColor);
            g2d.setPaint(this.backgroundColor);
            g2d.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        }
        g2d.setPaint(this.foreGroundColor);
        g2d.setFont(font);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        AttributedString as = new AttributedString(text);
        as.addAttribute(TextAttribute.FONT, font);
        as.addAttribute(TextAttribute.JUSTIFICATION, font);
        AttributedCharacterIterator paragraph = as.getIterator();
        int paragraphStart = paragraph.getBeginIndex();
        int paragraphEnd = paragraph.getEndIndex();
        float drawPosY = this.textStartPosY;
        StringTokenizer st = new StringTokenizer(text);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreElements()) {
            String word = (String)st.nextElement();
            v.addElement(word);
        }
        String testString = "";
        String realString = "";
        ArrayList<String> lines = new ArrayList<String>();
        int offset = 0;
        int i = 0;
        while (i < v.size()) {
            testString = String.valueOf(realString) + (String)v.get(i) + " ";
            TextLayout testLay = new TextLayout(testString, font, g2d.getFontRenderContext());
            if (testLay.getBounds().getWidth() > (double)this.textWidth || i == v.size() - 2) {
                TextLayout fullyFilledLay;
                String remainingString = testString;
                if (v.size() > i + 1) {
                    remainingString = String.valueOf(remainingString) + (String)v.get(i + 1);
                }
                if (v.size() > i + 2) {
                    remainingString = String.valueOf(remainingString) + " " + (String)v.get(i + 2);
                }
                if ((fullyFilledLay = new TextLayout(remainingString, font, g2d.getFontRenderContext())).getBounds().getWidth() < (double)this.textWidth) {
                    realString = testString;
                    testString = "";
                } else {
                    String row = "";
                    int j = offset;
                    while (j < i) {
                        row = String.valueOf(row) + (String)v.get(j) + " ";
                        ++j;
                    }
                    lines.add(row);
                    realString = "";
                    testString = "";
                    offset = i;
                    realString = String.valueOf((String)v.get(i)) + " ";
                }
            } else {
                realString = testString;
                testString = "";
            }
            ++i;
        }
        if (!realString.equalsIgnoreCase("")) {
            lines.add(realString);
        }
        for (String word : lines) {
            float drawPosX;
            if (word == null || word.length() <= 0) continue;
            TextLayout layout = new TextLayout(word, font, g2d.getFontRenderContext());
            int centerX = this.textWidth / 2;
            int centeredTextStartX = centerX - (int)layout.getVisibleAdvance() / 2;
            int rightTextStartX = this.textWidth - (int)layout.getVisibleAdvance();
            drawPosY += layout.getAscent();
            if (layout.isLeftToRight()) {
                if (this.alignment == 1) {
                    float f = centeredTextStartX;
                }
                drawPosX = this.alignment == 2 ? (float)(rightTextStartX - this.textStartPosX) : (float)this.textStartPosX;
            } else {
                drawPosX = (float)this.textWidth - layout.getAdvance();
            }
            layout.draw(g2d, drawPosX, drawPosY);
            drawPosY += layout.getDescent() + layout.getLeading();
        }
    }

    public void setCanvasHeight(int canvasHeight) {
        this.canvasHeight = canvasHeight;
    }

    public void setCanvasWidth(int canvasWidth) {
        this.canvasWidth = canvasWidth;
    }

    public void setTextHeight(int textHeight) {
        this.textHeight = textHeight;
    }

    public void setTextStartPosX(int textStartPosX) {
        this.textStartPosX = textStartPosX;
    }

    public void setTextStartPosY(int textStartPosY) {
        this.textStartPosY = textStartPosY;
    }

    public void setTextWidth(int textWidth) {
        this.textWidth = textWidth;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setForeGroundColor(Color foreGroundColor) {
        this.foreGroundColor = foreGroundColor;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setBackgroundImageUrl(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }
}

