/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util.graphics;

import java.awt.Color;
import java.util.StringTokenizer;
import org.infoglue.deliver.util.MathHelper;

public class ColorHelper {
    public Color getColor(int r, int g, int b) {
        return new Color(r, g, b);
    }

    public Color getHexColor(String hexadecimalValue) {
        return new Color(new MathHelper().hexToDecimal(hexadecimalValue));
    }

    public static Color getColor(String colonSeparatedRGBA) {
        return ColorHelper.getColor(colonSeparatedRGBA, ":");
    }

    public static Color getColor(String separatedRGBA, String delimiter) {
        StringTokenizer st = new StringTokenizer(separatedRGBA, delimiter, false);
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        if (st.hasMoreTokens()) {
            r = Integer.parseInt(st.nextToken().trim());
        }
        if (st.hasMoreTokens()) {
            g = Integer.parseInt(st.nextToken().trim());
        }
        if (st.hasMoreTokens()) {
            b = Integer.parseInt(st.nextToken().trim());
        }
        if (st.hasMoreTokens()) {
            a = Integer.parseInt(st.nextToken().trim());
        }
        return new Color(r, g, b, a);
    }
}

