/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.util.graphics.ColorHelper;

public class AdvancedImageRenderer {
    private static final long serialVersionUID = -1377395059993980530L;
    private static final Logger logger = Logger.getLogger((String)AdvancedImageRenderer.class.getName());
    private int imageType = 6;
    private static BufferedImage templateImage = null;
    private BufferedImage renderedImage = null;
    private String fontName = "Dialog";
    private int fontStyle = 0;
    private int fontSize = 18;
    private Font font = null;
    private Color fgColor = new Color(0, 0, 0, 255);
    private Color bgColor = new Color(255, 255, 255, 255);
    private int renderWidth = 200;
    private int align = 0;
    private int padTop = 4;
    private int padBottom = 4;
    private int padLeft = 4;
    private int padRight = 4;
    private int maxRows = 20;
    private String imageFormatName = "png";
    private int trimEdges = 0;
    private String backgroundImageUrl = null;
    private BufferedImage backgroundImage = null;
    private int tileBackgroundImage = 0;
    private static Map renderHints = null;
    private static Map methodMap = null;
    private static Map defaultConfigMap = new HashMap();

    public AdvancedImageRenderer() {
        if (methodMap == null) {
            methodMap = new HashMap();
            Method[] methods = this.getClass().getDeclaredMethods();
            String name = null;
            int i = 0;
            while (i < methods.length) {
                name = methods[i].getName().toLowerCase();
                if (name.startsWith("set") && methods[i].getParameterTypes().length == 1) {
                    name = name.substring("set".length());
                    methodMap.put(name, methods[i]);
                    String propVal = CmsPropertyHandler.getProperty("rendertext." + name);
                    if (propVal != null && propVal.trim().length() > 0) {
                        defaultConfigMap.put(name, propVal.toLowerCase());
                    }
                }
                ++i;
            }
            logger.debug((Object)defaultConfigMap);
        }
        if (renderHints == null) {
            renderHints = new HashMap();
            renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            renderHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            renderHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            renderHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            renderHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        }
    }

    public boolean writeImage(File file) {
        boolean success = false;
        try {
            success = ImageIO.write((RenderedImage)this.renderedImage, this.imageFormatName, file);
        }
        catch (Exception e) {
            logger.error((Object)("Couldn't write Image file : " + file), (Throwable)e);
        }
        return success;
    }

    public BufferedImage renderImage(CharSequence text, Map renderAttributes) {
        AttributedString attributedString = new AttributedString(text.toString());
        return this.renderImage(attributedString, renderAttributes);
    }

    public BufferedImage renderImage(AttributedString attributedString, Map renderAttributes) {
        HashMap tempMap = new HashMap(defaultConfigMap);
        if (renderAttributes != null) {
            tempMap.putAll(renderAttributes);
        }
        if ((renderAttributes = tempMap) != null && renderAttributes.size() > 0) {
            for (Map.Entry entry : renderAttributes.entrySet()) {
                String key = entry.getKey().toString().trim().toLowerCase();
                if (!this.hasAttribute(key) || entry.getValue() == null) continue;
                this.setAttribute(key, entry.getValue().toString());
            }
        }
        if (templateImage == null) {
            templateImage = new BufferedImage(8, 8, this.imageType);
        }
        this.font = new Font(this.fontName, this.fontStyle, this.fontSize);
        float wrappingWidth = this.renderWidth - (this.padLeft + this.padRight);
        if (wrappingWidth < 0.0f) {
            throw new IllegalArgumentException("The renderwidth (" + this.renderWidth + ") is lesser than the total padding (" + (this.padLeft + this.padRight) + "), modify your settings.");
        }
        Graphics2D g2d = templateImage.createGraphics();
        g2d.setRenderingHints(renderHints);
        attributedString.addAttribute(TextAttribute.FONT, this.font);
        attributedString.addAttribute(TextAttribute.FOREGROUND, this.fgColor);
        FontRenderContext context = g2d.getFontRenderContext();
        AttributedCharacterIterator iterator = attributedString.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(iterator, context);
        TextLayout layout = null;
        double renderHeight = this.padTop + this.padBottom;
        int numRows = 0;
        while (measurer.getPosition() < iterator.getEndIndex()) {
            layout = measurer.nextLayout(wrappingWidth);
            if (layout == null || numRows >= this.maxRows) break;
            ++numRows;
            renderHeight += (double)(layout.getAscent() + layout.getDescent() + layout.getLeading());
        }
        this.renderedImage = new BufferedImage(this.renderWidth, (int)(renderHeight + 0.5), templateImage.getType());
        Graphics2D img2d = this.renderedImage.createGraphics();
        img2d.setRenderingHints(renderHints);
        img2d.setColor(this.fgColor);
        this.checkAndSetBackground();
        Point2D.Float pen = new Point2D.Float(this.padLeft, this.padTop);
        context = img2d.getFontRenderContext();
        iterator = attributedString.getIterator();
        measurer = new LineBreakMeasurer(iterator, context);
        numRows = 0;
        while (measurer.getPosition() < iterator.getEndIndex()) {
            layout = measurer.nextLayout(wrappingWidth);
            if (layout == null || numRows >= this.maxRows) break;
            ++numRows;
            pen.y += layout.getAscent();
            float dx = 0.0f;
            if (this.align == 1 || !layout.isLeftToRight()) {
                dx = wrappingWidth - layout.getVisibleAdvance();
            } else if (this.align == 2) {
                dx = (wrappingWidth - layout.getVisibleAdvance()) / 2.0f;
            }
            layout.draw(img2d, pen.x + dx, pen.y);
            pen.y += layout.getDescent() + layout.getLeading();
        }
        this.renderedImage = this.horizontalTrim();
        return this.renderedImage;
    }

    private void checkAndSetBackground() {
        Graphics2D img2d = this.renderedImage.createGraphics();
        img2d.setBackground(this.bgColor);
        img2d.clearRect(0, 0, this.renderedImage.getWidth(), this.renderedImage.getHeight());
        if (this.backgroundImageUrl != null) {
            try {
                if (this.backgroundImage == null) {
                    URLConnection connection = new URL(this.backgroundImageUrl).openConnection();
                    InputStream is = connection.getInputStream();
                    this.backgroundImage = ImageIO.read(is);
                    is.close();
                }
                if (this.tileBackgroundImage == 1 && this.backgroundImage.getWidth() < this.renderedImage.getWidth()) {
                    int xnum = (int)((double)(this.renderedImage.getWidth() / this.backgroundImage.getWidth()) + 0.5) + 1;
                    while (xnum-- >= 0) {
                        img2d.drawImage((Image)this.backgroundImage, this.backgroundImage.getWidth() * xnum, 0, null);
                    }
                }
                if (this.tileBackgroundImage == 2 && this.backgroundImage.getHeight() < this.renderedImage.getHeight()) {
                    int ynum = (int)((double)(this.renderedImage.getHeight() / this.backgroundImage.getHeight()) + 0.5) + 1;
                    while (ynum-- >= 0) {
                        img2d.drawImage((Image)this.backgroundImage, 0, this.backgroundImage.getHeight() * ynum, null);
                    }
                }
                if (this.tileBackgroundImage == 3 && this.backgroundImage.getHeight() < this.renderedImage.getHeight()) {
                    int ynum = (int)((double)(this.renderedImage.getHeight() / this.backgroundImage.getHeight()) + 0.5) + 1;
                    while (ynum-- >= 0) {
                        int xnum = (int)((double)(this.renderedImage.getWidth() / this.backgroundImage.getWidth()) + 0.5) + 1;
                        while (xnum-- >= 0) {
                            img2d.drawImage((Image)this.backgroundImage, this.backgroundImage.getWidth() * xnum, this.backgroundImage.getHeight() * ynum, null);
                        }
                    }
                }
                if (this.tileBackgroundImage == 0) {
                    img2d.drawImage((Image)this.backgroundImage, 0, 0, null);
                }
            }
            catch (IOException ioe) {
                logger.error((Object)("Error in reading backgoundImageUrl: " + this.backgroundImageUrl), (Throwable)ioe);
            }
        }
    }

    private BufferedImage horizontalTrim() {
        int y;
        int imgRGB;
        if (this.trimEdges == 0) {
            return this.renderedImage;
        }
        int imgHeight = this.renderedImage.getHeight();
        int imgWidth = this.renderedImage.getWidth();
        int bgRGB = this.bgColor.getRGB();
        int w = 0;
        int leftPos = 0;
        int rightPos = 0;
        if (this.trimEdges == 1 || this.trimEdges == 3) {
            w = 0;
            block0: while (w < imgWidth) {
                imgRGB = 0;
                y = 0;
                while (y < imgHeight) {
                    imgRGB = this.renderedImage.getRGB(w, y);
                    if (imgRGB != bgRGB) break block0;
                    ++y;
                }
                ++w;
            }
            leftPos = w > 0 ? w - 1 : 0;
            int n = leftPos = (leftPos -= this.padLeft) <= 0 ? 0 : leftPos;
        }
        if (this.trimEdges == 2 || this.trimEdges == 3) {
            w = imgWidth - 1;
            block2: while (w >= 0) {
                imgRGB = 0;
                y = 0;
                while (y < imgHeight) {
                    imgRGB = this.renderedImage.getRGB(w, y);
                    if (imgRGB != bgRGB) break block2;
                    ++y;
                }
                --w;
            }
            rightPos = w + 1;
            rightPos = (rightPos += this.padRight) > imgWidth ? imgWidth - 1 : rightPos;
        } else {
            rightPos = imgWidth - 1;
        }
        return this.renderedImage.getSubimage(leftPos, 0, rightPos - leftPos, imgHeight - 1);
    }

    public boolean hasAttribute(CharSequence attributeName) {
        return methodMap.containsKey(attributeName.toString().toLowerCase());
    }

    public void setAttribute(CharSequence attribute, CharSequence value) {
        logger.debug((Object)("set attribute: " + attribute + " = " + value));
        Method method = (Method)methodMap.get(attribute);
        if (method != null) {
            try {
                Class<?>[] params = method.getParameterTypes();
                Class<?> param = params[0];
                if (param.isPrimitive()) {
                    if (param.getName().equals("int")) {
                        method.invoke((Object)this, new Integer(Integer.parseInt(value.toString())));
                    } else if (param.getName().equals("float")) {
                        method.invoke((Object)this, new Float(Float.parseFloat(value.toString())));
                    } else if (param.getName().equals("double")) {
                        method.invoke((Object)this, new Double(Double.parseDouble(value.toString())));
                    } else if (param.getName().equals("boolean")) {
                        method.invoke((Object)this, new Boolean(Boolean.parseBoolean(value.toString())));
                    }
                } else if (param.equals(String.class)) {
                    method.invoke((Object)this, value.toString());
                } else if (param.equals(Color.class)) {
                    method.invoke((Object)this, ColorHelper.getColor(value.toString()));
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Error in setting properties: " + attribute + " = " + value), (Throwable)e);
            }
        } else {
            logger.warn((Object)("No attribut, named: " + attribute + " found, value =" + value));
        }
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public void setBackgroundImage(BufferedImage backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public void setBackgroundImageURL(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setFgColor(Color fgColor) {
        this.fgColor = fgColor;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setImageType(int imageType) {
        this.imageType = imageType;
    }

    public void setPadBottom(int padBottom) {
        this.padBottom = padBottom;
    }

    public void setPadLeft(int padLeft) {
        this.padLeft = padLeft;
    }

    public void setPadRight(int padRight) {
        this.padRight = padRight;
    }

    public void setPad(int pad) {
        this.padRight = pad;
        this.padLeft = pad;
        this.padTop = pad;
        this.padBottom = pad;
    }

    public void setPadTop(int padTop) {
        this.padTop = padTop;
    }

    public void setRenderHints(Map renderHints) {
        AdvancedImageRenderer.renderHints = renderHints;
    }

    public void setRenderWidth(int renderWidth) {
        this.renderWidth = renderWidth;
    }

    public void setTemplateImage(BufferedImage templateImage) {
        AdvancedImageRenderer.templateImage = templateImage;
    }

    public void setTileBackgroundImage(int tileBackgroundImage) {
        this.tileBackgroundImage = tileBackgroundImage;
    }

    public void setBackgroundImageUrl(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setTrimEdges(int trimEdges) {
        this.trimEdges = trimEdges;
    }

    public void setImageFormatName(String imageFormatName) {
        this.imageFormatName = imageFormatName;
    }

    public String getImageFormatName() {
        return this.imageFormatName;
    }
}

