/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util.charts;

import java.awt.Color;
import java.awt.Paint;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.deliver.util.charts.XMLDataDiagram;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.Spacer;

public class TimeSeriesDiagram
implements XMLDataDiagram {
    private JFreeChart chart;
    private String xmlData;
    private String dateFormat;
    private String header;
    private String axisYHeader;
    private String axisXHeader;
    private String timeGranulariry;

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart chart) {
        this.chart = chart;
    }

    public void renderChart() throws Exception {
        JFreeChart chart;
        XYDataset dataset = this.createDataset();
        this.chart = chart = this.createChart(dataset);
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)this.header, (String)this.axisXHeader, (String)this.axisYHeader, (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        StandardLegend sl = (StandardLegend)chart.getLegend();
        sl.setDisplaySeriesShapes(true);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
            rr.setPlotShapes(true);
            rr.setShapesFilled(true);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        if (this.timeGranulariry.equalsIgnoreCase("Week")) {
            DateTickUnit unit = new DateTickUnit(2, 7, Calendar.getInstance().getFirstDayOfWeek(), (DateFormat)new SimpleDateFormat(this.dateFormat));
            axis.setTickUnit(unit);
            axis.setTickMarkPosition(DateTickMarkPosition.START);
            axis.setDateFormatOverride((DateFormat)new SimpleDateFormat(this.dateFormat));
        } else {
            axis.setDateFormatOverride((DateFormat)new SimpleDateFormat(this.dateFormat));
        }
        return chart;
    }

    private XYDataset createDataset() throws Exception {
        TimeSeriesCollection timeSeriesDataset = new TimeSeriesCollection();
        Document document = new DOMBuilder().getDocument(this.xmlData);
        this.writeDebug(document);
        Element headerElement = (Element)document.selectSingleNode("//chartHeader");
        this.header = headerElement.getText();
        Element axisYHeaderElement = (Element)document.selectSingleNode("//axisYHeader");
        this.axisYHeader = axisYHeaderElement.getText();
        Element axisXHeaderElement = (Element)document.selectSingleNode("//axisXHeader");
        this.axisXHeader = axisXHeaderElement.getText();
        Element timeGranularityElement = (Element)document.selectSingleNode("//timeGranularity");
        this.timeGranulariry = timeGranularityElement.getText();
        Element dateFormatElement = (Element)document.selectSingleNode("//dateFormat");
        this.dateFormat = dateFormatElement.getText();
        List series = document.selectNodes("//Series");
        for (Element serieElement : series) {
            String serieName = serieElement.attributeValue("name");
            TimeSeries s1 = null;
            if (this.timeGranulariry.equalsIgnoreCase("Month")) {
                s1 = new TimeSeries(serieName, Month.class);
            } else if (this.timeGranulariry.equalsIgnoreCase("Week")) {
                s1 = new TimeSeries(serieName, Week.class);
            }
            List items = serieElement.selectNodes("Item");
            for (Element itemElement : items) {
                Element yearElement = (Element)itemElement.selectSingleNode("yearId");
                Element timeElement = (Element)itemElement.selectSingleNode("timeId");
                Element valueElement = (Element)itemElement.selectSingleNode("value");
                String year = yearElement.getText();
                String time = timeElement.getText();
                String value = valueElement.getText();
                if (this.timeGranulariry.equalsIgnoreCase("Month")) {
                    s1.add((RegularTimePeriod)new Month(new Integer(time).intValue(), new Integer(year).intValue()), (Number)new Float(value));
                    continue;
                }
                if (!this.timeGranulariry.equalsIgnoreCase("Week")) continue;
                s1.add((RegularTimePeriod)new Week(new Integer(time).intValue(), new Integer(year).intValue()), (Number)new Float(value));
            }
            timeSeriesDataset.addSeries(s1);
            timeSeriesDataset.setDomainIsPointsInTime(true);
        }
        return timeSeriesDataset;
    }

    public void setDiagramData(String xmlData) {
        this.xmlData = xmlData;
    }

    public void writeDebug(Document document) throws Exception {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((OutputStream)System.out, format);
        writer.write(document);
    }
}

