/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util.charts;

import java.io.File;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;
import org.infoglue.deliver.util.charts.TimeSeriesDiagram;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class ChartHelper {
    private static final Logger logger = Logger.getLogger((String)ChartHelper.class.getName());
    private TemplateController templateController = null;

    public ChartHelper(TemplateController templateController) {
        this.templateController = templateController;
    }

    public String renderGraph(String chartName, String dataAsXML, int width, int height) {
        String assetUrl = "";
        try {
            TimeSeriesDiagram demo = null;
            if (chartName.equals("TimeSeriesDiagram")) {
                demo = new TimeSeriesDiagram();
                demo.setDiagramData(dataAsXML);
                demo.renderChart();
            } else {
                demo = new TimeSeriesDiagram();
                demo.setDiagramData(dataAsXML);
                demo.renderChart();
            }
            String uniqueId = String.valueOf(chartName) + width + height + dataAsXML.length();
            String fileName = String.valueOf(uniqueId) + ".png";
            int i = 0;
            String filePath = CmsPropertyHandler.getDigitalAssetPath0();
            File file = null;
            while (filePath != null) {
                file = new File(String.valueOf(filePath) + File.separator + fileName);
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)demo.getChart(), (int)width, (int)height);
                filePath = CmsPropertyHandler.getProperty("digitalAssetPath." + ++i);
            }
            assetUrl = String.valueOf(this.templateController.getDigitalAssetBaseUrl()) + "/" + file.getName();
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when we tried to generate a graph:" + e.getMessage()), (Throwable)e);
        }
        return assetUrl;
    }
}

