/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.entities.content.impl.simple.ContentImpl;
import org.infoglue.cms.entities.content.impl.simple.DigitalAssetImpl;
import org.infoglue.cms.entities.content.impl.simple.MediumContentImpl;
import org.infoglue.cms.entities.content.impl.simple.MediumDigitalAssetImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallContentImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallDigitalAssetImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallishContentImpl;
import org.infoglue.cms.entities.management.impl.simple.AvailableServiceBindingImpl;
import org.infoglue.cms.entities.management.impl.simple.GroupImpl;
import org.infoglue.cms.entities.management.impl.simple.RoleImpl;
import org.infoglue.cms.entities.management.impl.simple.SmallAvailableServiceBindingImpl;
import org.infoglue.cms.entities.management.impl.simple.SystemUserImpl;
import org.infoglue.cms.entities.publishing.impl.simple.PublicationDetailImpl;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl;
import org.infoglue.cms.entities.structure.impl.simple.SmallSiteNodeImpl;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.databeans.CacheEvictionBean;
import org.infoglue.deliver.controllers.kernel.impl.simple.DigitalAssetDeliveryController;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.RequestAnalyser;

public class WorkingPublicationThread
extends Thread {
    public static final Logger logger = Logger.getLogger((String)WorkingPublicationThread.class.getName());
    private List cacheEvictionBeans = new ArrayList();

    public List getCacheEvictionBeans() {
        return this.cacheEvictionBeans;
    }

    public void run() {
        this.work();
    }

    public void work() {
        logger.info((Object)("cacheEvictionBeans.size:" + this.cacheEvictionBeans.size() + ":" + RequestAnalyser.getRequestAnalyser().getBlockRequests()));
        if (this.cacheEvictionBeans.size() > 0) {
            try {
                for (CacheEvictionBean cacheEvictionBean : this.cacheEvictionBeans) {
                    Object[] idsExtra;
                    Class typesExtra;
                    Object[] ids;
                    String className = cacheEvictionBean.getClassName();
                    String objectId = cacheEvictionBean.getObjectId();
                    String objectName = cacheEvictionBean.getObjectName();
                    String typeId = cacheEvictionBean.getTypeId();
                    logger.info((Object)("className:" + className));
                    logger.info((Object)("objectId:" + objectId));
                    logger.info((Object)("objectName:" + objectName));
                    logger.info((Object)("typeId:" + typeId));
                    boolean isDependsClass = false;
                    if (className != null && className.equalsIgnoreCase(PublicationDetailImpl.class.getName())) {
                        isDependsClass = true;
                    }
                    CacheController.clearCaches(className, objectId, null);
                    logger.info((Object)("Updating className with id:" + className + ":" + objectId));
                    if (className == null || typeId.equalsIgnoreCase("100")) continue;
                    Class<?> type = Class.forName(className);
                    if (!isDependsClass && className.equalsIgnoreCase(SystemUserImpl.class.getName()) || className.equalsIgnoreCase(RoleImpl.class.getName()) || className.equalsIgnoreCase(GroupImpl.class.getName())) {
                        ids = new Object[]{objectId};
                        CacheController.clearCache(type, ids);
                    } else if (!isDependsClass) {
                        ids = new Object[]{new Integer(objectId)};
                        CacheController.clearCache(type, ids);
                    }
                    if (Class.forName(className).getName().equals(ContentImpl.class.getName())) {
                        logger.info((Object)("We clear all small contents as well " + objectId));
                        typesExtra = SmallContentImpl.class;
                        idsExtra = new Object[]{new Integer(objectId)};
                        CacheController.clearCache(typesExtra, idsExtra);
                        logger.info((Object)("We clear all smallish contents as well " + objectId));
                        Class<SmallishContentImpl> typesExtraSmallish = SmallishContentImpl.class;
                        Object[] idsExtraSmallish = new Object[]{new Integer(objectId)};
                        CacheController.clearCache(typesExtraSmallish, idsExtraSmallish);
                        logger.info((Object)("We clear all medium contents as well " + objectId));
                        Class<MediumContentImpl> typesExtraMedium = MediumContentImpl.class;
                        Object[] idsExtraMedium = new Object[]{new Integer(objectId)};
                        CacheController.clearCache(typesExtraMedium, idsExtraMedium);
                    } else if (Class.forName(className).getName().equals(AvailableServiceBindingImpl.class.getName())) {
                        typesExtra = SmallAvailableServiceBindingImpl.class;
                        idsExtra = new Object[]{new Integer(objectId)};
                        CacheController.clearCache(typesExtra, idsExtra);
                    } else if (Class.forName(className).getName().equals(SiteNodeImpl.class.getName())) {
                        typesExtra = SmallSiteNodeImpl.class;
                        idsExtra = new Object[]{new Integer(objectId)};
                        CacheController.clearCache(typesExtra, idsExtra);
                    } else if (Class.forName(className).getName().equals(DigitalAssetImpl.class.getName())) {
                        CacheController.clearCache("digitalAssetCache");
                        typesExtra = SmallDigitalAssetImpl.class;
                        idsExtra = new Object[]{new Integer(objectId)};
                        CacheController.clearCache(typesExtra, idsExtra);
                        Class<MediumDigitalAssetImpl> typesExtraMedium = MediumDigitalAssetImpl.class;
                        Object[] idsExtraMedium = new Object[]{new Integer(objectId)};
                        CacheController.clearCache(typesExtraMedium, idsExtraMedium);
                        String disableAssetDeletionInWorkThread = CmsPropertyHandler.getDisableAssetDeletionInWorkThread();
                        if (disableAssetDeletionInWorkThread != null && !disableAssetDeletionInWorkThread.equals("true")) {
                            logger.info((Object)("We should delete all images with digitalAssetId " + objectId));
                            DigitalAssetDeliveryController.getDigitalAssetDeliveryController().deleteDigitalAssets(new Integer(objectId));
                        }
                    }
                    logger.info((Object)"4");
                }
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred in the WorkingPublicationThread:" + e.getMessage()), (Throwable)e);
            }
        }
        RequestAnalyser.getRequestAnalyser().setBlockRequests(false);
        logger.info((Object)"released block");
    }
}

