/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.infoglue.cms.io.FileHelper;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.actions.InfoGlueComponent;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;
import org.infoglue.deliver.portal.PortalController;
import org.infoglue.deliver.util.CharResponseWrapper;
import org.infoglue.deliver.util.FreemarkerTemplateProcessor;
import org.infoglue.deliver.util.RequestAnalyser;
import org.infoglue.deliver.util.Timer;

public class VelocityTemplateProcessor {
    private static final Logger logger = Logger.getLogger((String)VelocityTemplateProcessor.class.getName());

    public void renderTemplate(Map params, PrintWriter pw, String templateAsString) throws Exception {
        this.renderTemplate(params, pw, templateAsString, false, null);
    }

    public void renderTemplate(Map params, PrintWriter pw, String templateAsString, boolean forceVelocity) throws Exception {
        this.renderTemplate(params, pw, templateAsString, forceVelocity, null);
    }

    public void renderTemplate(Map params, PrintWriter pw, String templateAsString, boolean forceVelocity, InfoGlueComponent component) throws Exception {
        this.renderTemplate(params, pw, templateAsString, forceVelocity, component, null);
    }

    public void renderTemplate(Map params, PrintWriter pw, String templateAsString, boolean forceVelocity, InfoGlueComponent component, String statisticsSuffix) throws Exception {
        try {
            Timer timer = new Timer();
            if (!(forceVelocity || templateAsString.indexOf("<%") <= -1 && templateAsString.indexOf("http://java.sun.com/products/jsp/dtd/jspcore_1_0.dtd") <= -1)) {
                this.dispatchJSP(params, pw, templateAsString, component);
            } else {
                boolean useFreeMarker = false;
                String useFreeMarkerString = CmsPropertyHandler.getUseFreeMarker();
                if (useFreeMarkerString != null && useFreeMarkerString.equalsIgnoreCase("true")) {
                    useFreeMarker = true;
                }
                if ((useFreeMarker || templateAsString.indexOf("<#-- IG:FreeMarker -->") > -1) && !forceVelocity) {
                    FreemarkerTemplateProcessor.getProcessor().renderTemplate(params, pw, templateAsString);
                } else {
                    Velocity.init();
                    VelocityContext context = new VelocityContext();
                    for (String key : params.keySet()) {
                        context.put(key, params.get(key));
                    }
                    StringReader reader = new StringReader(templateAsString);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Going to evaluate the string of length:" + templateAsString.length()));
                    }
                    boolean bl = Velocity.evaluate((Context)context, (Writer)pw, (String)"Generator Error", (Reader)reader);
                }
            }
            String componentName = "Unknown name or not a component";
            if (component != null) {
                componentName = component.getName() + "(" + component.getContentId() + ")";
            }
            RequestAnalyser.getRequestAnalyser().registerComponentStatistics(String.valueOf(componentName) + (statisticsSuffix == null ? "" : statisticsSuffix), timer.getElapsedTime());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Rendering took:" + timer.getElapsedTime()));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("templateAsString: \n" + (templateAsString.length() > 500 ? String.valueOf(templateAsString.substring(0, 500)) + "... (template truncated)." : templateAsString)));
            TemplateController templateController = (TemplateController)params.get("templateLogic");
            DeliveryContext deliveryContext = templateController.getDeliveryContext();
            deliveryContext.setDisablePageCache(true);
            if (CmsPropertyHandler.getOperatingMode().equalsIgnoreCase("0") && (CmsPropertyHandler.getDisableTemplateDebug() == null || !CmsPropertyHandler.getDisableTemplateDebug().equalsIgnoreCase("true"))) {
                pw.println("Error rendering template:" + e.getMessage());
            }
            logger.warn((Object)("Warning rendering template::" + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchJSP(Map params, PrintWriter pw, String templateAsString, InfoGlueComponent component) throws ServletException, IOException, Exception {
        String dir = String.valueOf(CmsPropertyHandler.getContextRootPath()) + "jsp";
        String fileName = component != null ? "Template_" + component.getName().replaceAll("[^\\w]", "") + "_" + templateAsString.hashCode() + ".jsp" : "Template_" + templateAsString.hashCode() + ".jsp";
        File template = new File(dir, fileName);
        String string = fileName.intern();
        synchronized (string) {
            if (!template.exists()) {
                PrintWriter fpw = new PrintWriter(template);
                fpw.print(templateAsString);
                fpw.flush();
                fpw.close();
            }
        }
        TemplateController templateController = (TemplateController)params.get("templateLogic");
        PortalController portletController = (PortalController)params.get("portalLogic");
        DeliveryContext deliveryContext = templateController.getDeliveryContext();
        templateController.getHttpServletRequest().setAttribute("org.infoglue.cms.deliver.templateLogic", (Object)templateController);
        templateController.getHttpServletRequest().setAttribute("org.infoglue.cms.deliver.portalLogic", (Object)portletController);
        CharResponseWrapper wrapper = new CharResponseWrapper(deliveryContext.getHttpServletResponse());
        RequestDispatcher dispatch = templateController.getHttpServletRequest().getRequestDispatcher("/jsp/" + fileName);
        dispatch.include((ServletRequest)templateController.getHttpServletRequest(), (ServletResponse)wrapper);
        pw.println(wrapper.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void dispatchJSP(Map params, PrintWriter pw, String templateAsString) throws ServletException, IOException, Exception {
        Timer timer = new Timer();
        timer.setActive(false);
        int hashCode = templateAsString.hashCode();
        String contextRootPath = CmsPropertyHandler.getContextRootPath();
        String fileName = String.valueOf(contextRootPath) + "jsp" + File.separator + "Template_" + hashCode + ".jsp";
        String tempFileName = String.valueOf(contextRootPath) + "jsp" + File.separator + Thread.currentThread().getId() + "_tmp_Template_" + hashCode + ".jsp";
        File template = new File(fileName);
        File tmpTemplate = new File(tempFileName);
        if (!template.exists()) {
            logger.info((Object)("Going to write template to file: " + template.hashCode()));
            FileHelper.writeToFile(tmpTemplate, templateAsString, false);
            File file = template;
            synchronized (file) {
                if (tmpTemplate.length() == 0L || template.exists()) {
                    logger.info((Object)("written file:" + tmpTemplate.length() + " - removing temp and not renaming it..."));
                    tmpTemplate.delete();
                } else {
                    this.renameTemplate(tmpTemplate, template);
                    logger.info((Object)("Time for renaming file " + timer.getElapsedTime()));
                }
            }
        }
        TemplateController templateController = (TemplateController)params.get("templateLogic");
        PortalController portletController = (PortalController)params.get("portalLogic");
        DeliveryContext deliveryContext = templateController.getDeliveryContext();
        RequestDispatcher dispatch = templateController.getHttpServletRequest().getRequestDispatcher("/jsp/Template_" + hashCode + ".jsp");
        templateController.getHttpServletRequest().setAttribute("org.infoglue.cms.deliver.templateLogic", (Object)templateController);
        templateController.getHttpServletRequest().setAttribute("org.infoglue.cms.deliver.portalLogic", (Object)portletController);
        CharResponseWrapper wrapper = new CharResponseWrapper(deliveryContext.getHttpServletResponse());
        dispatch.include((ServletRequest)templateController.getHttpServletRequest(), (ServletResponse)wrapper);
        String result = wrapper.toString();
        pw.println(result);
    }

    private synchronized void renameTemplate(File tempFile, File newFileName) {
        if (tempFile.length() == 0L || newFileName.exists()) {
            logger.info((Object)("written file:" + newFileName.length() + " - removing temp and not renaming it..."));
            tempFile.delete();
        } else {
            logger.info((Object)("written file:" + tempFile.length() + " - renaming it to " + newFileName.getAbsolutePath()));
            tempFile.renameTo(newFileName);
        }
    }
}

