/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.mail.MailServiceFactory;
import org.infoglue.deliver.util.RequestAnalyser;

public class ThreadMonitor
implements Runnable {
    private static final Logger logger = Logger.getLogger((String)ThreadMonitor.class.getName());
    private Thread targetThread;
    private long millis;
    private long started;
    private Thread watcherThread;
    private boolean loop;
    private boolean enabled;
    private HttpServletRequest request;
    private String message;
    private boolean kill = false;
    private long threadId;
    private static long lastSentTimer = System.currentTimeMillis();

    public ThreadMonitor(Thread targetThread, long millis, HttpServletRequest request, String message, boolean kill) {
        this.targetThread = targetThread;
        this.millis = millis;
        this.started = System.currentTimeMillis();
        this.watcherThread = new Thread(this);
        this.enabled = true;
        this.request = request;
        this.message = message;
        this.kill = kill;
        this.threadId = Thread.currentThread().getId();
        if (millis > 0L) {
            this.watcherThread.start();
        }
    }

    public ThreadMonitor(long millis, HttpServletRequest request, String message, boolean kill) {
        this(Thread.currentThread(), millis, request, message, kill);
    }

    public synchronized void done() {
        this.loop = false;
        this.enabled = false;
        this.notify();
    }

    public synchronized void reset() {
        this.loop = true;
        this.notify();
    }

    public synchronized void reset(long millis) {
        this.millis = millis;
        this.reset();
    }

    public synchronized void run() {
        Thread me = Thread.currentThread();
        me.setPriority(10);
        if (this.enabled) {
            do {
                this.loop = false;
                try {
                    this.wait(this.millis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.enabled && this.loop);
        }
        if (this.enabled && this.targetThread.isAlive()) {
            this.printThread();
            if (this.kill) {
                logger.error((Object)("Trying to kill thread with id:" + this.threadId));
                this.targetThread.stop();
            }
        }
    }

    private void printThread() {
        long now = System.currentTimeMillis();
        if (now - lastSentTimer > 3000L) {
            StackTraceElement[] el = this.targetThread.getStackTrace();
            StringBuffer stackString = new StringBuffer("\n\n" + this.message + "\n\n");
            stackString.append("ServerName: " + this.getServerName() + "\n");
            stackString.append("Maximum memory (MB): " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "\n");
            stackString.append("Used memory (MB): " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L + "\n");
            stackString.append("Free memory (MB): " + Runtime.getRuntime().freeMemory() / 1024L / 1024L + "\n");
            stackString.append("Total memory (MB): " + Runtime.getRuntime().totalMemory() / 1024L / 1024L + "\n");
            stackString.append("Number of current requests: " + RequestAnalyser.getRequestAnalyser().getNumberOfCurrentRequests() + "\n");
            stackString.append("Number of active requests: " + RequestAnalyser.getRequestAnalyser().getNumberOfActiveRequests() + "\n");
            stackString.append("Number of long requests: " + RequestAnalyser.getLongThreadMonitors().size() + "\n");
            stackString.append("Average time: " + RequestAnalyser.getRequestAnalyser().getAverageElapsedTime() + "\n");
            stackString.append("Longest time: " + RequestAnalyser.getRequestAnalyser().getMaxElapsedTime() + "\n");
            stackString.append("Original url: " + this.getOriginalFullURL() + "\n");
            stackString.append("UserInfo: " + this.getUserInfo() + "\n");
            stackString.append("--------------------------------------------\n\n");
            stackString.append("Thread with id [" + this.threadId + "] at report time:\n");
            if (el != null && el.length != 0) {
                int j = 0;
                while (j < el.length) {
                    StackTraceElement frame = el[j];
                    if (frame == null) {
                        stackString.append("    null stack frame\n");
                    } else {
                        stackString.append("    ").append(frame.toString()).append("\n");
                    }
                    if (j > 20) break;
                    ++j;
                }
            }
            stackString.append("\n\n**********************************\nConcurrent long threads (Only an excerpt of all)\n**********************************");
            ThreadMXBean t = ManagementFactory.getThreadMXBean();
            List threadMonitors = RequestAnalyser.getLongThreadMonitors();
            Iterator threadMonitorsIterator = threadMonitors.iterator();
            int threadCount = 0;
            while (threadMonitorsIterator.hasNext() && threadCount < 5) {
                ThreadMonitor tm = (ThreadMonitor)threadMonitorsIterator.next();
                if (this.threadId == tm.getThreadId()) continue;
                long[] threads = new long[]{tm.getThreadId()};
                ThreadInfo[] tinfo = t.getThreadInfo(threads, 20);
                stackString.append("\n\n---------------------------------\nConcurrent long thread [").append(tm.getThreadId()).append("]:\n");
                stackString.append("Elapsed time:").append(tm.getElapsedTime()).append("\n Thread id: ").append(tm.getThreadId()).append("\n Original url: ").append(tm.getOriginalFullURL()).append(")");
                int i = 0;
                while (i < tinfo.length) {
                    ThreadInfo e = tinfo[i];
                    el = e.getStackTrace();
                    if (el != null && el.length != 0) {
                        int n = 0;
                        while (n < el.length) {
                            StackTraceElement frame = el[n];
                            if (frame == null) {
                                stackString.append("    null stack frame\n");
                            } else {
                                stackString.append("    null stack frame").append(frame.toString()).append("\n");
                            }
                            ++n;
                        }
                    }
                    ++i;
                }
                ++threadCount;
            }
            logger.warn((Object)stackString);
            String warningEmailReceiver = CmsPropertyHandler.getWarningEmailReceiver();
            if (warningEmailReceiver != null && !warningEmailReceiver.equals("") && warningEmailReceiver.indexOf("@warningEmailReceiver@") == -1) {
                try {
                    MailServiceFactory.getService().sendEmail(warningEmailReceiver, warningEmailReceiver, null, this.message, stackString.toString().replaceAll("\n", "<br/>"), "utf-8");
                }
                catch (Exception e) {
                    logger.error((Object)("Could not send mail:" + e.getMessage()), (Throwable)e);
                }
            }
            lastSentTimer = System.currentTimeMillis();
        } else {
            logger.warn((Object)"A thread took to long but the system seems to be really clogged so we don't send this one.");
        }
    }

    public String getOriginalFullURL() {
        String originalQueryString;
        String originalRequestURL = this.request.getParameter("originalRequestURL");
        if (originalRequestURL == null || originalRequestURL.length() == 0) {
            originalRequestURL = this.request.getRequestURL().toString();
        }
        if ((originalQueryString = this.request.getParameter("originalQueryString")) == null || originalQueryString.length() == 0) {
            originalQueryString = this.request.getQueryString();
        }
        return String.valueOf(originalRequestURL) + "?" + originalQueryString;
    }

    public String getUserInfo() {
        String userAgent = this.request.getHeader("user-agent");
        if (userAgent != null) {
            userAgent = userAgent.toLowerCase();
        }
        String userIP = this.request.getRemoteAddr();
        return String.valueOf(userAgent) + " (" + userIP + ")";
    }

    public String getServerName() {
        String serverName = "Unknown";
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            serverName = localhost.getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serverName;
    }

    public long getMillis() {
        return this.millis;
    }

    public long getStarted() {
        return this.started;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.started;
    }

    public long getThreadId() {
        return this.threadId;
    }
}

