/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Slots {
    private final List allElements;
    private final int currentSlot;
    private final int slotSize;
    private final int slotCount;
    private final int maxSlots;
    private final List visibleElements;
    private final List visibleSlots;

    public Slots(List allElements, int currentSlot, int slotSize, int slotCount) {
        this.allElements = allElements == null ? new ArrayList() : allElements;
        this.currentSlot = currentSlot;
        this.slotSize = slotSize;
        this.slotCount = slotCount;
        this.maxSlots = this.calculateMaxSlots(this.allElements.size());
        this.validateArguments();
        this.visibleElements = this.calculateVisibleElements();
        this.visibleSlots = this.calculateVisibleSlots();
    }

    public Slots(int currentSlot, int slotSize, int slotCount, int maxSlots) {
        this.allElements = null;
        this.currentSlot = currentSlot;
        this.slotSize = slotSize;
        this.slotCount = slotCount;
        this.maxSlots = maxSlots;
        this.validateArguments();
        this.visibleElements = null;
        this.visibleSlots = this.calculateVisibleSlots();
    }

    public List getVisibleElements() {
        return Collections.unmodifiableList(this.visibleElements);
    }

    public List getVisibleSlots() {
        return Collections.unmodifiableList(this.visibleSlots);
    }

    public Integer getLastSlot() {
        return new Integer(this.maxSlots);
    }

    private void validateArguments() {
        if (this.slotSize <= 0) {
            throw new IllegalArgumentException("Slot size must be a positive number.");
        }
        if (this.slotCount <= 0) {
            throw new IllegalArgumentException("Slot count must be a positive number.");
        }
        if (this.currentSlot <= 0) {
            throw new IllegalArgumentException("Current slot must be a positive number.");
        }
        if (this.currentSlot > this.maxSlots) {
            throw new IllegalArgumentException("Current slot is not a valid slot [" + this.currentSlot + ">" + this.maxSlots + "]");
        }
    }

    private List calculateVisibleElements() {
        return this.allElements.subList(this.getFromElementIndex(), this.getToElementIndex());
    }

    private List calculateVisibleSlots() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int start = this.startSlot();
        int end = Math.min(start + this.slotCount - 1, this.maxSlots);
        int i = start;
        while (i <= end) {
            result.add(new Integer(i));
            ++i;
        }
        return result;
    }

    private int startSlot() {
        if (this.slotCount >= this.maxSlots) {
            return 1;
        }
        return Math.max(1, this.currentSlot - (this.slotCount - 1) / 2);
    }

    private int getFromElementIndex() {
        return (this.currentSlot - 1) * this.slotSize;
    }

    private int getToElementIndex() {
        return Math.min(this.getFromElementIndex() + this.slotSize, this.allElements.size());
    }

    private int calculateMaxSlots(int numberOfElements) {
        if (numberOfElements == 0 || this.slotSize == 0) {
            return 0;
        }
        int mod = numberOfElements / this.slotSize;
        int div = numberOfElements % this.slotSize;
        return mod + (div == 0 ? 0 : 1);
    }
}

