/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.Session;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.entities.management.RepositoryLanguage;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.FakeHttpServletRequest;
import org.infoglue.cms.util.FakeHttpServletResponse;
import org.infoglue.cms.util.FakeHttpSession;
import org.infoglue.deliver.applications.databeans.DatabaseWrapper;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.impl.simple.BasicTemplateController;
import org.infoglue.deliver.controllers.kernel.impl.simple.ExtranetController;
import org.infoglue.deliver.controllers.kernel.impl.simple.IntegrationDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.RepositoryDeliveryController;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;
import org.infoglue.deliver.util.BrowserBean;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.DeliverContextListener;
import org.infoglue.deliver.util.HttpHelper;

public class RequestAndMetaInfoCentricCachePopulator {
    public static final Logger logger = Logger.getLogger((String)RequestAndMetaInfoCentricCachePopulator.class.getName());

    public void recache(DatabaseWrapper dbWrapper, Integer siteNodeId) throws SystemException, Exception {
        LanguageVO masterLanguageVO;
        logger.info((Object)"recache starting..");
        HttpHelper helper = new HttpHelper();
        String recacheUrl = String.valueOf(CmsPropertyHandler.getRecacheUrl()) + "?siteNodeId=" + siteNodeId + "&refresh=true&isRecacheCall=true";
        String response = helper.getUrlContent(recacheUrl, 30000);
        String recacheBaseUrl = CmsPropertyHandler.getRecacheUrl().replaceAll("/ViewPage.action", "");
        String pathsToRecacheOnPublishing = CmsPropertyHandler.getPathsToRecacheOnPublishing();
        if (pathsToRecacheOnPublishing.indexOf("pathsToRecacheOnPublishing") == -1) {
            String[] pathsToRecacheOnPublishingArray = pathsToRecacheOnPublishing.split(",");
            int i = 0;
            while (i < pathsToRecacheOnPublishingArray.length) {
                recacheUrl = String.valueOf(recacheBaseUrl) + pathsToRecacheOnPublishingArray[i] + "?refresh=true&isRecacheCall=true";
                logger.info((Object)("calling recacheUrl:" + recacheUrl));
                ++i;
            }
        }
        if ((masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(dbWrapper.getDatabase(), siteNodeId)) == null) {
            throw new SystemException("There was no master language for the siteNode " + siteNodeId);
        }
        Integer languageId = masterLanguageVO.getLanguageId();
        if (languageId == null) {
            languageId = masterLanguageVO.getLanguageId();
        }
        Integer contentId = new Integer(-1);
        Principal principal = (Principal)CacheController.getCachedObject("userCache", "anonymous");
        if (principal == null) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("j_username", CmsPropertyHandler.getAnonymousUser());
            arguments.put("j_password", CmsPropertyHandler.getAnonymousPassword());
            principal = ExtranetController.getController().getAuthenticatedPrincipal(dbWrapper.getDatabase(), arguments);
            if (principal != null) {
                CacheController.cacheObject("userCache", "anonymous", principal);
            }
        }
        FakeHttpSession fakeHttpServletSession = new FakeHttpSession();
        FakeHttpServletResponse fakeHttpServletResponse = new FakeHttpServletResponse();
        FakeHttpServletRequest fakeHttpServletRequest = new FakeHttpServletRequest();
        fakeHttpServletRequest.setParameter("siteNodeId", "" + siteNodeId);
        fakeHttpServletRequest.setParameter("languageId", "" + languageId);
        fakeHttpServletRequest.setParameter("contentId", "" + contentId);
        fakeHttpServletRequest.setRequestURI("ViewPage.action");
        fakeHttpServletRequest.setAttribute("siteNodeId", (Object)("" + siteNodeId));
        fakeHttpServletRequest.setAttribute("languageId", (Object)("" + languageId));
        fakeHttpServletRequest.setAttribute("contentId", (Object)("" + contentId));
        fakeHttpServletRequest.setServletContext(DeliverContextListener.getServletContext());
        BrowserBean browserBean = new BrowserBean();
        NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId);
        IntegrationDeliveryController integrationDeliveryController = IntegrationDeliveryController.getIntegrationDeliveryController(siteNodeId, languageId, contentId);
        TemplateController templateController = this.getTemplateController(dbWrapper, siteNodeId, languageId, contentId, (HttpServletRequest)new FakeHttpServletRequest(), (InfoGluePrincipal)principal, false, browserBean, nodeDeliveryController, integrationDeliveryController);
        DeliveryContext deliveryContext = DeliveryContext.getDeliveryContext();
        deliveryContext.setSiteNodeId(siteNodeId);
        deliveryContext.setContentId(contentId);
        deliveryContext.setLanguageId(languageId);
        deliveryContext.setPageKey("" + System.currentTimeMillis());
        deliveryContext.setSession(new Session((HttpSession)fakeHttpServletSession));
        deliveryContext.setInfoGlueAbstractAction(null);
        deliveryContext.setHttpServletRequest((HttpServletRequest)fakeHttpServletRequest);
        deliveryContext.setHttpServletResponse((HttpServletResponse)fakeHttpServletResponse);
        templateController.setDeliveryContext(deliveryContext);
        deliveryContext.setDisablePageCache(true);
        SiteNodeVO siteNodeVO = templateController.getSiteNode(siteNodeId);
        SiteNodeVO rootSiteNodeVO = templateController.getRepositoryRootSiteNode(siteNodeVO.getRepositoryId());
        this.recurseSiteNodeTree(rootSiteNodeVO.getId(), languageId, templateController, principal, 1, 0);
        List templates = ContentController.getContentController().getContentVOWithContentTypeDefinition("HTMLTemplate", dbWrapper.getDatabase());
        Iterator templatesIterator = templates.iterator();
        ContentVO template = (ContentVO)templatesIterator.next();
        String string = templateController.getContentAttribute(template.getId(), languageId, "Template", true);
        RepositoryVO repository = RepositoryDeliveryController.getRepositoryDeliveryController().getMasterRepository(dbWrapper.getDatabase());
        RepositoryDeliveryController.getRepositoryDeliveryController().getRepositoryVOListFromServerName(dbWrapper.getDatabase(), "localhost", "8080", repository.getName());
        logger.info((Object)"recache stopped..");
    }

    private void recurseSiteNodeTree(Integer siteNodeId, Integer languageId, TemplateController templateController, Principal principal, int maxLevel, int currentLevel) throws Exception {
        SiteNodeController.getController();
        SiteNode siteNode = SiteNodeController.getSiteNodeWithId(siteNodeId, templateController.getDatabase(), true);
        SiteNodeVO siteNodeVO = templateController.getSiteNode(siteNodeId);
        templateController.getContentAttribute(siteNodeVO.getMetaInfoContentId(), languageId, "Title", true);
        templateController.getContentAttribute(siteNodeVO.getMetaInfoContentId(), languageId, "NavigationTitle", true);
        templateController.getContentAttribute(siteNodeVO.getMetaInfoContentId(), languageId, "NiceURIName", true);
        templateController.getContentAttribute(siteNodeVO.getMetaInfoContentId(), languageId, "Description", true);
        templateController.getContentAttribute(siteNodeVO.getMetaInfoContentId(), languageId, "ComponentStructure", true);
        List childPages = templateController.getChildPages(siteNodeId);
        templateController.getRepositoryRootSiteNode(siteNodeVO.getRepositoryId());
        templateController.getParentSiteNode(siteNodeVO.getId());
        Collection childSiteNodes = siteNode.getChildSiteNodes();
        for (SiteNode childSiteNode : childSiteNodes) {
            if (maxLevel <= currentLevel) continue;
            this.recurseSiteNodeTree(childSiteNode.getId(), languageId, templateController, principal, maxLevel, currentLevel + 1);
        }
        Repository repository = RepositoryController.getController().getRepositoryWithId(siteNodeVO.getRepositoryId(), templateController.getDatabase());
        Collection languages = repository.getRepositoryLanguages();
        for (RepositoryLanguage repositoryLanguage : languages) {
            LanguageDeliveryController.getLanguageDeliveryController().getLanguageIfSiteNodeSupportsIt(templateController.getDatabase(), repositoryLanguage.getLanguage().getId(), siteNodeId);
        }
        Integer contentId = new Integer(-1);
        FakeHttpSession fakeHttpServletSession = new FakeHttpSession();
        FakeHttpServletResponse fakeHttpServletResponse = new FakeHttpServletResponse();
        FakeHttpServletRequest fakeHttpServletRequest = new FakeHttpServletRequest();
        fakeHttpServletRequest.setParameter("siteNodeId", "" + siteNodeId);
        fakeHttpServletRequest.setParameter("languageId", "" + languageId);
        fakeHttpServletRequest.setParameter("contentId", "" + contentId);
        fakeHttpServletRequest.setRequestURI("ViewPage.action");
        fakeHttpServletRequest.setAttribute("siteNodeId", (Object)("" + siteNodeId));
        fakeHttpServletRequest.setAttribute("languageId", (Object)("" + languageId));
        fakeHttpServletRequest.setAttribute("contentId", (Object)("" + contentId));
        fakeHttpServletRequest.setServletContext(DeliverContextListener.getServletContext());
        BrowserBean browserBean = new BrowserBean();
        NodeDeliveryController nodeDeliveryController = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, contentId);
        IntegrationDeliveryController integrationDeliveryController = IntegrationDeliveryController.getIntegrationDeliveryController(siteNodeId, languageId, contentId);
        TemplateController subTemplateController = this.getTemplateController(templateController.getDatabaseWrapper(), siteNodeId, languageId, contentId, (HttpServletRequest)new FakeHttpServletRequest(), (InfoGluePrincipal)principal, false, browserBean, nodeDeliveryController, integrationDeliveryController);
        DeliveryContext deliveryContext = DeliveryContext.getDeliveryContext();
        deliveryContext.setSiteNodeId(siteNodeId);
        deliveryContext.setContentId(contentId);
        deliveryContext.setLanguageId(languageId);
        deliveryContext.setPageKey("" + System.currentTimeMillis());
        deliveryContext.setSession(new Session((HttpSession)fakeHttpServletSession));
        deliveryContext.setInfoGlueAbstractAction(null);
        deliveryContext.setHttpServletRequest((HttpServletRequest)fakeHttpServletRequest);
        deliveryContext.setHttpServletResponse((HttpServletResponse)fakeHttpServletResponse);
        subTemplateController.setDeliveryContext(deliveryContext);
        deliveryContext.setDisablePageCache(true);
        SiteNodeVO rootSiteNodeVO = templateController.getRepositoryRootSiteNode(siteNodeVO.getRepositoryId());
        String pagePath = subTemplateController.getCurrentPagePath();
        CacheController.cacheObject("newPagePathCache", deliveryContext.getPageKey(), pagePath);
    }

    public TemplateController getTemplateController(DatabaseWrapper dbWrapper, Integer siteNodeId, Integer languageId, Integer contentId, HttpServletRequest request, InfoGluePrincipal infoGluePrincipal, boolean allowEditOnSightAtAll, BrowserBean browserBean, NodeDeliveryController nodeDeliveryController, IntegrationDeliveryController integrationDeliveryController) throws SystemException, Exception {
        BasicTemplateController templateController = new BasicTemplateController(dbWrapper, infoGluePrincipal);
        templateController.setStandardRequestParameters(siteNodeId, languageId, contentId);
        templateController.setHttpRequest(request);
        templateController.setBrowserBean(browserBean);
        templateController.setDeliveryControllers(nodeDeliveryController, null, integrationDeliveryController);
        return templateController;
    }
}

