/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.deliver.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infoglue.deliver.util.Blocker;
import org.infoglue.deliver.util.Counter;
import org.infoglue.deliver.util.ThreadMonitor;

public class RequestAnalyser {
    private static RequestAnalyser instance = new RequestAnalyser();
    private static Map threadMonitors = new HashMap();
    private static boolean blockRequests = false;

    public static RequestAnalyser getRequestAnalyser() {
        return instance;
    }

    public int getNumberOfCurrentRequests() {
        return Counter.getNumberOfCurrentRequests();
    }

    public int getNumberOfActiveRequests() {
        return Counter.getNumberOfActiveRequests();
    }

    public int getTotalNumberOfRequests() {
        return Counter.getTotalNumberOfRequests();
    }

    public long getAverageElapsedTime() {
        return Counter.getAverageElapsedTime();
    }

    public long getMaxElapsedTime() {
        return Counter.getMaxElapsedTime();
    }

    public List getLatestPublications() {
        return Counter.getLatestPublications();
    }

    public void addPublication(Date publicationDate) {
        Counter.addPublication(publicationDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incNumberOfCurrentRequests(ThreadMonitor tk) {
        if (tk == null) {
            Counter.incNumberOfCurrentRequests(false);
        } else {
            Counter.incNumberOfCurrentRequests(true);
        }
        if (tk != null) {
            Map map = threadMonitors;
            synchronized (map) {
                threadMonitors.put("" + Thread.currentThread().getId(), tk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void decNumberOfCurrentRequests(long elapsedTime) {
        Counter.decNumberOfCurrentRequests(elapsedTime);
        Map map = threadMonitors;
        synchronized (map) {
            threadMonitors.remove("" + Thread.currentThread().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getLongThreadMonitors() {
        ArrayList<ThreadMonitor> longThreads = new ArrayList<ThreadMonitor>();
        Map map = threadMonitors;
        synchronized (map) {
            for (ThreadMonitor tm : threadMonitors.values()) {
                long passedTime = System.currentTimeMillis() - tm.getStarted();
                if (passedTime <= 10000L) continue;
                longThreads.add(tm);
            }
        }
        return longThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getThreadMonitors() {
        ArrayList<ThreadMonitor> threads = new ArrayList<ThreadMonitor>();
        Map map = threadMonitors;
        synchronized (map) {
            for (ThreadMonitor tm : threadMonitors.values()) {
                threads.add(tm);
            }
        }
        return threads;
    }

    public synchronized void registerComponentStatistics(String componentName, long elapsedTime) {
        Counter.registerComponentStatistics(componentName, elapsedTime);
    }

    public static Set getAllComponentNames() {
        return Counter.getAllComponentNames();
    }

    public static long getComponentAverageElapsedTime(String componentName) {
        return Counter.getAverageElapsedTime(componentName);
    }

    public static int getComponentNumberOfHits(String componentName) {
        return Counter.getNumberOfHits(componentName);
    }

    public static void resetComponentStatistics() {
        Counter.resetComponentStatistics();
    }

    public boolean getBlockRequests() {
        return Blocker.getIsBlocking();
    }

    public void setBlockRequests(boolean blockRequests) {
        Blocker.setBlocking(blockRequests);
    }
}

